/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimMeta;
import datameshmanager.sdk.client.model.ScimSchemaAttribute;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "id", "name", "description", "attributes", "meta"})
public class ScimSchema {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Schema"));
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    @Nullable
    private List<ScimSchemaAttribute> attributes = new ArrayList<ScimSchemaAttribute>();
    public static final String JSON_PROPERTY_META = "meta";
    @Nullable
    private ScimMeta meta;

    public ScimSchema schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimSchema addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Schema"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimSchema id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public ScimSchema name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public ScimSchema description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public ScimSchema attributes(@Nullable List<ScimSchemaAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ScimSchema addAttributesItem(ScimSchemaAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ScimSchemaAttribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScimSchemaAttribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(@Nullable List<ScimSchemaAttribute> attributes) {
        this.attributes = attributes;
    }

    public ScimSchema meta(@Nullable ScimMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimMeta getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(@Nullable ScimMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimSchema scimSchema = (ScimSchema)o;
        return Objects.equals(this.schemas, scimSchema.schemas) && Objects.equals(this.id, scimSchema.id) && Objects.equals(this.name, scimSchema.name) && Objects.equals(this.description, scimSchema.description) && Objects.equals(this.attributes, scimSchema.attributes) && Objects.equals(this.meta, scimSchema.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.id, this.name, this.description, this.attributes, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimSchema {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributes() != null) {
            for (i = 0; i < this.getAttributes().size(); ++i) {
                if (this.getAttributes().get(i) == null) continue;
                joiner.add(this.getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMeta() != null) {
            joiner.add(this.getMeta().toUrlQueryString((String)prefix + JSON_PROPERTY_META + suffix));
        }
        return joiner.toString();
    }
}

