/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schema", "required"})
public class ScimSchemaExtension {
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nullable
    private String schema;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    @Nullable
    private Boolean required;

    public ScimSchemaExtension schema(@Nullable String schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(@Nullable String schema) {
        this.schema = schema;
    }

    public ScimSchemaExtension required(@Nullable Boolean required) {
        this.required = required;
        return this;
    }

    @Nullable
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(@Nullable Boolean required) {
        this.required = required;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimSchemaExtension scimSchemaExtension = (ScimSchemaExtension)o;
        return Objects.equals(this.schema, scimSchemaExtension.schema) && Objects.equals(this.required, scimSchemaExtension.required);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.required);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimSchemaExtension {\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchema() != null) {
            try {
                joiner.add(String.format("%sschema%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSchema()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRequired() != null) {
            try {
                joiner.add(String.format("%srequired%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRequired()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

