/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimAuthenticationScheme;
import datameshmanager.sdk.client.model.ScimFilterConfig;
import datameshmanager.sdk.client.model.ScimMeta;
import datameshmanager.sdk.client.model.ScimSupportedFeature;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "documentationUri", "patch", "bulk", "filter", "changePassword", "sort", "etag", "authenticationSchemes", "meta"})
public class ScimServiceProviderConfig {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig"));
    public static final String JSON_PROPERTY_DOCUMENTATION_URI = "documentationUri";
    @Nullable
    private String documentationUri;
    public static final String JSON_PROPERTY_PATCH = "patch";
    @Nullable
    private ScimSupportedFeature patch;
    public static final String JSON_PROPERTY_BULK = "bulk";
    @Nullable
    private ScimSupportedFeature bulk;
    public static final String JSON_PROPERTY_FILTER = "filter";
    @Nullable
    private ScimFilterConfig filter;
    public static final String JSON_PROPERTY_CHANGE_PASSWORD = "changePassword";
    @Nullable
    private ScimSupportedFeature changePassword;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private ScimSupportedFeature sort;
    public static final String JSON_PROPERTY_ETAG = "etag";
    @Nullable
    private ScimSupportedFeature etag;
    public static final String JSON_PROPERTY_AUTHENTICATION_SCHEMES = "authenticationSchemes";
    @Nullable
    private List<ScimAuthenticationScheme> authenticationSchemes = new ArrayList<ScimAuthenticationScheme>();
    public static final String JSON_PROPERTY_META = "meta";
    @Nullable
    private ScimMeta meta;

    public ScimServiceProviderConfig schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimServiceProviderConfig addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimServiceProviderConfig documentationUri(@Nullable String documentationUri) {
        this.documentationUri = documentationUri;
        return this;
    }

    @Nullable
    @JsonProperty(value="documentationUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDocumentationUri() {
        return this.documentationUri;
    }

    @JsonProperty(value="documentationUri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentationUri(@Nullable String documentationUri) {
        this.documentationUri = documentationUri;
    }

    public ScimServiceProviderConfig patch(@Nullable ScimSupportedFeature patch) {
        this.patch = patch;
        return this;
    }

    @Nullable
    @JsonProperty(value="patch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimSupportedFeature getPatch() {
        return this.patch;
    }

    @JsonProperty(value="patch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPatch(@Nullable ScimSupportedFeature patch) {
        this.patch = patch;
    }

    public ScimServiceProviderConfig bulk(@Nullable ScimSupportedFeature bulk) {
        this.bulk = bulk;
        return this;
    }

    @Nullable
    @JsonProperty(value="bulk")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimSupportedFeature getBulk() {
        return this.bulk;
    }

    @JsonProperty(value="bulk")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBulk(@Nullable ScimSupportedFeature bulk) {
        this.bulk = bulk;
    }

    public ScimServiceProviderConfig filter(@Nullable ScimFilterConfig filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimFilterConfig getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(@Nullable ScimFilterConfig filter) {
        this.filter = filter;
    }

    public ScimServiceProviderConfig changePassword(@Nullable ScimSupportedFeature changePassword) {
        this.changePassword = changePassword;
        return this;
    }

    @Nullable
    @JsonProperty(value="changePassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimSupportedFeature getChangePassword() {
        return this.changePassword;
    }

    @JsonProperty(value="changePassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangePassword(@Nullable ScimSupportedFeature changePassword) {
        this.changePassword = changePassword;
    }

    public ScimServiceProviderConfig sort(@Nullable ScimSupportedFeature sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimSupportedFeature getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable ScimSupportedFeature sort) {
        this.sort = sort;
    }

    public ScimServiceProviderConfig etag(@Nullable ScimSupportedFeature etag) {
        this.etag = etag;
        return this;
    }

    @Nullable
    @JsonProperty(value="etag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimSupportedFeature getEtag() {
        return this.etag;
    }

    @JsonProperty(value="etag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEtag(@Nullable ScimSupportedFeature etag) {
        this.etag = etag;
    }

    public ScimServiceProviderConfig authenticationSchemes(@Nullable List<ScimAuthenticationScheme> authenticationSchemes) {
        this.authenticationSchemes = authenticationSchemes;
        return this;
    }

    public ScimServiceProviderConfig addAuthenticationSchemesItem(ScimAuthenticationScheme authenticationSchemesItem) {
        if (this.authenticationSchemes == null) {
            this.authenticationSchemes = new ArrayList<ScimAuthenticationScheme>();
        }
        this.authenticationSchemes.add(authenticationSchemesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="authenticationSchemes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScimAuthenticationScheme> getAuthenticationSchemes() {
        return this.authenticationSchemes;
    }

    @JsonProperty(value="authenticationSchemes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationSchemes(@Nullable List<ScimAuthenticationScheme> authenticationSchemes) {
        this.authenticationSchemes = authenticationSchemes;
    }

    public ScimServiceProviderConfig meta(@Nullable ScimMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimMeta getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(@Nullable ScimMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimServiceProviderConfig scimServiceProviderConfig = (ScimServiceProviderConfig)o;
        return Objects.equals(this.schemas, scimServiceProviderConfig.schemas) && Objects.equals(this.documentationUri, scimServiceProviderConfig.documentationUri) && Objects.equals(this.patch, scimServiceProviderConfig.patch) && Objects.equals(this.bulk, scimServiceProviderConfig.bulk) && Objects.equals(this.filter, scimServiceProviderConfig.filter) && Objects.equals(this.changePassword, scimServiceProviderConfig.changePassword) && Objects.equals(this.sort, scimServiceProviderConfig.sort) && Objects.equals(this.etag, scimServiceProviderConfig.etag) && Objects.equals(this.authenticationSchemes, scimServiceProviderConfig.authenticationSchemes) && Objects.equals(this.meta, scimServiceProviderConfig.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.documentationUri, this.patch, this.bulk, this.filter, this.changePassword, this.sort, this.etag, this.authenticationSchemes, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimServiceProviderConfig {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    documentationUri: ").append(this.toIndentedString(this.documentationUri)).append("\n");
        sb.append("    patch: ").append(this.toIndentedString(this.patch)).append("\n");
        sb.append("    bulk: ").append(this.toIndentedString(this.bulk)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    changePassword: ").append(this.toIndentedString(this.changePassword)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    etag: ").append(this.toIndentedString(this.etag)).append("\n");
        sb.append("    authenticationSchemes: ").append(this.toIndentedString(this.authenticationSchemes)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getDocumentationUri() != null) {
            try {
                joiner.add(String.format("%sdocumentationUri%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDocumentationUri()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPatch() != null) {
            joiner.add(this.getPatch().toUrlQueryString((String)prefix + JSON_PROPERTY_PATCH + suffix));
        }
        if (this.getBulk() != null) {
            joiner.add(this.getBulk().toUrlQueryString((String)prefix + JSON_PROPERTY_BULK + suffix));
        }
        if (this.getFilter() != null) {
            joiner.add(this.getFilter().toUrlQueryString((String)prefix + JSON_PROPERTY_FILTER + suffix));
        }
        if (this.getChangePassword() != null) {
            joiner.add(this.getChangePassword().toUrlQueryString((String)prefix + JSON_PROPERTY_CHANGE_PASSWORD + suffix));
        }
        if (this.getSort() != null) {
            joiner.add(this.getSort().toUrlQueryString((String)prefix + JSON_PROPERTY_SORT + suffix));
        }
        if (this.getEtag() != null) {
            joiner.add(this.getEtag().toUrlQueryString((String)prefix + JSON_PROPERTY_ETAG + suffix));
        }
        if (this.getAuthenticationSchemes() != null) {
            for (i = 0; i < this.getAuthenticationSchemes().size(); ++i) {
                if (this.getAuthenticationSchemes().get(i) == null) continue;
                joiner.add(this.getAuthenticationSchemes().get(i).toUrlQueryString(String.format("%sauthenticationSchemes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMeta() != null) {
            joiner.add(this.getMeta().toUrlQueryString((String)prefix + JSON_PROPERTY_META + suffix));
        }
        return joiner.toString();
    }
}

