/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimEmail;
import datameshmanager.sdk.client.model.ScimMeta;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "id", "externalId", "userName", "displayName", "emails", "active", "meta"})
public class ScimUser {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:User"));
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    @Nullable
    private String externalId;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    @Nonnull
    private String userName;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_EMAILS = "emails";
    @Nullable
    private List<ScimEmail> emails = new ArrayList<ScimEmail>();
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nullable
    private Boolean active = true;
    public static final String JSON_PROPERTY_META = "meta";
    @Nullable
    private ScimMeta meta;

    public ScimUser schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimUser addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:User"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimUser id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public ScimUser externalId(@Nullable String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(@Nullable String externalId) {
        this.externalId = externalId;
    }

    public ScimUser userName(@Nonnull String userName) {
        this.userName = userName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserName(@Nonnull String userName) {
        this.userName = userName;
    }

    public ScimUser displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public ScimUser emails(@Nullable List<ScimEmail> emails) {
        this.emails = emails;
        return this;
    }

    public ScimUser addEmailsItem(ScimEmail emailsItem) {
        if (this.emails == null) {
            this.emails = new ArrayList<ScimEmail>();
        }
        this.emails.add(emailsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="emails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    @JsonProperty(value="emails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmails(@Nullable List<ScimEmail> emails) {
        this.emails = emails;
    }

    public ScimUser active(@Nullable Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(@Nullable Boolean active) {
        this.active = active;
    }

    public ScimUser meta(@Nullable ScimMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimMeta getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(@Nullable ScimMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimUser scimUser = (ScimUser)o;
        return Objects.equals(this.schemas, scimUser.schemas) && Objects.equals(this.id, scimUser.id) && Objects.equals(this.externalId, scimUser.externalId) && Objects.equals(this.userName, scimUser.userName) && Objects.equals(this.displayName, scimUser.displayName) && Objects.equals(this.emails, scimUser.emails) && Objects.equals(this.active, scimUser.active) && Objects.equals(this.meta, scimUser.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.id, this.externalId, this.userName, this.displayName, this.emails, this.active, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimUser {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getExternalId() != null) {
            try {
                joiner.add(String.format("%sexternalId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExternalId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUserName() != null) {
            try {
                joiner.add(String.format("%suserName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDisplayName() != null) {
            try {
                joiner.add(String.format("%sdisplayName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDisplayName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmails() != null) {
            for (i = 0; i < this.getEmails().size(); ++i) {
                if (this.getEmails().get(i) == null) continue;
                joiner.add(this.getEmails().get(i).toUrlQueryString(String.format("%semails%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getActive() != null) {
            try {
                joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getActive()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMeta() != null) {
            joiner.add(this.getMeta().toUrlQueryString((String)prefix + JSON_PROPERTY_META + suffix));
        }
        return joiner.toString();
    }
}

