/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.TagInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "info", "links", "properties"})
public class Tag {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_INFO = "info";
    @Nullable
    private TagInfo info;
    public static final String JSON_PROPERTY_LINKS = "links";
    @Nullable
    private Map<String, String> links = new HashMap<String, String>();
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    @Nullable
    private Map<String, String> properties = new HashMap<String, String>();

    public Tag id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Tag info(@Nullable TagInfo info) {
        this.info = info;
        return this;
    }

    @Nullable
    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TagInfo getInfo() {
        return this.info;
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfo(@Nullable TagInfo info) {
        this.info = info;
    }

    public Tag links(@Nullable Map<String, String> links) {
        this.links = links;
        return this;
    }

    public Tag putLinksItem(String key, String linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, String>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(@Nullable Map<String, String> links) {
        this.links = links;
    }

    public Tag properties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Tag putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.id, tag.id) && Objects.equals(this.info, tag.info) && Objects.equals(this.links, tag.links) && Objects.equals(this.properties, tag.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.links, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tag {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInfo() != null) {
            joiner.add(this.getInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_INFO + suffix));
        }
        if (this.getLinks() != null) {
            for (String _key : this.getLinks().keySet()) {
                try {
                    joiner.add(String.format("%slinks%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getLinks().get(_key), URLEncoder.encode(String.valueOf(this.getLinks().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                try {
                    joiner.add(String.format("%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), URLEncoder.encode(String.valueOf(this.getProperties().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

