/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import datameshmanager.sdk.client.model.TeamMembersInner;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "parent", "type", "description", "members", "tags", "links", "custom"})
public class Team {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PARENT = "parent";
    @Nullable
    private String parent;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_MEMBERS = "members";
    @Nullable
    private List<TeamMembersInner> members = new ArrayList<TeamMembersInner>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_LINKS = "links";
    @Nullable
    private Map<String, String> links = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    @Nullable
    private Map<String, String> custom = new HashMap<String, String>();

    public Team id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Team name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Team parent(@Nullable String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParent(@Nullable String parent) {
        this.parent = parent;
    }

    public Team type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public Team description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Team members(@Nullable List<TeamMembersInner> members) {
        this.members = members;
        return this;
    }

    public Team addMembersItem(TeamMembersInner membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<TeamMembersInner>();
        }
        this.members.add(membersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TeamMembersInner> getMembers() {
        return this.members;
    }

    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMembers(@Nullable List<TeamMembersInner> members) {
        this.members = members;
    }

    public Team tags(@Nullable List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Team addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<String> tags) {
        this.tags = tags;
    }

    public Team links(@Nullable Map<String, String> links) {
        this.links = links;
        return this;
    }

    public Team putLinksItem(String key, String linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, String>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(@Nullable Map<String, String> links) {
        this.links = links;
    }

    public Team custom(@Nullable Map<String, String> custom) {
        this.custom = custom;
        return this;
    }

    public Team putCustomItem(String key, String customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, String>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustom(@Nullable Map<String, String> custom) {
        this.custom = custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return Objects.equals(this.id, team.id) && Objects.equals(this.name, team.name) && Objects.equals(this.parent, team.parent) && Objects.equals((Object)this.type, (Object)team.type) && Objects.equals(this.description, team.description) && Objects.equals(this.members, team.members) && Objects.equals(this.tags, team.tags) && Objects.equals(this.links, team.links) && Objects.equals(this.custom, team.custom);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.parent, this.type, this.description, this.members, this.tags, this.links, this.custom});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Team {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getParent() != null) {
            try {
                joiner.add(String.format("%sparent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getParent()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMembers() != null) {
            for (i = 0; i < this.getMembers().size(); ++i) {
                if (this.getMembers().get(i) == null) continue;
                joiner.add(this.getMembers().get(i).toUrlQueryString(String.format("%smembers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getTags() != null) {
            for (i = 0; i < this.getTags().size(); ++i) {
                try {
                    joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTags().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLinks() != null) {
            for (String _key : this.getLinks().keySet()) {
                try {
                    joiner.add(String.format("%slinks%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getLinks().get(_key), URLEncoder.encode(String.valueOf(this.getLinks().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCustom() != null) {
            for (String _key : this.getCustom().keySet()) {
                try {
                    joiner.add(String.format("%scustom%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustom().get(_key), URLEncoder.encode(String.valueOf(this.getCustom().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        DOMAIN(String.valueOf("Domain")),
        TEAM(String.valueOf("Team")),
        DOMAIN_TEAM(String.valueOf("Domain Team")),
        ENABLING_TEAM(String.valueOf("Enabling Team")),
        PLATFORM_TEAM(String.valueOf("Platform Team")),
        GOVERNANCE_GROUP(String.valueOf("Governance Group"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

