/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import datameshmanager.sdk.client.model.TestResultsChecksInner;
import datameshmanager.sdk.client.model.TestResultsLogsInner;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "dataContractId", "dataContractVersion", "server", "timestampStart", "timestampEnd", "result", "checks", "logs"})
public class TestResults {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_DATA_CONTRACT_ID = "dataContractId";
    @Nonnull
    private String dataContractId;
    public static final String JSON_PROPERTY_DATA_CONTRACT_VERSION = "dataContractVersion";
    @Nonnull
    private String dataContractVersion;
    public static final String JSON_PROPERTY_SERVER = "server";
    @Nonnull
    private String server;
    public static final String JSON_PROPERTY_TIMESTAMP_START = "timestampStart";
    @Nonnull
    private OffsetDateTime timestampStart;
    public static final String JSON_PROPERTY_TIMESTAMP_END = "timestampEnd";
    @Nonnull
    private OffsetDateTime timestampEnd;
    public static final String JSON_PROPERTY_RESULT = "result";
    @Nonnull
    private ResultEnum result;
    public static final String JSON_PROPERTY_CHECKS = "checks";
    @Nullable
    private List<TestResultsChecksInner> checks = new ArrayList<TestResultsChecksInner>();
    public static final String JSON_PROPERTY_LOGS = "logs";
    @Nullable
    private List<TestResultsLogsInner> logs = new ArrayList<TestResultsLogsInner>();

    public TestResults id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public TestResults dataContractId(@Nonnull String dataContractId) {
        this.dataContractId = dataContractId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dataContractId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDataContractId() {
        return this.dataContractId;
    }

    @JsonProperty(value="dataContractId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDataContractId(@Nonnull String dataContractId) {
        this.dataContractId = dataContractId;
    }

    public TestResults dataContractVersion(@Nonnull String dataContractVersion) {
        this.dataContractVersion = dataContractVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dataContractVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDataContractVersion() {
        return this.dataContractVersion;
    }

    @JsonProperty(value="dataContractVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDataContractVersion(@Nonnull String dataContractVersion) {
        this.dataContractVersion = dataContractVersion;
    }

    public TestResults server(@Nonnull String server) {
        this.server = server;
        return this;
    }

    @Nonnull
    @JsonProperty(value="server")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServer(@Nonnull String server) {
        this.server = server;
    }

    public TestResults timestampStart(@Nonnull OffsetDateTime timestampStart) {
        this.timestampStart = timestampStart;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestampStart")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getTimestampStart() {
        return this.timestampStart;
    }

    @JsonProperty(value="timestampStart")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestampStart(@Nonnull OffsetDateTime timestampStart) {
        this.timestampStart = timestampStart;
    }

    public TestResults timestampEnd(@Nonnull OffsetDateTime timestampEnd) {
        this.timestampEnd = timestampEnd;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestampEnd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getTimestampEnd() {
        return this.timestampEnd;
    }

    @JsonProperty(value="timestampEnd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestampEnd(@Nonnull OffsetDateTime timestampEnd) {
        this.timestampEnd = timestampEnd;
    }

    public TestResults result(@Nonnull ResultEnum result) {
        this.result = result;
        return this;
    }

    @Nonnull
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ResultEnum getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResult(@Nonnull ResultEnum result) {
        this.result = result;
    }

    public TestResults checks(@Nullable List<TestResultsChecksInner> checks) {
        this.checks = checks;
        return this;
    }

    public TestResults addChecksItem(TestResultsChecksInner checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<TestResultsChecksInner>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestResultsChecksInner> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(@Nullable List<TestResultsChecksInner> checks) {
        this.checks = checks;
    }

    public TestResults logs(@Nullable List<TestResultsLogsInner> logs) {
        this.logs = logs;
        return this;
    }

    public TestResults addLogsItem(TestResultsLogsInner logsItem) {
        if (this.logs == null) {
            this.logs = new ArrayList<TestResultsLogsInner>();
        }
        this.logs.add(logsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="logs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestResultsLogsInner> getLogs() {
        return this.logs;
    }

    @JsonProperty(value="logs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogs(@Nullable List<TestResultsLogsInner> logs) {
        this.logs = logs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResults testResults = (TestResults)o;
        return Objects.equals(this.id, testResults.id) && Objects.equals(this.dataContractId, testResults.dataContractId) && Objects.equals(this.dataContractVersion, testResults.dataContractVersion) && Objects.equals(this.server, testResults.server) && Objects.equals(this.timestampStart, testResults.timestampStart) && Objects.equals(this.timestampEnd, testResults.timestampEnd) && Objects.equals((Object)this.result, (Object)testResults.result) && Objects.equals(this.checks, testResults.checks) && Objects.equals(this.logs, testResults.logs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.dataContractId, this.dataContractVersion, this.server, this.timestampStart, this.timestampEnd, this.result, this.checks, this.logs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestResults {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dataContractId: ").append(this.toIndentedString(this.dataContractId)).append("\n");
        sb.append("    dataContractVersion: ").append(this.toIndentedString(this.dataContractVersion)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    timestampStart: ").append(this.toIndentedString(this.timestampStart)).append("\n");
        sb.append("    timestampEnd: ").append(this.toIndentedString(this.timestampEnd)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDataContractId() != null) {
            try {
                joiner.add(String.format("%sdataContractId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDataContractId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDataContractVersion() != null) {
            try {
                joiner.add(String.format("%sdataContractVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDataContractVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getServer() != null) {
            try {
                joiner.add(String.format("%sserver%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getServer()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTimestampStart() != null) {
            try {
                joiner.add(String.format("%stimestampStart%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimestampStart()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTimestampEnd() != null) {
            try {
                joiner.add(String.format("%stimestampEnd%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimestampEnd()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResult() != null) {
            try {
                joiner.add(String.format("%sresult%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getResult()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getChecks() != null) {
            for (i = 0; i < this.getChecks().size(); ++i) {
                if (this.getChecks().get(i) == null) continue;
                joiner.add(this.getChecks().get(i).toUrlQueryString(String.format("%schecks%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getLogs() != null) {
            for (i = 0; i < this.getLogs().size(); ++i) {
                if (this.getLogs().get(i) == null) continue;
                joiner.add(this.getLogs().get(i).toUrlQueryString(String.format("%slogs%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum ResultEnum {
        PASSED(String.valueOf("passed")),
        FAILED(String.valueOf("failed")),
        WARNING(String.valueOf("warning")),
        ERROR(String.valueOf("error")),
        UNKNOWN(String.valueOf("unknown"));

        private String value;

        private ResultEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultEnum fromValue(String value) {
            for (ResultEnum b : ResultEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

