/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.kcql;

import com.datamountaineer.kcql.Bucketing;
import com.datamountaineer.kcql.CompressionType;
import com.datamountaineer.kcql.EnumsHelper;
import com.datamountaineer.kcql.Field;
import com.datamountaineer.kcql.FieldType;
import com.datamountaineer.kcql.FormatType;
import com.datamountaineer.kcql.PartitionOffset;
import com.datamountaineer.kcql.PartitioningStrategy;
import com.datamountaineer.kcql.SchemaEvolution;
import com.datamountaineer.kcql.Tag;
import com.datamountaineer.kcql.WriteModeEnum;
import com.datamountaineer.kcql.antlr4.ConnectorLexer;
import com.datamountaineer.kcql.antlr4.ConnectorParser;
import com.datamountaineer.kcql.antlr4.ConnectorParserBaseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Kcql {
    public static final String TIMESTAMP = "sys_time()";
    private boolean autoCreate;
    private boolean autoEvolve;
    private boolean enableCapitalize;
    private WriteModeEnum writeMode;
    private String source;
    private String target;
    private String docType;
    private String indexSuffix;
    private String incrementalMode;
    private List<Field> fields = new ArrayList<Field>();
    private List<Field> ignoredFields = new ArrayList<Field>();
    private List<Field> primaryKeys = new ArrayList<Field>();
    private List<String> partitionBy = new ArrayList<String>();
    private int retries = 1;
    private int limit = 0;
    private int batchSize;
    private Bucketing bucketing;
    private String timestamp;
    private String storedAs;
    private Map<String, String> storedAsParameters = new HashMap<String, String>();
    private String consumerGroup;
    private List<PartitionOffset> partitions = null;
    private Integer sampleCount;
    private Integer sampleRate;
    private FormatType formatType = null;
    private boolean initialize;
    private boolean unwrapping = false;
    private Integer projectTo;
    private List<Tag> tags;
    private boolean retainStructure = false;
    private String withConverter;
    private long ttl;
    private String withType;
    private String withJmsSelector;
    private String dynamicTarget;
    private List<String> withKeys = null;
    private String keyDelimeter = ".";
    private TimeUnit timestampUnit = TimeUnit.MILLISECONDS;
    private String pipeline;
    private CompressionType compression;
    private String subscription;
    private String partitioner;
    private String withRegex;
    private long withFlushInterval;
    private long withFlushSize;
    private long withFlushCount;
    private SchemaEvolution withSchemaEvolution = SchemaEvolution.MATCH;
    private String withTableLocation;
    private boolean withOverwrite;
    private PartitioningStrategy withPartitioningStrategy;
    private int delay;

    public String getWithPartitioner() {
        return this.partitioner;
    }

    public void setWithPartitioner(String name) {
        this.partitioner = name;
    }

    public String getWithSubscription() {
        return this.subscription;
    }

    public void SetWithSubscription(String name) {
        this.subscription = name;
    }

    public int getWithDelay() {
        return this.delay;
    }

    public void setWithDelay(Integer delay) {
        this.delay = delay;
    }

    public void setWithCompression(CompressionType compression) {
        this.compression = compression;
    }

    public CompressionType getWithCompression() {
        return this.compression;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public long getTTL() {
        return this.ttl;
    }

    private void addField(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Illegal fieldAlias.");
        }
        if (this.fieldExists(field)) {
            throw new IllegalArgumentException(String.format("Field %s has already been defined", field.getName()));
        }
        this.fields.add(field);
    }

    private boolean fieldExists(Field newField) {
        for (Field field : this.fields) {
            if (!field.getName().equals(newField.getName()) || !field.getFieldType().equals((Object)newField.getFieldType())) continue;
            if (!field.hasParents() && !newField.hasParents()) {
                return true;
            }
            if (!field.hasParents() || !newField.hasParents() || !field.getParentFields().equals(newField.hasParents())) continue;
            return true;
        }
        return false;
    }

    private void addPartitionByField(String field) {
        if (field == null || field.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid partition by field");
        }
        for (String f : this.partitionBy) {
            if (f.compareToIgnoreCase(field.trim()) != 0) continue;
            throw new IllegalArgumentException(String.format("The field %s appears twice", field));
        }
        this.partitionBy.add(field.trim());
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Field> getIgnoredFields() {
        return this.ignoredFields;
    }

    public WriteModeEnum getWriteMode() {
        return this.writeMode;
    }

    public List<Field> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Bucketing getBucketing() {
        return this.bucketing;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getStoredAs() {
        return this.storedAs;
    }

    public Map<String, String> getStoredAsParameters() {
        return this.storedAsParameters;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public List<PartitionOffset> getPartitonOffset() {
        return this.partitions;
    }

    public Integer getSampleCount() {
        return this.sampleCount;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public Integer getProjectTo() {
        return this.projectTo;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isAutoEvolve() {
        return this.autoEvolve;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isEnableCapitalize() {
        return this.enableCapitalize;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public Iterator<String> getPartitionBy() {
        return this.partitionBy.iterator();
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<String> getWithKeys() {
        return this.withKeys;
    }

    public String getKeyDelimeter() {
        return this.keyDelimeter;
    }

    public boolean hasRetainStructure() {
        return this.retainStructure;
    }

    public boolean isUnwrapping() {
        return this.unwrapping;
    }

    public String getWithType() {
        return this.withType;
    }

    public String getIncrementalMode() {
        return this.incrementalMode;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getIndexSuffix() {
        return this.indexSuffix;
    }

    public String getWithConverter() {
        return this.withConverter;
    }

    public String getWithJmsSelector() {
        return this.withJmsSelector;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getWithRegex() {
        return this.withRegex;
    }

    private void setWithRegex(String withRegex) {
        this.withRegex = withRegex;
    }

    public long getWithFlushInterval() {
        return this.withFlushInterval;
    }

    public long getWithFlushSize() {
        return this.withFlushSize;
    }

    private void setWithFlushCount(long withFlushCount) {
        this.withFlushCount = withFlushCount;
    }

    public long getWithFlushCount() {
        return this.withFlushCount;
    }

    private void setDynamicTarget(String dynamicTarget) {
        this.dynamicTarget = dynamicTarget;
    }

    public String getDynamicTarget() {
        return this.dynamicTarget;
    }

    public TimeUnit getTimestampUnit() {
        return this.timestampUnit;
    }

    private void setTimestampUnit(TimeUnit timestampUnit) {
        this.timestampUnit = timestampUnit;
    }

    private void setWithFlushInterval(long withFlushInterval) {
        this.withFlushInterval = withFlushInterval;
    }

    private void setWithFlushSize(long withFlushSize) {
        this.withFlushSize = withFlushSize;
    }

    public SchemaEvolution getWithSchemaEvolution() {
        return this.withSchemaEvolution;
    }

    private void setWithSchemaEvolution(SchemaEvolution withSchemaEvolution) {
        this.withSchemaEvolution = withSchemaEvolution;
    }

    public String getWithTableLocation() {
        return this.withTableLocation;
    }

    private void setWithTableLocation(String withTableLocation) {
        this.withTableLocation = withTableLocation;
    }

    public boolean getWithOverwrite() {
        return this.withOverwrite;
    }

    private void setWithOverwrite(boolean withOverwrite) {
        this.withOverwrite = withOverwrite;
    }

    public PartitioningStrategy getWithPartitioningStrategy() {
        return this.withPartitioningStrategy;
    }

    private void setWithPartitioningStrategy(PartitioningStrategy withPartitioningStrategy) {
        this.withPartitioningStrategy = withPartitioningStrategy;
    }

    public static Kcql parse(String syntax) {
        String ts;
        ConnectorLexer lexer = new ConnectorLexer(new ANTLRInputStream(syntax));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ConnectorParser parser = new ConnectorParser(tokens);
        final ArrayList<String> bucketNames = new ArrayList<String>();
        final ArrayList nestedFieldsBuffer = new ArrayList();
        final Integer[] bucketsNumber = new Integer[]{null};
        final Kcql kcql = new Kcql();
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        final String[] storedAsParameter = new String[]{null};
        final boolean[] isWithinIgnore = new boolean[]{false};
        final String[] tagValue = new String[]{null};
        final String[] tagKey = new String[]{null};
        parser.addParseListener(new ConnectorParserBaseListener(){

            @Override
            public void exitWith_subscription_value(ConnectorParser.With_subscription_valueContext ctx) {
                kcql.subscription = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitWith_partitioner_value(ConnectorParser.With_partitioner_valueContext ctx) {
                kcql.partitioner = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitColumn(ConnectorParser.ColumnContext ctx) {
                for (TerminalNode tn : ctx.FIELD()) {
                    nestedFieldsBuffer.add(tn.getText());
                }
                if (ctx.ASTERISK() != null) {
                    nestedFieldsBuffer.add("*");
                }
            }

            @Override
            public void exitWith_unwrap_clause(ConnectorParser.With_unwrap_clauseContext ctx) {
                kcql.unwrapping = true;
            }

            @Override
            public void exitWith_type_value(ConnectorParser.With_type_valueContext ctx) {
                kcql.withType = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitWith_structure(ConnectorParser.With_structureContext ctx) {
                kcql.retainStructure = true;
            }

            @Override
            public void exitLimit_value(ConnectorParser.Limit_valueContext ctx) {
                try {
                    int limit = Integer.parseInt(ctx.INT().getText());
                    if (limit < 1) {
                        throw new IllegalArgumentException("Invalid limit specified. Needs to be an integer greater than zero");
                    }
                    kcql.limit = limit;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid limit specified(" + ctx.INT().getText() + "). Needs to be an integer greater than zero");
                }
            }

            @Override
            public void enterColumn_name(ConnectorParser.Column_nameContext ctx) {
                nestedFieldsBuffer.clear();
            }

            @Override
            public void exitColumn_name(ConnectorParser.Column_nameContext ctx) {
                super.exitColumn_name(ctx);
                if (ctx.ASTERISK() != null) {
                    Field field = new Field("*", FieldType.VALUE, null);
                    kcql.addField(field);
                    return;
                }
                ArrayList parentFields = null;
                String name = (String)nestedFieldsBuffer.get(nestedFieldsBuffer.size() - 1);
                nestedFieldsBuffer.remove(nestedFieldsBuffer.size() - 1);
                if (nestedFieldsBuffer.size() > 0) {
                    parentFields = nestedFieldsBuffer;
                }
                Field field = ctx.column_name_alias() != null ? Field.from(name, ctx.column_name_alias().getText(), parentFields) : Field.from(name, parentFields);
                if (isWithinIgnore[0]) {
                    kcql.ignoredFields.add(field);
                } else {
                    kcql.addField(field);
                }
            }

            @Override
            public void exitWith_compression_type(ConnectorParser.With_compression_typeContext ctx) {
                String type = Kcql.unescape(ctx.getText()).toUpperCase();
                CompressionType compressionType = CompressionType.valueOf(type);
                kcql.setWithCompression(compressionType);
            }

            @Override
            public void exitWith_delay_value(ConnectorParser.With_delay_valueContext ctx) {
                kcql.delay = Integer.parseInt(ctx.getText());
            }

            @Override
            public void exitDoc_type(ConnectorParser.Doc_typeContext ctx) {
                kcql.docType = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitWith_converter_value(ConnectorParser.With_converter_valueContext ctx) {
                kcql.withConverter = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitJms_selector_value(ConnectorParser.Jms_selector_valueContext ctx) {
                kcql.withJmsSelector = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitIndex_suffix(ConnectorParser.Index_suffixContext ctx) {
                kcql.indexSuffix = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitInc_mode(ConnectorParser.Inc_modeContext ctx) {
                kcql.incrementalMode = ctx.getText();
            }

            @Override
            public void exitPartition_name(ConnectorParser.Partition_nameContext ctx) {
                kcql.addPartitionByField(ctx.getText());
            }

            @Override
            public void exitDistribute_name(ConnectorParser.Distribute_nameContext ctx) {
                bucketNames.add(ctx.getText());
            }

            @Override
            public void exitTable_name(ConnectorParser.Table_nameContext ctx) {
                kcql.target = Kcql.unescape(ctx.getText());
            }

            @Override
            public void enterWith_ignore(ConnectorParser.With_ignoreContext ctx) {
                isWithinIgnore[0] = true;
            }

            @Override
            public void exitWith_ignore(ConnectorParser.With_ignoreContext ctx) {
                isWithinIgnore[0] = false;
            }

            @Override
            public void exitTopic_name(ConnectorParser.Topic_nameContext ctx) {
                kcql.source = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitUpsert_into(ConnectorParser.Upsert_intoContext ctx) {
                kcql.writeMode = WriteModeEnum.UPSERT;
            }

            @Override
            public void exitInsert_into(ConnectorParser.Insert_intoContext ctx) {
                kcql.writeMode = WriteModeEnum.INSERT;
            }

            @Override
            public void exitAutocreate(ConnectorParser.AutocreateContext ctx) {
                kcql.autoCreate = true;
            }

            @Override
            public void enterPk_name(ConnectorParser.Pk_nameContext ctx) {
                nestedFieldsBuffer.clear();
            }

            @Override
            public void exitPk_name(ConnectorParser.Pk_nameContext ctx) {
                ArrayList parentFields = null;
                String name = (String)nestedFieldsBuffer.get(nestedFieldsBuffer.size() - 1);
                nestedFieldsBuffer.remove(nestedFieldsBuffer.size() - 1);
                if (nestedFieldsBuffer.size() > 0) {
                    parentFields = nestedFieldsBuffer;
                }
                Field field = Field.from(name, parentFields);
                kcql.primaryKeys.add(field);
            }

            @Override
            public void exitAutoevolve(ConnectorParser.AutoevolveContext ctx) {
                kcql.autoEvolve = true;
            }

            @Override
            public void exitStoreas_type(ConnectorParser.Storeas_typeContext ctx) {
                kcql.storedAs = ctx.getText();
            }

            @Override
            public void exitStoreas_parameter(ConnectorParser.Storeas_parameterContext ctx) {
                String value = ctx.getText();
                for (String key : kcql.getStoredAsParameters().keySet()) {
                    if (key.compareToIgnoreCase(value) != 0) continue;
                    throw new IllegalArgumentException(value + " is a duplicated entry in the storeAs parameters list");
                }
                storedAsParameter[0] = value;
            }

            @Override
            public void exitStoreas_value(ConnectorParser.Storeas_valueContext ctx) {
                kcql.getStoredAsParameters().put(storedAsParameter[0], ctx.getText());
            }

            @Override
            public void exitCapitalize(ConnectorParser.CapitalizeContext ctx) {
                kcql.enableCapitalize = true;
            }

            @Override
            public void exitInitialize(ConnectorParser.InitializeContext ctx) {
                kcql.initialize = true;
            }

            @Override
            public void exitVersion_number(ConnectorParser.Version_numberContext ctx) {
                String value = ctx.getText();
                try {
                    int version2 = Integer.parseInt(value);
                    if (version2 <= 0) {
                        throw new IllegalArgumentException(value + " is not a valid number for a version.");
                    }
                    kcql.projectTo = version2;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(value + " is not a valid number for a version.");
                }
            }

            @Override
            public void exitBuckets_number(ConnectorParser.Buckets_numberContext ctx) {
                bucketsNumber[0] = Integer.parseInt(ctx.getText());
            }

            @Override
            public void exitClusterby_name(ConnectorParser.Clusterby_nameContext ctx) {
                bucketNames.add(ctx.getText());
            }

            @Override
            public void exitBatch_size(ConnectorParser.Batch_sizeContext ctx) {
                String value = ctx.getText();
                try {
                    int newBatchSize = Integer.parseInt(value);
                    if (newBatchSize <= 0) {
                        throw new IllegalArgumentException(value + " is not a valid number for a batch Size.");
                    }
                    kcql.batchSize = newBatchSize;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(value + " is not a valid number for a batch Size.");
                }
            }

            @Override
            public void exitTtl_type(ConnectorParser.Ttl_typeContext ctx) {
                String value = ctx.getText();
                try {
                    long newTTL = Long.parseLong(value);
                    if (newTTL <= 0L) {
                        throw new IllegalArgumentException(value + " is not a valid number for a TTL.");
                    }
                    kcql.setTTL(newTTL);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(value + " is not a valid number for a TTL.");
                }
            }

            @Override
            public void exitTimestamp_value(ConnectorParser.Timestamp_valueContext ctx) {
                kcql.timestamp = ctx.getText();
            }

            @Override
            public void exitWith_consumer_group_value(ConnectorParser.With_consumer_group_valueContext ctx) {
                String value = Kcql.unescape(ctx.getText());
                kcql.consumerGroup = value;
            }

            @Override
            public void exitOffset_partition_inner(ConnectorParser.Offset_partition_innerContext ctx) {
                String value = ctx.getText();
                String[] split = value.split(",");
                if (kcql.partitions == null) {
                    kcql.partitions = new ArrayList();
                }
                int partition = Integer.parseInt(split[0]);
                if (split.length == 1) {
                    kcql.partitions.add(new PartitionOffset(partition));
                } else {
                    long offset = Long.parseLong(split[1]);
                    kcql.partitions.add(new PartitionOffset(partition, offset));
                }
            }

            @Override
            public void exitTimestamp_unit_value(ConnectorParser.Timestamp_unit_valueContext ctx) {
                String value = ctx.getText().toUpperCase();
                try {
                    kcql.setTimestampUnit(TimeUnit.valueOf(value));
                }
                catch (Throwable t) {
                    TimeUnit[] units = TimeUnit.values();
                    StringBuilder sb = new StringBuilder();
                    sb.append(units[0].toString());
                    for (int i = 1; i < units.length; ++i) {
                        sb.append(",");
                        sb.append(units[i].toString());
                    }
                    throw new IllegalArgumentException("Invalid 'TIMESTAMPUNIT'. Available values are : " + sb.toString());
                }
            }

            @Override
            public void exitSample_value(ConnectorParser.Sample_valueContext ctx) {
                Integer value = Integer.parseInt(ctx.getText());
                kcql.sampleCount = value;
            }

            @Override
            public void exitSample_period(ConnectorParser.Sample_periodContext ctx) {
                Integer value = Integer.parseInt(ctx.getText());
                kcql.sampleRate = value;
            }

            @Override
            public void exitWith_format(ConnectorParser.With_formatContext ctx) {
                FormatType formatType = FormatType.valueOf(ctx.getText().toUpperCase());
                kcql.formatType = formatType;
            }

            @Override
            public void exitWith_target_value(ConnectorParser.With_target_valueContext ctx) {
                kcql.setDynamicTarget(ctx.getText());
            }

            @Override
            public void exitTag_value(ConnectorParser.Tag_valueContext ctx) {
                tagValue[0] = ctx.getText();
            }

            @Override
            public void exitTag_key(ConnectorParser.Tag_keyContext ctx) {
                if (ctx.getText().trim().endsWith(".")) {
                    throw new IllegalArgumentException("Invalid syntax for tags. Field selection can not end with '.'");
                }
                tagKey[0] = ctx.getText();
            }

            @Override
            public void exitTag_definition(ConnectorParser.Tag_definitionContext ctx) {
                String txt = ctx.getText();
                Tag.TagType type = Tag.TagType.DEFAULT;
                if (tagValue[0] != null) {
                    String tmp = txt.replace(tagKey[0], "").trim();
                    if (tmp.startsWith("=")) {
                        type = Tag.TagType.CONSTANT;
                    } else if (tmp.toLowerCase().startsWith("as")) {
                        type = Tag.TagType.ALIAS;
                    } else {
                        throw new IllegalArgumentException("Invalid syntax for tags. Needs to be 'tag1 [as x]' or 'tag1' or 'tag1 = constant'");
                    }
                }
                if (kcql.tags == null) {
                    kcql.tags = new ArrayList();
                }
                kcql.tags.add(new Tag(tagKey[0], tagValue[0], type));
                tagKey[0] = null;
                tagValue[0] = null;
            }

            @Override
            public void exitWith_key_value(ConnectorParser.With_key_valueContext ctx) {
                String key = ctx.getText();
                if (kcql.withKeys == null) {
                    kcql.withKeys = new ArrayList();
                }
                kcql.withKeys.add(Kcql.unescape(key));
            }

            @Override
            public void exitKey_delimiter_value(ConnectorParser.Key_delimiter_valueContext ctx) {
                kcql.keyDelimeter = ctx.getText().replace("`", "");
                if (kcql.keyDelimeter.trim().length() == 0) {
                    throw new IllegalArgumentException("Invalid key delimiter. Needs to be a non empty string.");
                }
            }

            @Override
            public void exitPipeline_value(ConnectorParser.Pipeline_valueContext ctx) {
                kcql.pipeline = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitWith_regex_value(ConnectorParser.With_regex_valueContext ctx) {
                kcql.withRegex = Kcql.unescape(ctx.getText());
            }

            @Override
            public void exitWith_flush_bytes_value(ConnectorParser.With_flush_bytes_valueContext ctx) {
                try {
                    long size = Long.parseLong(ctx.getText());
                    if (size <= 0L) {
                        throw new IllegalArgumentException("Invalid value specified for WITH_FLUSH_SIZE. Expecting a LONG number greater than 0.");
                    }
                    kcql.setWithFlushSize(size);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid value specified for WITH_FLUSH_SIZE. Expecting a LONG number greater than 0.");
                }
            }

            @Override
            public void exitWith_flush_interval_value(ConnectorParser.With_flush_interval_valueContext ctx) {
                try {
                    long interval = Long.parseLong(ctx.getText());
                    if (interval <= 0L) {
                        throw new IllegalArgumentException("Invalid value specified for WITH_FLUSH_INTERVAL. Expecting a LONG number greater than 0.");
                    }
                    kcql.setWithFlushInterval(interval);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid value specified for WITH_FLUSH_INTERVAL. Expecting a LONG number greater than 0.");
                }
            }

            @Override
            public void exitWith_flush_records_value(ConnectorParser.With_flush_records_valueContext ctx) {
                try {
                    long interval = Long.parseLong(ctx.getText());
                    if (interval <= 0L) {
                        throw new IllegalArgumentException("Invalid value specified for WITH_FLUSH_COUNT. Expecting a LONG number greater than 0.");
                    }
                    kcql.setWithFlushCount(interval);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid value specified for WITH_FLUSH_COUNT. Expecting a LONG number greater than 0.");
                }
            }

            @Override
            public void exitWith_schema_evolution_value(ConnectorParser.With_schema_evolution_valueContext ctx) {
                String value = ctx.getText().toUpperCase();
                try {
                    SchemaEvolution schemaEvolution = Enum.valueOf(SchemaEvolution.class, value);
                    kcql.setWithSchemaEvolution(schemaEvolution);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Invalid value specified for WITH_SCHEMA_EVOLUTION. Expecting one of the values:" + EnumsHelper.mkString((Enum[])SchemaEvolution.values()));
                }
            }

            @Override
            public void exitWith_table_location_value(ConnectorParser.With_table_location_valueContext ctx) {
                kcql.setWithTableLocation(Kcql.unescape(ctx.getText()));
            }

            @Override
            public void exitWith_overwrite_clause(ConnectorParser.With_overwrite_clauseContext ctx) {
                kcql.setWithOverwrite(true);
            }

            @Override
            public void exitWith_partitioning_value(ConnectorParser.With_partitioning_valueContext ctx) {
                String value = ctx.getText().toUpperCase();
                try {
                    PartitioningStrategy strategy = Enum.valueOf(PartitioningStrategy.class, value);
                    kcql.setWithPartitioningStrategy(strategy);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Invalid value specified for WITH_SCHEMA_EVOLUTION. Expecting one of the values:" + EnumsHelper.mkString((Enum[])PartitioningStrategy.values()));
                }
            }
        });
        try {
            parser.stat();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Invalid syntax." + ex.getMessage(), ex);
        }
        HashSet<String> cols = new HashSet<String>();
        for (Field alias : kcql.fields) {
            cols.add(alias.getAlias());
        }
        if (bucketNames.size() > 0 && (bucketsNumber[0] == null || bucketsNumber[0] == 0)) {
            throw new IllegalArgumentException("Invalid bucketing information. Missing the buckets number");
        }
        if (bucketsNumber[0] != null && bucketsNumber[0] > 0 && bucketNames.size() == 0) {
            throw new IllegalArgumentException("Missing bucket columns.");
        }
        if (bucketsNumber[0] != null) {
            Bucketing bucketing = new Bucketing(bucketNames);
            bucketing.setBucketsNumber(bucketsNumber[0]);
            kcql.bucketing = bucketing;
        }
        if ((ts = kcql.timestamp) != null) {
            kcql.timestamp = TIMESTAMP.compareToIgnoreCase(ts) == 0 ? ts.toLowerCase() : ts;
        }
        if (kcql.sampleCount != null && kcql.sampleCount == 0) {
            throw new IllegalArgumentException("Sample count needs to be a positive number greater than zero");
        }
        if (kcql.sampleRate != null && kcql.sampleRate == 0) {
            throw new IllegalArgumentException("Sample rate should be a positive number greater than zero");
        }
        return kcql;
    }

    private static String unescape(String value) {
        if (value.startsWith("`") && value.endsWith("`")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

