/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;

class EnumerableLimitRule
extends RelOptRule {
    EnumerableLimitRule() {
        super(EnumerableLimitRule.operand(Sort.class, EnumerableLimitRule.any()), "EnumerableLimitRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        if (sort2.offset == null && sort2.fetch == null) {
            return;
        }
        RelTraitSet traitSet = sort2.getTraitSet().replace(EnumerableConvention.INSTANCE);
        RelNode input = sort2.getInput();
        if (!sort2.getCollation().getFieldCollations().isEmpty()) {
            input = sort2.copy(sort2.getTraitSet(), input, sort2.getCollation(), null, null);
        }
        RelNode x = EnumerableLimitRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
        call.transformTo(new EnumerableLimit(sort2.getCluster(), traitSet, x, sort2.offset, sort2.fetch));
    }
}

