/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.NestedBlockBuilder;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.rex.RexNode;

public class NestedBlockBuilderImpl
implements NestedBlockBuilder {
    private final List<BlockBuilder> blocks = new ArrayList<BlockBuilder>();
    private final List<Map<RexNode, Boolean>> nullables = new ArrayList<Map<RexNode, Boolean>>();

    public NestedBlockBuilderImpl(BlockBuilder block) {
        this.nestBlock(block);
    }

    @Override
    public final BlockBuilder nestBlock() {
        BlockBuilder block = new BlockBuilder(true, this.currentBlock());
        this.nestBlock(block, Collections.emptyMap());
        return block;
    }

    @Override
    public final void nestBlock(BlockBuilder block) {
        this.nestBlock(block, Collections.emptyMap());
    }

    @Override
    public final void nestBlock(BlockBuilder block, Map<RexNode, Boolean> nullables) {
        Map next2;
        Map prev;
        this.blocks.add(block);
        Map<Object, Object> map2 = prev = this.nullables.isEmpty() ? Collections.emptyMap() : this.nullables.get(this.nullables.size() - 1);
        if (nullables == null || nullables.isEmpty()) {
            next2 = prev;
        } else {
            next2 = new HashMap<RexNode, Boolean>(nullables);
            next2.putAll(prev);
            next2 = Collections.unmodifiableMap(next2);
        }
        this.nullables.add(next2);
    }

    @Override
    public final BlockBuilder currentBlock() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    @Override
    public final Map<RexNode, Boolean> currentNullables() {
        return this.nullables.get(this.nullables.size() - 1);
    }

    @Override
    public final void exitBlock() {
        this.blocks.remove(this.blocks.size() - 1);
        this.nullables.remove(this.nullables.size() - 1);
    }
}

