/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Descriptors;
import com.google.protobuf.UnsafeByteOperations;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.util.Base64;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;

public class TypedValue {
    private static final Descriptors.FieldDescriptor NUMBER_DESCRIPTOR = Common.TypedValue.getDescriptor().findFieldByNumber(4);
    private static final Descriptors.FieldDescriptor STRING_DESCRIPTOR = Common.TypedValue.getDescriptor().findFieldByNumber(3);
    private static final Descriptors.FieldDescriptor BYTES_DESCRIPTOR = Common.TypedValue.getDescriptor().findFieldByNumber(5);
    public static final TypedValue NULL = new TypedValue(ColumnMetaData.Rep.OBJECT, null);
    public final ColumnMetaData.Rep type;
    public final Object value;

    private TypedValue(ColumnMetaData.Rep rep2, Object value) {
        this.type = rep2;
        this.value = value;
        assert (this.isSerial(rep2, value)) : "rep: " + (Object)((Object)rep2) + ", value: " + value;
    }

    private boolean isSerial(ColumnMetaData.Rep rep2, Object value) {
        if (value == null) {
            return true;
        }
        switch (rep2) {
            case BYTE_STRING: {
                return value instanceof String;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return value instanceof Integer;
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                return value instanceof Long;
            }
        }
        return true;
    }

    @JsonCreator
    public static TypedValue create(@JsonProperty(value="type") String type, @JsonProperty(value="value") Object value) {
        if (value == null) {
            return NULL;
        }
        ColumnMetaData.Rep rep2 = ColumnMetaData.Rep.valueOf(type);
        return TypedValue.ofLocal(rep2, TypedValue.serialToLocal(rep2, value));
    }

    public static TypedValue ofLocal(ColumnMetaData.Rep rep2, Object value) {
        return new TypedValue(rep2, TypedValue.localToSerial(rep2, value));
    }

    public static TypedValue ofSerial(ColumnMetaData.Rep rep2, Object value) {
        return new TypedValue(rep2, value);
    }

    public static TypedValue ofJdbc(ColumnMetaData.Rep rep2, Object value, Calendar calendar) {
        if (value == null) {
            return NULL;
        }
        return new TypedValue(rep2, TypedValue.jdbcToSerial(rep2, value, calendar));
    }

    public static TypedValue ofJdbc(Object value, Calendar calendar) {
        if (value == null) {
            return NULL;
        }
        ColumnMetaData.Rep rep2 = ColumnMetaData.Rep.of(value.getClass());
        return new TypedValue(rep2, TypedValue.jdbcToSerial(rep2, value, calendar));
    }

    public Object toLocal() {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToLocal(this.type, this.value);
    }

    private static Object serialToLocal(ColumnMetaData.Rep rep2, Object value) {
        assert (value != null);
        if (value.getClass() == rep2.clazz) {
            return value;
        }
        switch (rep2) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case INTEGER: {
                return ((Number)value).intValue();
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: 
            case LONG: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case NUMBER: {
                return value instanceof BigDecimal ? value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double ? new BigDecimal((Double)value) : (value instanceof Float ? new BigDecimal(((Float)value).floatValue()) : new BigDecimal(((Number)value).longValue()))));
            }
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value);
            }
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to " + (Object)((Object)rep2));
    }

    public Object toJdbc(Calendar calendar) {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToJdbc(this.type, this.value, calendar);
    }

    private static Object serialToJdbc(ColumnMetaData.Rep type, Object value, Calendar calendar) {
        switch (type) {
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value).getBytes();
            }
            case JAVA_UTIL_DATE: {
                return new java.util.Date(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_DATE: {
                return new Date(TypedValue.adjust(((Number)value).longValue() * 86400000L, calendar));
            }
            case JAVA_SQL_TIME: {
                return new Time(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_TIMESTAMP: {
                return new Timestamp(TypedValue.adjust((Number)value, calendar));
            }
        }
        return TypedValue.serialToLocal(type, value);
    }

    private static long adjust(Number number, Calendar calendar) {
        long t = number.longValue();
        if (calendar != null) {
            t -= (long)calendar.getTimeZone().getOffset(t);
        }
        return t;
    }

    private static Object jdbcToSerial(ColumnMetaData.Rep rep2, Object value, Calendar calendar) {
        switch (rep2) {
            case BYTE_STRING: {
                return new ByteString((byte[])value).toBase64String();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                long t = ((java.util.Date)value).getTime();
                if (calendar != null) {
                    t += (long)calendar.getTimeZone().getOffset(t);
                }
                switch (rep2) {
                    case JAVA_SQL_DATE: {
                        return (int)DateTimeUtils.floorDiv(t, 86400000L);
                    }
                    case JAVA_SQL_TIME: {
                        return (int)DateTimeUtils.floorMod(t, 86400000L);
                    }
                }
                return t;
            }
        }
        return value;
    }

    private static Object localToSerial(ColumnMetaData.Rep rep2, Object value) {
        switch (rep2) {
            case BYTE_STRING: {
                return ((ByteString)value).toBase64String();
            }
        }
        return value;
    }

    public static List<Object> values(List<TypedValue> typedValues) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TypedValue typedValue : typedValues) {
            list.add(typedValue.toLocal());
        }
        return list;
    }

    public Common.TypedValue toProto() {
        Common.TypedValue.Builder builder = Common.TypedValue.newBuilder();
        Common.Rep protoRep = this.type.toProto();
        if (Common.Rep.NUMBER == protoRep && this.value instanceof BigDecimal) {
            protoRep = Common.Rep.BIG_DECIMAL;
        }
        TypedValue.writeToProtoWithType(builder, this.value, protoRep);
        return builder.build();
    }

    private static void writeToProtoWithType(Common.TypedValue.Builder builder, Object o, Common.Rep type) {
        builder.setType(type);
        switch (type) {
            case BOOLEAN: 
            case PRIMITIVE_BOOLEAN: {
                builder.setBoolValue((Boolean)o);
                return;
            }
            case BYTE_STRING: {
                byte[] bytes2;
                if (o instanceof String) {
                    builder.setStringValue((String)o);
                    bytes2 = ByteString.parseBase64((String)o);
                } else {
                    builder.setStringValue(Base64.encodeBytes((byte[])o));
                    bytes2 = (byte[])o;
                }
                builder.setBytesValue(UnsafeByteOperations.unsafeWrap((byte[])bytes2));
                return;
            }
            case STRING: {
                builder.setStringValueBytes(UnsafeByteOperations.unsafeWrap((byte[])((String)o).getBytes(StandardCharsets.UTF_8)));
                return;
            }
            case PRIMITIVE_CHAR: 
            case CHARACTER: {
                builder.setStringValue(Character.toString(((Character)o).charValue()));
                return;
            }
            case BYTE: 
            case PRIMITIVE_BYTE: {
                builder.setNumberValue(Byte.valueOf((Byte)o).longValue());
                return;
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                builder.setDoubleValue((Double)o);
                return;
            }
            case FLOAT: 
            case PRIMITIVE_FLOAT: {
                builder.setNumberValue(Float.floatToIntBits(((Float)o).floatValue()));
                return;
            }
            case INTEGER: 
            case PRIMITIVE_INT: {
                builder.setNumberValue(Integer.valueOf((Integer)o).longValue());
                return;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                builder.setNumberValue(Short.valueOf((Short)o).longValue());
                return;
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                builder.setNumberValue((Long)o);
                return;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                builder.setNumberValue(Integer.valueOf((Integer)o).longValue());
                return;
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                builder.setNumberValue((Long)o);
                return;
            }
            case BIG_INTEGER: {
                byte[] byteRep = ((BigInteger)o).toByteArray();
                builder.setBytesValue(com.google.protobuf.ByteString.copyFrom((byte[])byteRep));
                return;
            }
            case BIG_DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)o;
                builder.setStringValue(bigDecimal.toString());
                return;
            }
            case NUMBER: {
                builder.setNumberValue(((Number)o).longValue());
                return;
            }
            case NULL: {
                builder.setNull(true);
                return;
            }
            case OBJECT: {
                if (null == o) {
                    builder.setNull(true);
                    return;
                }
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Unhandled value: " + (Object)((Object)type) + " " + o.getClass());
            }
        }
        throw new RuntimeException("Unknown serialized type: " + (Object)((Object)type));
    }

    public static TypedValue fromProto(Common.TypedValue proto) {
        ColumnMetaData.Rep rep2 = ColumnMetaData.Rep.fromProto(proto.getType());
        Object value = TypedValue.getSerialFromProto(proto);
        return new TypedValue(rep2, value);
    }

    public static Object getSerialFromProto(Common.TypedValue protoValue) {
        switch (protoValue.getType()) {
            case BOOLEAN: 
            case PRIMITIVE_BOOLEAN: {
                return protoValue.getBoolValue();
            }
            case BYTE_STRING: {
                if (protoValue.hasField(STRING_DESCRIPTOR) && !protoValue.hasField(BYTES_DESCRIPTOR)) {
                    return protoValue.getStringValue();
                }
                return new ByteString(protoValue.getBytesValue().toByteArray()).toBase64String();
            }
            case STRING: {
                return protoValue.getStringValue();
            }
            case PRIMITIVE_CHAR: 
            case CHARACTER: {
                return Character.valueOf(protoValue.getStringValue().charAt(0));
            }
            case BYTE: 
            case PRIMITIVE_BYTE: {
                return Long.valueOf(protoValue.getNumberValue()).byteValue();
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                return protoValue.getDoubleValue();
            }
            case FLOAT: 
            case PRIMITIVE_FLOAT: {
                return Float.valueOf(Float.intBitsToFloat((int)protoValue.getNumberValue()));
            }
            case INTEGER: 
            case PRIMITIVE_INT: {
                return Long.valueOf(protoValue.getNumberValue()).intValue();
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                return Long.valueOf(protoValue.getNumberValue()).shortValue();
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                return protoValue.getNumberValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return Long.valueOf(protoValue.getNumberValue()).intValue();
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                return protoValue.getNumberValue();
            }
            case BIG_INTEGER: {
                return new BigInteger(protoValue.getBytesValue().toByteArray());
            }
            case BIG_DECIMAL: {
                if (protoValue.hasField(NUMBER_DESCRIPTOR)) {
                    BigInteger bigInt = new BigInteger(protoValue.getBytesValue().toByteArray());
                    return new BigDecimal(bigInt, (int)protoValue.getNumberValue());
                }
                return new BigDecimal(protoValue.getStringValueBytes().toStringUtf8());
            }
            case NUMBER: {
                return protoValue.getNumberValue();
            }
            case NULL: {
                return null;
            }
            case OBJECT: {
                if (protoValue.getNull()) {
                    return null;
                }
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Unhandled type: " + (Object)((Object)protoValue.getType()));
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)protoValue.getType()));
    }

    public static void toProto(Common.TypedValue.Builder builder, Object o) {
        if (o instanceof Byte) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BYTE);
        } else if (o instanceof Short) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.SHORT);
        } else if (o instanceof Integer) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.INTEGER);
        } else if (o instanceof Long) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.LONG);
        } else if (o instanceof Double) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.DOUBLE);
        } else if (o instanceof Float) {
            TypedValue.writeToProtoWithType(builder, ((Float)o).longValue(), Common.Rep.FLOAT);
        } else if (o instanceof BigDecimal) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BIG_DECIMAL);
        } else if (o instanceof String) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.STRING);
        } else if (o instanceof Character) {
            TypedValue.writeToProtoWithType(builder, o.toString(), Common.Rep.CHARACTER);
        } else if (o instanceof byte[]) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BYTE_STRING);
        } else if (o instanceof Boolean) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BOOLEAN);
        } else if (null == o) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.NULL);
        } else {
            throw new RuntimeException("Unhandled type in Frame: " + o.getClass());
        }
    }

    public static Object protoToJdbc(Common.TypedValue protoValue, Calendar calendar) {
        Object o = TypedValue.getSerialFromProto(Objects.requireNonNull(protoValue));
        if (null == o) {
            return o;
        }
        return TypedValue.serialToJdbc(ColumnMetaData.Rep.fromProto(protoValue.getType()), o, calendar);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
        result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
        return result2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TypedValue) {
            TypedValue other = (TypedValue)o;
            if (this.type != other.type) {
                return false;
            }
            if (null == this.value && null != other.value) {
                return false;
            }
            return this.value.equals(other.value);
        }
        return false;
    }
}

