/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.plan.VisitorDataContext;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteLogger;
import org.slf4j.LoggerFactory;

public class RexImplicationChecker {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger(RexImplicationChecker.class));
    final RexBuilder builder;
    final RexExecutorImpl executor;
    final RelDataType rowType;

    public RexImplicationChecker(RexBuilder builder, RexExecutorImpl executor, RelDataType rowType) {
        this.builder = Preconditions.checkNotNull(builder);
        this.executor = Preconditions.checkNotNull(executor);
        this.rowType = Preconditions.checkNotNull(rowType);
    }

    public boolean implies(RexNode first, RexNode second) {
        if (!this.validate(first, second)) {
            return false;
        }
        LOGGER.debug("Checking if {} => {}", (Object)first.toString(), (Object)second.toString());
        RexNode firstDnf = RexUtil.toDnf(this.builder, first);
        RexNode secondDnf = RexUtil.toDnf(this.builder, second);
        if (firstDnf.isAlwaysFalse() || secondDnf.isAlwaysTrue()) {
            return true;
        }
        List<RexNode> firsts = RelOptUtil.disjunctions(firstDnf);
        List<RexNode> seconds = RelOptUtil.disjunctions(secondDnf);
        for (RexNode f : firsts) {
            if (this.impliesAny(f, seconds)) continue;
            LOGGER.debug("{} does not imply {}", (Object)first, (Object)second);
            return false;
        }
        LOGGER.debug("{} implies {}", (Object)first, (Object)second);
        return true;
    }

    private boolean impliesAny(RexNode first, List<RexNode> seconds) {
        for (RexNode second : seconds) {
            if (!this.impliesConjunction(first, second)) continue;
            return true;
        }
        return false;
    }

    private boolean impliesConjunction(RexNode first, RexNode second) {
        if (this.implies2(first, second)) {
            return true;
        }
        switch (first.getKind()) {
            case AND: {
                for (RexNode f : RelOptUtil.conjunctions(first)) {
                    if (!this.implies2(f, second)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private boolean implies2(RexNode first, RexNode second) {
        if (second.isAlwaysFalse()) {
            return false;
        }
        if (RexUtil.eq(first, second)) {
            return true;
        }
        switch (second.getKind()) {
            case IS_NOT_NULL: {
                final RexNode operand = ((RexCall)second).getOperands().get(0);
                Strong strong = new Strong(){

                    @Override
                    public boolean isNull(RexNode node) {
                        return RexUtil.eq(node, operand) || super.isNull(node);
                    }
                };
                if (!strong.isNull(first)) break;
                return true;
            }
        }
        InputUsageFinder firstUsageFinder = new InputUsageFinder();
        InputUsageFinder secondUsageFinder = new InputUsageFinder();
        RexUtil.apply((RexVisitor<Void>)firstUsageFinder, ImmutableList.of(), first);
        RexUtil.apply((RexVisitor<Void>)secondUsageFinder, ImmutableList.of(), second);
        if (!this.checkSupport(firstUsageFinder, secondUsageFinder)) {
            LOGGER.warn("Support for checking {} => {} is not there", (Object)first, (Object)second);
            return false;
        }
        ImmutableList.Builder usagesBuilder = ImmutableList.builder();
        for (Map.Entry<RexInputRef, InputRefUsage<SqlOperator, RexNode>> entry2 : firstUsageFinder.usageMap.entrySet()) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((InputRefUsage)entry2.getValue()).usageList.size() <= 0) continue;
            for (Pair pair : ((InputRefUsage)entry2.getValue()).usageList) {
                builder.add(Pair.of(entry2.getKey(), pair.getValue()));
            }
            usagesBuilder.add(builder.build());
        }
        Set usages = Sets.cartesianProduct(usagesBuilder.build());
        for (List<Pair<RexInputRef, RexNode>> list : usages) {
            DataContext dataValues = VisitorDataContext.of(this.rowType, list);
            if (this.isSatisfiable(second, dataValues)) continue;
            return false;
        }
        return true;
    }

    private boolean isSatisfiable(RexNode second, DataContext dataValues) {
        Object[] result2;
        if (dataValues == null) {
            return false;
        }
        ImmutableList<RexNode> constExps = ImmutableList.of(second);
        RexExecutable exec = this.executor.getExecutable(this.builder, constExps, this.rowType);
        exec.setDataContext(dataValues);
        try {
            result2 = exec.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Exception thrown while checking if => {}: {}", (Object)second, (Object)e.getMessage());
            return false;
        }
        return result2 != null && result2.length == 1 && result2[0] instanceof Boolean && (Boolean)result2[0] != false;
    }

    private boolean checkSupport(InputUsageFinder firstUsageFinder, InputUsageFinder secondUsageFinder) {
        Map<RexInputRef, InputRefUsage<SqlOperator, RexNode>> firstUsageMap = firstUsageFinder.usageMap;
        Map<RexInputRef, InputRefUsage<SqlOperator, RexNode>> secondUsageMap = secondUsageFinder.usageMap;
        for (Map.Entry<RexInputRef, InputRefUsage<SqlOperator, RexNode>> entry2 : secondUsageMap.entrySet()) {
            SqlKind sKind2;
            InputRefUsage<SqlOperator, RexNode> secondUsage = entry2.getValue();
            List secondUsageList = ((InputRefUsage)secondUsage).usageList;
            int secondLen = secondUsageList.size();
            if (((InputRefUsage)secondUsage).usageCount != secondLen || secondLen > 2) {
                return false;
            }
            InputRefUsage<SqlOperator, RexNode> firstUsage = firstUsageMap.get(entry2.getKey());
            if (firstUsage == null || ((InputRefUsage)firstUsage).usageList.size() != ((InputRefUsage)firstUsage).usageCount || ((InputRefUsage)firstUsage).usageCount > 2) {
                return false;
            }
            List firstUsageList = ((InputRefUsage)firstUsage).usageList;
            int firstLen = firstUsageList.size();
            SqlKind fKind = ((SqlOperator)((Pair)firstUsageList.get(0)).getKey()).getKind();
            SqlKind sKind = ((SqlOperator)((Pair)secondUsageList.get(0)).getKey()).getKind();
            SqlKind fKind2 = firstUsageList.size() == 2 ? ((SqlOperator)((Pair)firstUsageList.get(1)).getKey()).getKind() : null;
            SqlKind sqlKind = sKind2 = secondUsageList.size() == 2 ? ((SqlOperator)((Pair)secondUsageList.get(1)).getKey()).getKind() : null;
            if (!(firstLen != 2 || secondLen != 2 || this.isEquivalentOp(fKind, sKind) && this.isEquivalentOp(fKind2, sKind2) || this.isEquivalentOp(fKind, sKind2) && this.isEquivalentOp(fKind2, sKind))) {
                return false;
            }
            if (firstLen == 1 && secondLen == 1 && fKind != SqlKind.EQUALS && !this.isSupportedUnaryOperators(sKind) && !this.isEquivalentOp(fKind, sKind)) {
                return false;
            }
            if (firstLen == 1 && secondLen == 2 && fKind != SqlKind.EQUALS) {
                return false;
            }
            if (firstLen != 2 || secondLen != 1 || this.isOppositeOp(fKind, fKind2) || this.isSupportedUnaryOperators(sKind) || this.isEquivalentOp(fKind, fKind2) && this.isEquivalentOp(fKind, sKind)) continue;
            return false;
        }
        return true;
    }

    private boolean isSupportedUnaryOperators(SqlKind kind) {
        switch (kind) {
            case IS_NOT_NULL: 
            case IS_NULL: {
                return true;
            }
        }
        return false;
    }

    private boolean isEquivalentOp(SqlKind fKind, SqlKind sKind) {
        switch (sKind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                if (fKind == SqlKind.GREATER_THAN || fKind == SqlKind.GREATER_THAN_OR_EQUAL) break;
                return false;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (fKind == SqlKind.LESS_THAN || fKind == SqlKind.LESS_THAN_OR_EQUAL) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean isOppositeOp(SqlKind fKind, SqlKind sKind) {
        switch (sKind) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                if (fKind == SqlKind.LESS_THAN || fKind == SqlKind.LESS_THAN_OR_EQUAL) break;
                return false;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (fKind == SqlKind.GREATER_THAN || fKind == SqlKind.GREATER_THAN_OR_EQUAL) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean validate(RexNode first, RexNode second) {
        return first instanceof RexCall && second instanceof RexCall;
    }

    private static class InputRefUsage<T1, T2> {
        private final List<Pair<T1, T2>> usageList = new ArrayList<Pair<T1, T2>>();
        private int usageCount = 0;

        private InputRefUsage() {
        }
    }

    private static class InputUsageFinder
    extends RexVisitorImpl<Void> {
        final Map<RexInputRef, InputRefUsage<SqlOperator, RexNode>> usageMap = new HashMap<RexInputRef, InputRefUsage<SqlOperator, RexNode>>();

        InputUsageFinder() {
            super(true);
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            InputRefUsage<SqlOperator, RexNode> inputRefUse = this.getUsageMap(inputRef);
            ((InputRefUsage)inputRefUse).usageCount++;
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            switch (call.getOperator().getKind()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case EQUALS: 
                case NOT_EQUALS: {
                    this.updateBinaryOpUsage(call);
                    break;
                }
                case IS_NOT_NULL: 
                case IS_NULL: {
                    this.updateUnaryOpUsage(call);
                    break;
                }
            }
            return (Void)super.visitCall(call);
        }

        private void updateUnaryOpUsage(RexCall call) {
            List<RexNode> operands = call.getOperands();
            RexNode first = InputUsageFinder.removeCast(operands.get(0));
            if (first.isA(SqlKind.INPUT_REF)) {
                this.updateUsage(call.getOperator(), (RexInputRef)first, null);
            }
        }

        private void updateBinaryOpUsage(RexCall call) {
            List<RexNode> operands = call.getOperands();
            RexNode first = InputUsageFinder.removeCast(operands.get(0));
            RexNode second = InputUsageFinder.removeCast(operands.get(1));
            if (first.isA(SqlKind.INPUT_REF) && second.isA(SqlKind.LITERAL)) {
                this.updateUsage(call.getOperator(), (RexInputRef)first, second);
            }
            if (first.isA(SqlKind.LITERAL) && second.isA(SqlKind.INPUT_REF)) {
                this.updateUsage(this.reverse(call.getOperator()), (RexInputRef)second, first);
            }
        }

        private SqlOperator reverse(SqlOperator op) {
            return RelOptUtil.op(op.getKind().reverse(), op);
        }

        private static RexNode removeCast(RexNode inputRef) {
            RexCall castedRef;
            SqlOperator operator;
            if (inputRef instanceof RexCall && (operator = (castedRef = (RexCall)inputRef).getOperator()) instanceof SqlCastFunction) {
                inputRef = castedRef.getOperands().get(0);
            }
            return inputRef;
        }

        private void updateUsage(SqlOperator op, RexInputRef inputRef, RexNode literal2) {
            InputRefUsage<SqlOperator, RexNode> inputRefUse = this.getUsageMap(inputRef);
            Pair<SqlOperator, RexNode> use = Pair.of(op, literal2);
            ((InputRefUsage)inputRefUse).usageList.add(use);
        }

        private InputRefUsage<SqlOperator, RexNode> getUsageMap(RexInputRef rex) {
            InputRefUsage<SqlOperator, RexNode> inputRefUse = this.usageMap.get(rex);
            if (inputRefUse == null) {
                inputRefUse = new InputRefUsage();
                this.usageMap.put(rex, inputRefUse);
            }
            return inputRefUse;
        }
    }
}

