/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Util;

public class CalciteCatalogReader
implements Prepare.CatalogReader {
    protected final CalciteSchema rootSchema;
    protected final RelDataTypeFactory typeFactory;
    private final List<List<String>> schemaPaths;
    protected final SqlNameMatcher nameMatcher;

    public CalciteCatalogReader(CalciteSchema rootSchema, boolean caseSensitive, List<String> defaultSchema, RelDataTypeFactory typeFactory) {
        this(rootSchema, SqlNameMatchers.withCaseSensitive(caseSensitive), ImmutableList.of(Preconditions.checkNotNull(defaultSchema), ImmutableList.of()), typeFactory);
    }

    protected CalciteCatalogReader(CalciteSchema rootSchema, SqlNameMatcher nameMatcher, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory) {
        this.rootSchema = Preconditions.checkNotNull(rootSchema);
        this.nameMatcher = nameMatcher;
        this.schemaPaths = Util.immutableCopy(Util.isDistinct(schemaPaths) ? schemaPaths : new LinkedHashSet<List<String>>(schemaPaths));
        this.typeFactory = typeFactory;
    }

    @Override
    public CalciteCatalogReader withSchemaPath(List<String> schemaPath) {
        return new CalciteCatalogReader(this.rootSchema, this.nameMatcher, ImmutableList.of(schemaPath, ImmutableList.of()), this.typeFactory);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        for (List<String> schemaPath : this.schemaPaths) {
            Prepare.PreparingTable table = this.getTableFrom(names, schemaPath, this.nameMatcher);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    private Prepare.PreparingTable getTableFrom(List<String> names, List<String> schemaNames, SqlNameMatcher nameMatcher) {
        CalciteSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)), nameMatcher);
        if (schema == null) {
            return null;
        }
        String name = Util.last(names);
        CalciteSchema.TableEntry entry2 = schema.getTable(name, nameMatcher.isCaseSensitive());
        if (entry2 == null) {
            entry2 = schema.getTableBasedOnNullaryFunction(name, nameMatcher.isCaseSensitive());
        }
        if (entry2 != null) {
            Prepare.PreparingTable relOptTable;
            Table table = entry2.getTable();
            String name2 = entry2.name;
            if (table instanceof Wrapper && (relOptTable = ((Wrapper)((Object)table)).unwrap(Prepare.PreparingTable.class)) != null) {
                return relOptTable;
            }
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), schema.add(name2, table), null);
        }
        return null;
    }

    private Collection<org.apache.calcite.schema.Function> getFunctionsFrom(List<String> names) {
        CalciteSchema schema;
        ArrayList<org.apache.calcite.schema.Function> functions2 = Lists.newArrayList();
        ArrayList<List<String>> schemaNameList = new ArrayList<List<String>>();
        if (names.size() > 1) {
            if (this.schemaPaths.size() > 1) {
                schemaNameList.addAll(Util.skip(this.schemaPaths));
            } else {
                schemaNameList.addAll(this.schemaPaths);
            }
        } else {
            for (List<String> schemaPath : this.schemaPaths) {
                schema = this.getSchema(schemaPath, this.nameMatcher);
                if (schema == null) continue;
                schemaNameList.addAll(schema.getPath());
            }
        }
        for (List<String> schemaNames : schemaNameList) {
            schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)), this.nameMatcher);
            if (schema == null) continue;
            String name = Util.last(names);
            functions2.addAll(schema.getFunctions(name, true));
        }
        return functions2;
    }

    private CalciteSchema getSchema(Iterable<String> schemaNames, SqlNameMatcher nameMatcher) {
        CalciteSchema schema = this.rootSchema;
        for (String schemaName : schemaNames) {
            if (schema == this.rootSchema && nameMatcher.matches(schemaName, schema.getName()) || (schema = schema.getSubSchema(schemaName, nameMatcher.isCaseSensitive())) != null) continue;
            return null;
        }
        return schema;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        CalciteSchema schema = this.getSchema(names, this.nameMatcher);
        if (schema == null) {
            return ImmutableList.of();
        }
        ArrayList<SqlMoniker> result2 = new ArrayList<SqlMoniker>();
        if (!schema.name.equals("")) {
            result2.add(this.moniker(schema, null, SqlMonikerType.SCHEMA));
        }
        NavigableMap<String, CalciteSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result2.add(this.moniker(schema, subSchema, SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result2.add(this.moniker(schema, table, SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function2 : functions) {
            result2.add(this.moniker(schema, function2, SqlMonikerType.FUNCTION));
        }
        return result2;
    }

    private SqlMonikerImpl moniker(CalciteSchema schema, String name, SqlMonikerType type) {
        List<String> path = schema.path(name);
        if (path.size() == 1 && !schema.root().name.equals("") && type == SqlMonikerType.SCHEMA) {
            type = SqlMonikerType.CATALOG;
        }
        return new SqlMonikerImpl(path, type);
    }

    @Override
    public List<List<String>> getSchemaPaths() {
        return this.schemaPaths;
    }

    @Override
    public Prepare.PreparingTable getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return this.nameMatcher.field(rowType, alias);
    }

    @Override
    public boolean matches(String string, String name) {
        return this.nameMatcher.matches(string, name);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.nameMatcher.isCaseSensitive());
    }

    @Override
    public void lookupOperatorOverloads(final SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        PredicateImpl<org.apache.calcite.schema.Function> predicate = category == null ? Predicates.alwaysTrue() : (category.isTableFunction() ? new PredicateImpl<org.apache.calcite.schema.Function>(){

            @Override
            public boolean test(org.apache.calcite.schema.Function function2) {
                return function2 instanceof TableMacro || function2 instanceof TableFunction;
            }
        } : new PredicateImpl<org.apache.calcite.schema.Function>(){

            @Override
            public boolean test(org.apache.calcite.schema.Function function2) {
                return !(function2 instanceof TableMacro) && !(function2 instanceof TableFunction);
            }
        });
        Collection<org.apache.calcite.schema.Function> functions = Collections2.filter(this.getFunctionsFrom(opName.names), predicate);
        if (functions.isEmpty()) {
            return;
        }
        operatorList.addAll(Collections2.transform(functions, new Function<org.apache.calcite.schema.Function, SqlOperator>(){

            @Override
            public SqlOperator apply(org.apache.calcite.schema.Function function2) {
                return CalciteCatalogReader.this.toOp(opName, function2);
            }
        }));
    }

    private SqlOperator toOp(SqlIdentifier name, final org.apache.calcite.schema.Function function2) {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function2.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        PredicateImpl<Integer> optional = new PredicateImpl<Integer>(){

            @Override
            public boolean test(Integer input) {
                return function2.getParameters().get(input).isOptional();
            }
        };
        FamilyOperandTypeChecker typeChecker = OperandTypes.family(typeFamilies, (Predicate<Integer>)optional);
        List<RelDataType> paramTypes = this.toSql(argTypes);
        if (function2 instanceof ScalarFunction) {
            return new SqlUserDefinedFunction(name, this.infer((ScalarFunction)function2), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, function2);
        }
        if (function2 instanceof AggregateFunction) {
            return new SqlUserDefinedAggFunction(name, this.infer((AggregateFunction)function2), InferTypes.explicit(argTypes), typeChecker, (AggregateFunction)function2);
        }
        if (function2 instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, (TableMacro)function2);
        }
        if (function2 instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, (TableFunction)function2);
        }
        throw new AssertionError((Object)("unknown function type " + function2));
    }

    private SqlReturnTypeInference infer(final ScalarFunction function2) {
        return new SqlReturnTypeInference(){

            @Override
            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataType type = function2.getReturnType(CalciteCatalogReader.this.typeFactory);
                return CalciteCatalogReader.this.toSql(type);
            }
        };
    }

    private SqlReturnTypeInference infer(final AggregateFunction function2) {
        return new SqlReturnTypeInference(){

            @Override
            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataType type = function2.getReturnType(CalciteCatalogReader.this.typeFactory);
                return CalciteCatalogReader.this.toSql(type);
            }
        };
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, new Function<RelDataType, RelDataType>(){

            @Override
            public RelDataType apply(RelDataType type) {
                return CalciteCatalogReader.this.toSql(type);
            }
        });
    }

    private RelDataType toSql(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql(this.typeFactory, type);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public CalciteSchema getRootSchema() {
        return this.rootSchema;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }

    @Override
    public boolean isCaseSensitive() {
        return this.nameMatcher.isCaseSensitive();
    }

    @Override
    public SqlNameMatcher nameMatcher() {
        return this.nameMatcher;
    }

    @Override
    public <C> C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        return null;
    }
}

