/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Util;

public class RelJson {
    private final Map<String, Constructor> constructorMap = new HashMap<String, Constructor>();
    private final JsonBuilder jsonBuilder;
    public static final List<String> PACKAGES = ImmutableList.of("org.apache.calcite.rel.", "org.apache.calcite.rel.core.", "org.apache.calcite.rel.logical.", "org.apache.calcite.adapter.jdbc.", "org.apache.calcite.adapter.jdbc.JdbcRules$");

    public RelJson(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
    }

    public RelNode create(Map<String, Object> map2) {
        String type = (String)map2.get("type");
        Constructor constructor = this.getConstructor(type);
        try {
            return (RelNode)constructor.newInstance(map2);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
    }

    public Constructor getConstructor(String type) {
        Constructor constructor = this.constructorMap.get(type);
        if (constructor == null) {
            Class clazz = this.typeNameToClass(type);
            try {
                constructor = clazz.getConstructor(RelInput.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("class does not have required constructor, " + clazz + "(RelInput)");
            }
            this.constructorMap.put(type, constructor);
        }
        return constructor;
    }

    public Class typeNameToClass(String type) {
        if (!type.contains(".")) {
            for (String package_ : PACKAGES) {
                try {
                    return Class.forName(package_ + type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unknown type " + type);
        }
    }

    public String classToTypeName(Class<? extends RelNode> class_) {
        String canonicalName = class_.getName();
        for (String package_ : PACKAGES) {
            String remaining;
            if (!canonicalName.startsWith(package_) || (remaining = canonicalName.substring(package_.length())).indexOf(46) >= 0 || remaining.indexOf(36) >= 0) continue;
            return remaining;
        }
        return canonicalName;
    }

    public Object toJson(RelCollationImpl node) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (RelFieldCollation fieldCollation : node.getFieldCollations()) {
            Map<String, Object> map2 = this.jsonBuilder.map();
            map2.put("field", fieldCollation.getFieldIndex());
            map2.put("direction", fieldCollation.getDirection().name());
            map2.put("nulls", fieldCollation.nullDirection.name());
            list.add(map2);
        }
        return list;
    }

    public RelCollation toCollation(List<Map<String, Object>> jsonFieldCollations) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (Map<String, Object> map2 : jsonFieldCollations) {
            fieldCollations.add(this.toFieldCollation(map2));
        }
        return RelCollations.of(fieldCollations);
    }

    public RelFieldCollation toFieldCollation(Map<String, Object> map2) {
        Integer field = (Integer)map2.get("field");
        RelFieldCollation.Direction direction = (RelFieldCollation.Direction)((Object)Util.enumVal(RelFieldCollation.Direction.class, (String)map2.get("direction")));
        RelFieldCollation.NullDirection nullDirection = (RelFieldCollation.NullDirection)((Object)Util.enumVal(RelFieldCollation.NullDirection.class, (String)map2.get("nulls")));
        return new RelFieldCollation(field, direction, nullDirection);
    }

    public RelDistribution toDistribution(Object o) {
        return RelDistributions.ANY;
    }

    public RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof List) {
            List jsonList = (List)o;
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map jsonMap : jsonList) {
                builder.add((String)jsonMap.get("name"), this.toType(typeFactory, jsonMap));
            }
            return builder.build();
        }
        Map map2 = (Map)o;
        SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)map2.get("type")));
        Integer precision = (Integer)map2.get("precision");
        Integer scale = (Integer)map2.get("scale");
        RelDataType type = precision == null ? typeFactory.createSqlType(sqlTypeName) : (scale == null ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName, precision, scale));
        boolean nullable = (Boolean)map2.get("nullable");
        return typeFactory.createTypeWithNullability(type, nullable);
    }

    public Object toJson(AggregateCall node) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        map2.put("agg", this.toJson(node.getAggregation()));
        map2.put("type", this.toJson(node.getType()));
        map2.put("distinct", node.isDistinct());
        map2.put("operands", node.getArgList());
        return map2;
    }

    Object toJson(Object value) {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof RexNode) {
            return this.toJson((RexNode)value);
        }
        if (value instanceof CorrelationId) {
            return this.toJson((CorrelationId)value);
        }
        if (value instanceof List) {
            List<Object> list = this.jsonBuilder.list();
            for (Object o : (List)value) {
                list.add(this.toJson(o));
            }
            return list;
        }
        if (value instanceof ImmutableBitSet) {
            List<Object> list = this.jsonBuilder.list();
            for (Integer integer : (ImmutableBitSet)value) {
                list.add(this.toJson(integer));
            }
            return list;
        }
        if (value instanceof AggregateCall) {
            return this.toJson((AggregateCall)value);
        }
        if (value instanceof RelCollationImpl) {
            return this.toJson((RelCollationImpl)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        if (value instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value);
        }
        throw new UnsupportedOperationException("type not serializable: " + value + " (type " + value.getClass().getCanonicalName() + ")");
    }

    private Object toJson(RelDataType node) {
        if (node.isStruct()) {
            List<Object> list = this.jsonBuilder.list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            return list;
        }
        Map<String, Object> map2 = this.jsonBuilder.map();
        map2.put("type", node.getSqlTypeName().name());
        map2.put("nullable", node.isNullable());
        if (node.getSqlTypeName().allowsPrec()) {
            map2.put("precision", node.getPrecision());
        }
        if (node.getSqlTypeName().allowsScale()) {
            map2.put("scale", node.getScale());
        }
        return map2;
    }

    private Object toJson(RelDataTypeField node) {
        Map map2 = (Map)this.toJson(node.getType());
        map2.put("name", node.getName());
        return map2;
    }

    private Object toJson(CorrelationId node) {
        return node.getId();
    }

    private Object toJson(RexNode node) {
        switch (node.getKind()) {
            case FIELD_ACCESS: {
                Map<String, Object> map2 = this.jsonBuilder.map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map2.put("field", fieldAccess.getField().getName());
                map2.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map2;
            }
            case LITERAL: {
                RexLiteral literal2 = (RexLiteral)node;
                Object value2 = literal2.getValue2();
                if (value2 == null) {
                    Map<String, Object> map3 = this.jsonBuilder.map();
                    map3.put("literal", null);
                    map3.put("type", literal2.getTypeName().name());
                    return map3;
                }
                return value2;
            }
            case INPUT_REF: 
            case LOCAL_REF: {
                Map<String, Object> map4 = this.jsonBuilder.map();
                map4.put("input", ((RexSlot)node).getIndex());
                map4.put("name", ((RexSlot)node).getName());
                return map4;
            }
            case CORREL_VARIABLE: {
                Map<String, Object> map5 = this.jsonBuilder.map();
                map5.put("correl", ((RexCorrelVariable)node).getName());
                map5.put("type", this.toJson(node.getType()));
                return map5;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map<String, Object> map6 = this.jsonBuilder.map();
            map6.put("op", this.toJson(call.getOperator()));
            List<Object> list = this.jsonBuilder.list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map6.put("operands", list);
            switch (node.getKind()) {
                case CAST: {
                    map6.put("type", this.toJson(node.getType()));
                }
            }
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                map6.put("class", call.getOperator().getClass().getName());
            }
            return map6;
        }
        throw new UnsupportedOperationException("unknown rex " + node);
    }

    RexNode toRex(RelInput relInput, Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map map2 = (Map)o;
            String op = (String)map2.get("op");
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            if (op != null) {
                List operands = (List)map2.get("operands");
                Object jsonType = map2.get("type");
                SqlOperator operator = this.toOp(op, map2);
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                RelDataType type = jsonType != null ? this.toType(typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type, operator, rexOperands);
            }
            Integer input = (Integer)map2.get("input");
            if (input != null) {
                List<RelNode> inputNodes = relInput.getInputs();
                int i = input;
                for (RelNode inputNode : inputNodes) {
                    RelDataType rowType = inputNode.getRowType();
                    if (i < rowType.getFieldCount()) {
                        RelDataTypeField field = rowType.getFieldList().get(i);
                        return rexBuilder.makeInputRef(field.getType(), (int)input);
                    }
                    i -= rowType.getFieldCount();
                }
                throw new RuntimeException("input field " + input + " is out of range");
            }
            String field = (String)map2.get("field");
            if (field != null) {
                Object jsonExpr = map2.get("expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map2.get("correl");
            if (correl != null) {
                Object jsonType = map2.get("type");
                RelDataType type = this.toType(typeFactory, jsonType);
                return rexBuilder.makeCorrel(type, new CorrelationId(correl));
            }
            if (map2.containsKey("literal")) {
                Object literal2 = map2.get("literal");
                SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)map2.get("type")));
                if (literal2 == null) {
                    return rexBuilder.makeNullLiteral(typeFactory.createSqlType(sqlTypeName));
                }
                return this.toRex(relInput, literal2);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + o);
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)o);
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Double || number instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + o);
    }

    private List<RexNode> toRexList(RelInput relInput, List operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    private SqlOperator toOp(String op, Map<String, Object> map2) {
        List<SqlOperator> operatorList = SqlStdOperatorTable.instance().getOperatorList();
        for (SqlOperator operator : operatorList) {
            if (!operator.getName().equals(op)) continue;
            return operator;
        }
        String class_ = (String)map2.get("class");
        if (class_ != null) {
            return AvaticaUtils.instantiatePlugin(SqlOperator.class, class_);
        }
        return null;
    }

    SqlAggFunction toAggregation(String agg, Map<String, Object> map2) {
        return (SqlAggFunction)this.toOp(agg, map2);
    }

    private String toJson(SqlOperator operator) {
        return operator.getName();
    }
}

