/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class RelJsonReader {
    private static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private final RelOptCluster cluster;
    private final RelOptSchema relOptSchema;
    private final RelJson relJson = new RelJson(null);
    private final Map<String, RelNode> relMap = new LinkedHashMap<String, RelNode>();
    private RelNode lastRel;

    public RelJsonReader(RelOptCluster cluster, RelOptSchema relOptSchema, Schema schema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        Util.discard(schema);
    }

    public RelNode read(String s) throws IOException {
        this.lastRel = null;
        ObjectMapper mapper = new ObjectMapper();
        Map o = (Map)mapper.readValue(s, TYPE_REF);
        List rels = (List)o.get("rels");
        this.readRels(rels);
        System.out.println(this.lastRel);
        return this.lastRel;
    }

    private void readRels(List<Map<String, Object>> jsonRels) {
        for (Map<String, Object> jsonRel : jsonRels) {
            this.readRel(jsonRel);
        }
    }

    private void readRel(final Map<String, Object> jsonRel) {
        String id = (String)jsonRel.get("id");
        String type = (String)jsonRel.get("relOp");
        Constructor constructor = this.relJson.getConstructor(type);
        RelInput input = new RelInput(){

            @Override
            public RelOptCluster getCluster() {
                return RelJsonReader.this.cluster;
            }

            @Override
            public RelTraitSet getTraitSet() {
                return RelJsonReader.this.cluster.traitSetOf((RelTrait)Convention.NONE);
            }

            @Override
            public RelOptTable getTable(String table) {
                List<String> list = this.getStringList(table);
                return RelJsonReader.this.relOptSchema.getTableForMember(list);
            }

            @Override
            public RelNode getInput() {
                List<RelNode> inputs = this.getInputs();
                assert (inputs.size() == 1);
                return inputs.get(0);
            }

            @Override
            public List<RelNode> getInputs() {
                List<String> jsonInputs = this.getStringList("inputs");
                if (jsonInputs == null) {
                    return ImmutableList.of(RelJsonReader.this.lastRel);
                }
                ArrayList<RelNode> inputs = new ArrayList<RelNode>();
                for (String jsonInput : jsonInputs) {
                    inputs.add(RelJsonReader.this.lookupInput(jsonInput));
                }
                return inputs;
            }

            @Override
            public RexNode getExpression(String tag2) {
                return RelJsonReader.this.relJson.toRex(this, jsonRel.get(tag2));
            }

            @Override
            public ImmutableBitSet getBitSet(String tag2) {
                return ImmutableBitSet.of(this.getIntegerList(tag2));
            }

            @Override
            public List<ImmutableBitSet> getBitSetList(String tag2) {
                List<List<Integer>> list = this.getIntegerListList(tag2);
                if (list == null) {
                    return null;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (List<Integer> integers : list) {
                    builder.add(ImmutableBitSet.of(integers));
                }
                return builder.build();
            }

            @Override
            public List<String> getStringList(String tag2) {
                return (List)jsonRel.get(tag2);
            }

            @Override
            public List<Integer> getIntegerList(String tag2) {
                return (List)jsonRel.get(tag2);
            }

            @Override
            public List<List<Integer>> getIntegerListList(String tag2) {
                return (List)jsonRel.get(tag2);
            }

            @Override
            public List<AggregateCall> getAggregateCalls(String tag2) {
                List jsonAggs = (List)jsonRel.get(tag2);
                ArrayList<AggregateCall> inputs = new ArrayList<AggregateCall>();
                for (Map jsonAggCall : jsonAggs) {
                    inputs.add(RelJsonReader.this.toAggCall(jsonAggCall));
                }
                return inputs;
            }

            @Override
            public Object get(String tag2) {
                return jsonRel.get(tag2);
            }

            @Override
            public String getString(String tag2) {
                return (String)jsonRel.get(tag2);
            }

            @Override
            public float getFloat(String tag2) {
                return ((Number)jsonRel.get(tag2)).floatValue();
            }

            @Override
            public boolean getBoolean(String tag2, boolean default_) {
                Boolean b = (Boolean)jsonRel.get(tag2);
                return b != null ? b : default_;
            }

            @Override
            public <E extends Enum<E>> E getEnum(String tag2, Class<E> enumClass) {
                return (E)Util.enumVal(enumClass, this.getString(tag2).toUpperCase(Locale.ROOT));
            }

            @Override
            public List<RexNode> getExpressionList(String tag2) {
                List jsonNodes = (List)jsonRel.get(tag2);
                ArrayList<RexNode> nodes = new ArrayList<RexNode>();
                for (Object jsonNode : jsonNodes) {
                    nodes.add(RelJsonReader.this.relJson.toRex(this, jsonNode));
                }
                return nodes;
            }

            @Override
            public RelDataType getRowType(String tag2) {
                Object o = jsonRel.get(tag2);
                return RelJsonReader.this.relJson.toType(RelJsonReader.this.cluster.getTypeFactory(), o);
            }

            @Override
            public RelDataType getRowType(String expressionsTag, String fieldsTag) {
                final List<RexNode> expressionList = this.getExpressionList(expressionsTag);
                final List names = (List)this.get(fieldsTag);
                return RelJsonReader.this.cluster.getTypeFactory().createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return Pair.of(names.get(index), ((RexNode)expressionList.get(index)).getType());
                    }

                    @Override
                    public int size() {
                        return names.size();
                    }
                });
            }

            @Override
            public RelCollation getCollation() {
                return RelJsonReader.this.relJson.toCollation((List)this.get("collation"));
            }

            @Override
            public RelDistribution getDistribution() {
                return RelJsonReader.this.relJson.toDistribution(this.get("distribution"));
            }

            @Override
            public ImmutableList<ImmutableList<RexLiteral>> getTuples(String tag2) {
                List jsonTuples = (List)this.get(tag2);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (List jsonTuple : jsonTuples) {
                    builder.add(this.getTuple(jsonTuple));
                }
                return builder.build();
            }

            public ImmutableList<RexLiteral> getTuple(List jsonTuple) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object jsonValue : jsonTuple) {
                    builder.add((RexLiteral)RelJsonReader.this.relJson.toRex(this, jsonValue));
                }
                return builder.build();
            }
        };
        try {
            RelNode rel = (RelNode)constructor.newInstance(input);
            this.relMap.put(id, rel);
            this.lastRel = rel;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
    }

    private AggregateCall toAggCall(Map<String, Object> jsonAggCall) {
        String aggName = (String)jsonAggCall.get("agg");
        SqlAggFunction aggregation = this.relJson.toAggregation(aggName, jsonAggCall);
        Boolean distinct2 = (Boolean)jsonAggCall.get("distinct");
        List operands = (List)jsonAggCall.get("operands");
        Integer filterOperand = (Integer)jsonAggCall.get("filter");
        RelDataType type = this.relJson.toType(this.cluster.getTypeFactory(), jsonAggCall.get("type"));
        return AggregateCall.create(aggregation, distinct2, operands, filterOperand == null ? -1 : filterOperand, type, null);
    }

    private RelNode lookupInput(String jsonInput) {
        RelNode node = this.relMap.get(jsonInput);
        if (node == null) {
            throw new RuntimeException("unknown id " + jsonInput + " for relational expression");
        }
        return node;
    }
}

