/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;

public class ReflectiveRelMetadataProvider
implements RelMetadataProvider,
ReflectiveVisitor {
    private final ConcurrentMap<Class<RelNode>, UnboundMetadata> map;
    private final Class<? extends Metadata> metadataClass0;
    private final ImmutableMultimap<Method, MetadataHandler> handlerMap;

    protected ReflectiveRelMetadataProvider(ConcurrentMap<Class<RelNode>, UnboundMetadata> map2, Class<? extends Metadata> metadataClass0, Multimap<Method, MetadataHandler> handlerMap) {
        assert (!map2.isEmpty()) : "are your methods named wrong?";
        this.map = map2;
        this.metadataClass0 = metadataClass0;
        this.handlerMap = ImmutableMultimap.copyOf(handlerMap);
    }

    public static RelMetadataProvider reflectiveSource(Method method, MetadataHandler target) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, ImmutableList.of(method));
    }

    public static RelMetadataProvider reflectiveSource(MetadataHandler target, Method ... methods) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, ImmutableList.copyOf(methods));
    }

    private static RelMetadataProvider reflectiveSource(final MetadataHandler target, final ImmutableList<Method> methods) {
        final Space2 space = Space2.create(target, methods);
        ConcurrentHashMap<Class<RelNode>, UnboundMetadata> methodsMap = new ConcurrentHashMap<Class<RelNode>, UnboundMetadata>();
        for (Class key : space.classes) {
            ImmutableNullableList.Builder<Method> builder = ImmutableNullableList.builder();
            for (Method method : methods) {
                builder.add(space.find(key, method));
            }
            final List handlerMethods = builder.build();
            UnboundMetadata function2 = new UnboundMetadata(){

                public Metadata bind(final RelNode rel, final RelMetadataQuery mq) {
                    return (Metadata)Proxy.newProxyInstance(space.metadataClass0.getClassLoader(), new Class[]{space.metadataClass0}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object args2;
                            List<Object> key;
                            Object[] args1;
                            if (method.equals(BuiltInMethod.METADATA_REL.method)) {
                                return rel;
                            }
                            if (method.equals(BuiltInMethod.OBJECT_TO_STRING.method)) {
                                return space.metadataClass0.getSimpleName() + "(" + rel + ")";
                            }
                            int i = methods.indexOf(method);
                            if (i < 0) {
                                throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                            }
                            Method handlerMethod = (Method)handlerMethods.get(i);
                            if (handlerMethod == null) {
                                throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                            }
                            if (args == null) {
                                args1 = new Object[]{rel, mq};
                                key = FlatLists.of(rel, method);
                            } else {
                                args1 = new Object[args.length + 2];
                                args1[0] = rel;
                                args1[1] = mq;
                                System.arraycopy(args, 0, args1, 2, args.length);
                                args2 = (Object[])args1.clone();
                                args2[1] = method;
                                for (int j = 0; j < ((Object[])args2).length; ++j) {
                                    if (args2[j] == null) {
                                        args2[j] = NullSentinel.INSTANCE;
                                        continue;
                                    }
                                    if (!(args2[j] instanceof RexNode)) continue;
                                    args2[j] = args2[j].toString();
                                }
                                key = FlatLists.copyOf(args2);
                            }
                            if (mq.map.put(key, (Object)NullSentinel.INSTANCE) != null) {
                                throw CyclicMetadataException.INSTANCE;
                            }
                            try {
                                args2 = handlerMethod.invoke((Object)target, args1);
                                return args2;
                            }
                            catch (InvocationTargetException | UndeclaredThrowableException e) {
                                Util.throwIfUnchecked(e.getCause());
                                throw new RuntimeException(e.getCause());
                            }
                            finally {
                                mq.map.remove(key);
                            }
                        }
                    });
                }
            };
            methodsMap.put(key, function2);
        }
        return new ReflectiveRelMetadataProvider(methodsMap, space.metadataClass0, space.providerMap);
    }

    @Override
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry2 : this.handlerMap.entries()) {
            if (!def.methods.contains(entry2.getKey())) continue;
            builder.put(entry2.getKey(), entry2.getValue());
        }
        return builder.build();
    }

    private static boolean couldImplement(Method handlerMethod, Method method) {
        Class<?>[] parameterTypes;
        if (!handlerMethod.getName().equals(method.getName()) || (handlerMethod.getModifiers() & 8) != 0 || (handlerMethod.getModifiers() & 1) == 0) {
            return false;
        }
        Class<?>[] parameterTypes1 = handlerMethod.getParameterTypes();
        return parameterTypes1.length == (parameterTypes = method.getParameterTypes()).length + 2 && RelNode.class.isAssignableFrom(parameterTypes1[0]) && RelMetadataQuery.class == parameterTypes1[1] && Arrays.asList(parameterTypes).equals(Util.skip(Arrays.asList(parameterTypes1), 2));
    }

    @Override
    public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relClass, Class<? extends M> metadataClass) {
        if (metadataClass == this.metadataClass0) {
            return this.apply(relClass);
        }
        return null;
    }

    public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relClass) {
        ArrayList<Class<? extends RelNode>> newSources = new ArrayList<Class<? extends RelNode>>();
        while (true) {
            UnboundMetadata function2;
            if ((function2 = (UnboundMetadata)this.map.get(relClass)) != null) {
                for (Class clazz : newSources) {
                    this.map.put(clazz, function2);
                }
                return function2;
            }
            newSources.add(relClass);
            for (Class<?> interfaceClass : relClass.getInterfaces()) {
                UnboundMetadata function22;
                if (!RelNode.class.isAssignableFrom(interfaceClass) || (function22 = (UnboundMetadata)this.map.get(interfaceClass)) == null) continue;
                for (Class clazz : newSources) {
                    this.map.put(clazz, function22);
                }
                return function22;
            }
            if (!RelNode.class.isAssignableFrom(relClass.getSuperclass())) break;
            relClass = relClass.getSuperclass();
        }
        return null;
    }

    static class Space2
    extends Space {
        private Class<Metadata> metadataClass0;

        public Space2(Class<Metadata> metadataClass0, ImmutableMultimap<Method, MetadataHandler> providerMap) {
            super(providerMap);
            this.metadataClass0 = metadataClass0;
        }

        public static Space2 create(MetadataHandler target, ImmutableList<Method> methods) {
            assert (methods.size() > 0);
            Method method0 = (Method)methods.get(0);
            Class<Metadata> metadataClass0 = method0.getDeclaringClass();
            assert (Metadata.class.isAssignableFrom(metadataClass0));
            for (Method method : methods) {
                assert (method.getDeclaringClass() == metadataClass0);
            }
            ImmutableMultimap.Builder<Method, MetadataHandler> providerBuilder = ImmutableMultimap.builder();
            for (Method method : methods) {
                providerBuilder.put(method, target);
            }
            return new Space2(metadataClass0, providerBuilder.build());
        }
    }

    static class Space {
        final Set<Class<RelNode>> classes = new HashSet<Class<RelNode>>();
        final Map<Pair<Class<RelNode>, Method>, Method> handlerMap = new HashMap<Pair<Class<RelNode>, Method>, Method>();
        final ImmutableMultimap<Method, MetadataHandler> providerMap;

        Space(Multimap<Method, MetadataHandler> providerMap) {
            this.providerMap = ImmutableMultimap.copyOf(providerMap);
            for (Map.Entry<Method, MetadataHandler> entry2 : providerMap.entries()) {
                Method method = entry2.getKey();
                MetadataHandler provider = entry2.getValue();
                for (Method handlerMethod : provider.getClass().getMethods()) {
                    if (!ReflectiveRelMetadataProvider.couldImplement(handlerMethod, method)) continue;
                    Class<?> relNodeClass = handlerMethod.getParameterTypes()[0];
                    this.classes.add(relNodeClass);
                    this.handlerMap.put(Pair.of(relNodeClass, method), handlerMethod);
                }
            }
        }

        Method find(Class<? extends RelNode> relNodeClass, Method method) {
            Preconditions.checkNotNull(relNodeClass);
            Class<? extends RelNode> r = relNodeClass;
            do {
                Method implementingMethod;
                if ((implementingMethod = this.handlerMap.get(Pair.of(r, method))) != null) {
                    return implementingMethod;
                }
                for (Class<?> clazz : r.getInterfaces()) {
                    if (!RelNode.class.isAssignableFrom(clazz) || (implementingMethod = this.handlerMap.get(Pair.of(clazz, method))) == null) continue;
                    return implementingMethod;
                }
            } while ((r = r.getSuperclass()) != null && RelNode.class.isAssignableFrom(r));
            throw new IllegalArgumentException("No handler for method [" + method + "] applied to argument of type [" + relNodeClass + "]; we recommend you create a catch-all (RelNode) handler");
        }
    }
}

