/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.mapping.Mappings;

public class SortProjectTransposeRule
extends RelOptRule {
    public static final SortProjectTransposeRule INSTANCE = new SortProjectTransposeRule(Sort.class, LogicalProject.class, null);

    @Deprecated
    public SortProjectTransposeRule(Class<? extends Sort> sortClass, Class<? extends Project> projectClass) {
        this(sortClass, projectClass, null);
    }

    public SortProjectTransposeRule(Class<? extends Sort> sortClass, Class<? extends Project> projectClass, String description) {
        super(SortProjectTransposeRule.operand(sortClass, SortProjectTransposeRule.operand(projectClass, SortProjectTransposeRule.any()), new RelOptRuleOperand[0]), description);
    }

    protected SortProjectTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort2 = (Sort)call.rel(0);
        Project project = (Project)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        if (sort2.getConvention() != project.getConvention()) {
            return;
        }
        Mappings.TargetMapping map2 = RelOptUtil.permutationIgnoreCast(project.getProjects(), project.getInput().getRowType());
        for (RelFieldCollation fc : sort2.getCollation().getFieldCollations()) {
            if (map2.getTargetOpt(fc.getFieldIndex()) < 0) {
                return;
            }
            RexNode node = project.getProjects().get(fc.getFieldIndex());
            if (!node.isA(SqlKind.CAST)) continue;
            RexCall cast2 = (RexCall)node;
            RexCallBinding binding2 = RexCallBinding.create(cluster.getTypeFactory(), cast2, ImmutableList.of(RexUtil.apply(map2, sort2.getCollation())));
            if (cast2.getOperator().getMonotonicity(binding2) != SqlMonotonicity.NOT_MONOTONIC) continue;
            return;
        }
        RelCollation newCollation = cluster.traitSet().canonize(RexUtil.apply(map2, sort2.getCollation()));
        Sort newSort = sort2.copy(sort2.getTraitSet().replace(newCollation), project.getInput(), newCollation, sort2.offset, sort2.fetch);
        RelNode newProject = project.copy(sort2.getTraitSet(), ImmutableList.of(newSort));
        ImmutableMap<RelNode, RelNode> equiv = sort2.offset == null && sort2.fetch == null && cluster.getPlanner().getRelTraitDefs().contains(RelCollationTraitDef.INSTANCE) ? ImmutableMap.of(newSort, project.getInput()) : ImmutableMap.of();
        call.transformTo(newProject, equiv);
    }
}

