/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;

public class SqlShuttle
extends SqlBasicVisitor<SqlNode> {
    @Override
    public SqlNode visit(SqlLiteral literal2) {
        return literal2;
    }

    @Override
    public SqlNode visit(SqlIdentifier id) {
        return id;
    }

    @Override
    public SqlNode visit(SqlDataTypeSpec type) {
        return type;
    }

    @Override
    public SqlNode visit(SqlDynamicParam param) {
        return param;
    }

    @Override
    public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
        return intervalQualifier;
    }

    @Override
    public SqlNode visit(SqlCall call) {
        CallCopyingArgHandler argHandler = new CallCopyingArgHandler(call, false);
        call.getOperator().acceptCall(this, call, false, argHandler);
        return (SqlNode)argHandler.result();
    }

    @Override
    public SqlNode visit(SqlNodeList nodeList) {
        boolean update2 = false;
        List<SqlNode> exprs = nodeList.getList();
        int exprCount = exprs.size();
        ArrayList<SqlNode> newList = new ArrayList<SqlNode>(exprCount);
        for (SqlNode operand : exprs) {
            SqlNode clonedOperand;
            if (operand == null) {
                clonedOperand = null;
            } else {
                clonedOperand = operand.accept(this);
                if (clonedOperand != operand) {
                    update2 = true;
                }
            }
            newList.add(clonedOperand);
        }
        if (update2) {
            return new SqlNodeList(newList, nodeList.getParserPosition());
        }
        return nodeList;
    }

    protected class CallCopyingArgHandler
    implements SqlBasicVisitor.ArgHandler<SqlNode> {
        boolean update;
        SqlNode[] clonedOperands;
        private final SqlCall call;
        private final boolean alwaysCopy;

        public CallCopyingArgHandler(SqlCall call, boolean alwaysCopy) {
            this.call = call;
            this.update = false;
            List<SqlNode> operands = call.getOperandList();
            this.clonedOperands = operands.toArray(new SqlNode[operands.size()]);
            this.alwaysCopy = alwaysCopy;
        }

        @Override
        public SqlNode result() {
            if (this.update || this.alwaysCopy) {
                return this.call.getOperator().createCall(this.call.getFunctionQuantifier(), this.call.getParserPosition(), this.clonedOperands);
            }
            return this.call;
        }

        @Override
        public SqlNode visitChild(SqlVisitor<SqlNode> visitor, SqlNode expr, int i, SqlNode operand) {
            if (operand == null) {
                return null;
            }
            SqlNode newOperand = operand.accept(SqlShuttle.this);
            if (newOperand != operand) {
                this.update = true;
            }
            this.clonedOperands[i] = newOperand;
            return newOperand;
        }
    }
}

