/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.util.Util;

public class SqlNameMatchers {
    private static final BaseMatcher CASE_SENSITIVE = new BaseMatcher(true);
    private static final BaseMatcher CASE_INSENSITIVE = new BaseMatcher(false);

    private SqlNameMatchers() {
    }

    public static SqlNameMatcher withCaseSensitive(boolean caseSensitive) {
        return caseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
    }

    public static SqlNameMatcher liberal() {
        return new LiberalNameMatcher();
    }

    private static class LiberalNameMatcher
    extends BaseMatcher {
        List<String> matchedNames;

        LiberalNameMatcher() {
            super(false);
        }

        @Override
        protected boolean listMatches(List<String> list0, List<String> list1) {
            boolean b = super.listMatches(list0, list1);
            if (b) {
                this.matchedNames = ImmutableList.copyOf(list1);
            }
            return b;
        }

        @Override
        protected void matched(List<String> prefixNames, List<String> names) {
            this.matchedNames = ImmutableList.copyOf(Util.startsWith(names, prefixNames) ? Util.skip(names, prefixNames.size()) : names);
        }

        @Override
        public List<String> bestMatch() {
            return this.matchedNames;
        }
    }

    private static class BaseMatcher
    implements SqlNameMatcher {
        private final boolean caseSensitive;

        BaseMatcher(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public boolean matches(String string, String name) {
            return this.caseSensitive ? string.equals(name) : string.equalsIgnoreCase(name);
        }

        protected boolean listMatches(List<String> list0, List<String> list1) {
            if (list0.size() != list1.size()) {
                return false;
            }
            for (int i = 0; i < list0.size(); ++i) {
                String s1;
                String s0 = list0.get(i);
                if (this.matches(s0, s1 = list1.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public <K extends List<String>, V> V get(Map<K, V> map2, List<String> prefixNames, List<String> names) {
            List<String> key = this.concat(prefixNames, names);
            if (this.caseSensitive) {
                return map2.get(key);
            }
            for (Map.Entry<K, V> entry2 : map2.entrySet()) {
                if (!this.listMatches(key, (List)entry2.getKey())) continue;
                this.matched(prefixNames, (List)entry2.getKey());
                return entry2.getValue();
            }
            return null;
        }

        private List<String> concat(List<String> prefixNames, List<String> names) {
            if (prefixNames.isEmpty()) {
                return names;
            }
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(prefixNames)).addAll(names)).build();
        }

        protected void matched(List<String> prefixNames, List<String> names) {
        }

        protected List<String> bestMatch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String bestString() {
            return SqlIdentifier.getString(this.bestMatch());
        }

        @Override
        public RelDataTypeField field(RelDataType rowType, String fieldName2) {
            return rowType.getField(fieldName2, this.caseSensitive, false);
        }
    }
}

