/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public abstract class SqlScopedShuttle
extends SqlShuttle {
    private final Deque<SqlValidatorScope> scopes = new ArrayDeque<SqlValidatorScope>();

    protected SqlScopedShuttle(SqlValidatorScope initialScope) {
        this.scopes.push(initialScope);
    }

    @Override
    public final SqlNode visit(SqlCall call) {
        SqlValidatorScope oldScope = this.scopes.peek();
        SqlValidatorScope newScope = oldScope.getOperandScope(call);
        this.scopes.push(newScope);
        SqlNode result2 = this.visitScoped(call);
        this.scopes.pop();
        return result2;
    }

    protected SqlNode visitScoped(SqlCall call) {
        return super.visit(call);
    }

    protected SqlValidatorScope getScope() {
        return this.scopes.peek();
    }
}

