/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptSchemaWithSampling;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.schema.CustomColumnResolvingTable;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlScopedShuttle;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class SqlValidatorUtil {
    public static final Suggester EXPR_SUGGESTER = new Suggester(){

        @Override
        public String apply(String original, int attempt, int size) {
            return Util.first(original, "EXPR$") + attempt;
        }
    };
    public static final Suggester F_SUGGESTER = new Suggester(){

        @Override
        public String apply(String original, int attempt, int size) {
            return Util.first(original, "$f") + Math.max(size, attempt);
        }
    };

    private SqlValidatorUtil() {
    }

    public static RelOptTable getRelOptTable(SqlValidatorNamespace namespace, Prepare.CatalogReader catalogReader, String datasetName, boolean[] usedDataset) {
        RelOptTable table;
        if (!namespace.isWrapperFor(TableNamespace.class)) {
            return null;
        }
        TableNamespace tableNamespace = namespace.unwrap(TableNamespace.class);
        List<String> names = tableNamespace.getTable().getQualifiedName();
        if (datasetName != null && catalogReader instanceof RelOptSchemaWithSampling) {
            RelOptSchemaWithSampling reader = (RelOptSchemaWithSampling)((Object)catalogReader);
            table = reader.getTableForMember(names, datasetName, usedDataset);
        } else {
            table = catalogReader.getTableForMember(names);
        }
        if (!tableNamespace.extendedFields.isEmpty()) {
            table = table.extend(tableNamespace.extendedFields);
        }
        return table;
    }

    public static List<RelDataTypeField> getExtendedColumns(SqlValidator validator, SqlValidatorTable table, SqlNodeList extendedColumns) {
        ImmutableList.Builder extendedFields = ImmutableList.builder();
        ExtensibleTable extTable = table.unwrap(ExtensibleTable.class);
        int extendedFieldOffset = extTable == null ? table.getRowType().getFieldCount() : extTable.getExtendedColumnOffset();
        for (Pair<SqlIdentifier, SqlDataTypeSpec> pair : SqlValidatorUtil.pairs(extendedColumns)) {
            SqlIdentifier identifier = (SqlIdentifier)pair.left;
            SqlDataTypeSpec type = (SqlDataTypeSpec)pair.right;
            extendedFields.add(new RelDataTypeFieldImpl(identifier.getSimple(), extendedFieldOffset++, type.deriveType(validator)));
        }
        return extendedFields.build();
    }

    private static List<Pair<SqlIdentifier, SqlDataTypeSpec>> pairs(SqlNodeList extendedColumns) {
        List<SqlNode> list = extendedColumns.getList();
        return Pair.zip(Util.quotientList(list, 2, 0), Util.quotientList(list, 2, 1));
    }

    public static ImmutableMap<Integer, RelDataTypeField> getIndexToFieldMap(List<RelDataTypeField> sourceFields, RelDataType targetFields) {
        ImmutableMap.Builder<Integer, RelDataTypeField> output = ImmutableMap.builder();
        for (RelDataTypeField source : sourceFields) {
            RelDataTypeField target = targetFields.getField(source.getName(), true, false);
            if (target == null) continue;
            output.put(source.getIndex(), target);
        }
        return output.build();
    }

    public static ImmutableBitSet getOrdinalBitSet(RelDataType sourceRowType, RelDataType targetRowType) {
        ImmutableMap<Integer, RelDataTypeField> indexToField = SqlValidatorUtil.getIndexToFieldMap(sourceRowType.getFieldList(), targetRowType);
        return SqlValidatorUtil.getOrdinalBitSet(sourceRowType, indexToField);
    }

    public static ImmutableBitSet getOrdinalBitSet(RelDataType sourceRowType, Map<Integer, RelDataTypeField> indexToField) {
        ImmutableBitSet source = ImmutableBitSet.of(Lists.transform(sourceRowType.getFieldList(), new RelDataTypeField.ToFieldIndex()));
        ImmutableBitSet target = ImmutableBitSet.of(indexToField.keySet());
        return source.intersect(target);
    }

    static Map<String, Integer> mapNameToIndex(List<RelDataTypeField> fields) {
        ImmutableMap.Builder<String, Integer> output = ImmutableMap.builder();
        for (RelDataTypeField field : fields) {
            output.put(field.getName(), field.getIndex());
        }
        return output.build();
    }

    @Deprecated
    public static RelDataTypeField lookupField(boolean caseSensitive, RelDataType rowType, String columnName) {
        return rowType.getField(columnName, caseSensitive, false);
    }

    public static void checkCharsetAndCollateConsistentIfCharType(RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset strCharset = type.getCharset();
            Charset colCharset = type.getCollation().getCharset();
            assert (null != strCharset);
            assert (null != colCharset);
            if (!strCharset.equals(colCharset)) {
                // empty if block
            }
        }
    }

    public static SqlNode addAlias(SqlNode expr, String alias) {
        SqlParserPos pos = expr.getParserPosition();
        SqlIdentifier id = new SqlIdentifier(alias, pos);
        return SqlStdOperatorTable.AS.createCall(pos, expr, id);
    }

    public static String getAlias(SqlNode node, int ordinal) {
        switch (node.getKind()) {
            case AS: {
                return ((SqlNode)((SqlCall)node).operand(1)).toString();
            }
            case OVER: {
                return SqlValidatorUtil.getAlias(((SqlCall)node).operand(0), ordinal);
            }
            case IDENTIFIER: {
                return Util.last(((SqlIdentifier)node).names);
            }
        }
        if (ordinal < 0) {
            return null;
        }
        return SqlUtil.deriveAliasFromOrdinal(ordinal);
    }

    public static SqlValidatorWithHints newValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
        return new SqlValidatorImpl(opTab, catalogReader, typeFactory, conformance);
    }

    @Deprecated
    public static SqlValidatorWithHints newValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
        return SqlValidatorUtil.newValidator(opTab, catalogReader, typeFactory, SqlConformanceEnum.DEFAULT);
    }

    public static String uniquify(String name, Set<String> usedNames, Suggester suggester) {
        if (name != null && usedNames.add(name)) {
            return name;
        }
        String originalName = name;
        int j = 0;
        while (!usedNames.add(name = suggester.apply(originalName, j, usedNames.size()))) {
            ++j;
        }
        return name;
    }

    @Deprecated
    public static List<String> uniquify(List<String> nameList) {
        return SqlValidatorUtil.uniquify(nameList, EXPR_SUGGESTER, true);
    }

    @Deprecated
    public static List<String> uniquify(List<String> nameList, Suggester suggester) {
        return SqlValidatorUtil.uniquify(nameList, suggester, true);
    }

    public static List<String> uniquify(List<String> nameList, boolean caseSensitive) {
        return SqlValidatorUtil.uniquify(nameList, EXPR_SUGGESTER, caseSensitive);
    }

    public static List<String> uniquify(List<String> nameList, Suggester suggester, boolean caseSensitive) {
        LinkedHashSet<String> used = caseSensitive ? new LinkedHashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        int changeCount = 0;
        ArrayList<String> newNameList = new ArrayList<String>();
        for (String name : nameList) {
            String uniqueName = SqlValidatorUtil.uniquify(name, used, suggester);
            if (!uniqueName.equals(name)) {
                ++changeCount;
            }
            newNameList.add(uniqueName);
        }
        return changeCount == 0 ? nameList : newNameList;
    }

    public static RelDataType deriveJoinRowType(RelDataType leftType, RelDataType rightType, JoinRelType joinType, RelDataTypeFactory typeFactory, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        assert (systemFieldList != null);
        switch (joinType) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
        }
        return SqlValidatorUtil.createJoinType(typeFactory, leftType, rightType, fieldNameList, systemFieldList);
    }

    public static RelDataType createJoinType(RelDataTypeFactory typeFactory, RelDataType leftType, RelDataType rightType, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        assert (fieldNameList == null || fieldNameList.size() == systemFieldList.size() + leftType.getFieldCount() + rightType.getFieldCount());
        List<String> nameList = new ArrayList<String>();
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        HashSet<String> uniqueNameList = typeFactory.getTypeSystem().isSchemaCaseSensitive() ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        SqlValidatorUtil.addFields(systemFieldList, typeList, nameList, uniqueNameList);
        SqlValidatorUtil.addFields(leftType.getFieldList(), typeList, nameList, uniqueNameList);
        if (rightType != null) {
            SqlValidatorUtil.addFields(rightType.getFieldList(), typeList, nameList, uniqueNameList);
        }
        if (fieldNameList != null) {
            assert (fieldNameList.size() == nameList.size());
            nameList = fieldNameList;
        }
        return typeFactory.createStructType(typeList, nameList);
    }

    private static void addFields(List<RelDataTypeField> fieldList, List<RelDataType> typeList, List<String> nameList, Set<String> uniqueNames) {
        for (RelDataTypeField field : fieldList) {
            String name = field.getName();
            if (uniqueNames.contains(name)) {
                String nameBase = name;
                int j = 0;
                while (uniqueNames.contains(name = nameBase + j)) {
                    ++j;
                }
            }
            nameList.add(name);
            uniqueNames.add(name);
            typeList.add(field.getType());
        }
    }

    public static RelDataTypeField getTargetField(RelDataType rowType, RelDataTypeFactory typeFactory, SqlIdentifier id, SqlValidatorCatalogReader catalogReader, RelOptTable table) {
        Table t;
        Table table2 = t = table == null ? null : table.unwrap(Table.class);
        if (!(t instanceof CustomColumnResolvingTable)) {
            SqlNameMatcher nameMatcher = catalogReader.nameMatcher();
            return nameMatcher.field(rowType, id.getSimple());
        }
        List<Pair<RelDataTypeField, List<String>>> entries = ((CustomColumnResolvingTable)t).resolveColumn(rowType, typeFactory, id.names);
        switch (entries.size()) {
            case 1: {
                if (!entries.get(0).getValue().isEmpty()) {
                    return null;
                }
                return entries.get(0).getKey();
            }
        }
        return null;
    }

    public static SqlValidatorNamespace lookup(SqlValidatorScope scope, List<String> names) {
        assert (names.size() > 0);
        SqlNameMatcher nameMatcher = scope.getValidator().getCatalogReader().nameMatcher();
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        scope.resolve(ImmutableList.of(names.get(0)), nameMatcher, false, resolved);
        assert (resolved.count() == 1);
        SqlValidatorNamespace namespace = resolved.only().namespace;
        for (String name : Util.skip(names)) {
            namespace = namespace.lookupChild(name);
            assert (namespace != null);
        }
        return namespace;
    }

    public static void getSchemaObjectMonikers(SqlValidatorCatalogReader catalogReader, List<String> names, List<SqlMoniker> hints) {
        List<String> subNames = Util.skipLast(names);
        for (List<String> x : catalogReader.getSchemaPaths()) {
            ImmutableCollection names2 = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(x)).addAll(subNames)).build();
            hints.addAll(catalogReader.getAllSchemaObjectNames((List<String>)((Object)names2)));
        }
    }

    public static SelectScope getEnclosingSelectScope(SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof SelectScope) {
                return (SelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static AggregatingSelectScope getEnclosingAggregateSelectScope(SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof AggregatingSelectScope) {
                return (AggregatingSelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static List<String> deriveNaturalJoinColumnList(RelDataType leftRowType, RelDataType rightRowType) {
        ArrayList<String> naturalColumnNames = new ArrayList<String>();
        List<String> leftNames = leftRowType.getFieldNames();
        List<String> rightNames = rightRowType.getFieldNames();
        for (String name : leftNames) {
            if (Collections.frequency(leftNames, name) != 1 || Collections.frequency(rightNames, name) != 1) continue;
            naturalColumnNames.add(name);
        }
        return naturalColumnNames;
    }

    public static RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList, RelDataTypeFactory typeFactory, boolean caseSensitive) {
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>(columnNameList.size());
        for (String name : columnNameList) {
            RelDataTypeField field = type.getField(name, caseSensitive, false);
            fields.add(type.getFieldList().get(field.getIndex()));
        }
        return typeFactory.createStructType(fields);
    }

    public static void analyzeGroupItem(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, ImmutableList.Builder<ImmutableList<ImmutableBitSet>> topBuilder, SqlNode groupExpr) {
        switch (groupExpr.getKind()) {
            case ROLLUP: 
            case CUBE: {
                List<ImmutableBitSet> bitSets = SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)groupExpr).getOperandList());
                switch (groupExpr.getKind()) {
                    case ROLLUP: {
                        topBuilder.add((Object)SqlValidatorUtil.rollup(bitSets));
                        return;
                    }
                }
                topBuilder.add((Object)SqlValidatorUtil.cube(bitSets));
                return;
            }
            case OTHER: {
                if (!(groupExpr instanceof SqlNodeList)) break;
                SqlNodeList list = (SqlNodeList)groupExpr;
                for (SqlNode node : list) {
                    SqlValidatorUtil.analyzeGroupItem(scope, groupAnalyzer, topBuilder, node);
                }
                return;
            }
        }
        ImmutableList.Builder<ImmutableBitSet> builder = ImmutableList.builder();
        SqlValidatorUtil.convertGroupSet(scope, groupAnalyzer, builder, groupExpr);
        topBuilder.add(builder.build());
    }

    private static void convertGroupSet(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, ImmutableList.Builder<ImmutableBitSet> builder, SqlNode groupExpr) {
        switch (groupExpr.getKind()) {
            case GROUPING_SETS: {
                SqlCall call = (SqlCall)groupExpr;
                for (SqlNode node : call.getOperandList()) {
                    SqlValidatorUtil.convertGroupSet(scope, groupAnalyzer, builder, node);
                }
                return;
            }
            case ROW: {
                List<ImmutableBitSet> bitSets = SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)groupExpr).getOperandList());
                builder.add((Object)ImmutableBitSet.union(bitSets));
                return;
            }
        }
        builder.add((Object)SqlValidatorUtil.analyzeGroupExpr(scope, groupAnalyzer, groupExpr));
    }

    private static List<ImmutableBitSet> analyzeGroupTuple(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, List<SqlNode> operandList) {
        ArrayList<ImmutableBitSet> list = Lists.newArrayList();
        for (SqlNode operand : operandList) {
            list.add(SqlValidatorUtil.analyzeGroupExpr(scope, groupAnalyzer, operand));
        }
        return list;
    }

    private static ImmutableBitSet analyzeGroupExpr(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, SqlNode groupExpr) {
        SqlNode expandedGroupExpr = scope.getValidator().expand(groupExpr, scope);
        switch (expandedGroupExpr.getKind()) {
            case ROW: {
                return ImmutableBitSet.union(SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)expandedGroupExpr).getOperandList()));
            }
            case OTHER: {
                if (!(expandedGroupExpr instanceof SqlNodeList) || ((SqlNodeList)expandedGroupExpr).size() != 0) break;
                return ImmutableBitSet.of();
            }
        }
        int ref = SqlValidatorUtil.lookupGroupExpr(groupAnalyzer, groupExpr);
        if (expandedGroupExpr instanceof SqlIdentifier) {
            SqlIdentifier expr = (SqlIdentifier)expandedGroupExpr;
            assert (expr.names.size() == 2);
            String originalRelName = (String)expr.names.get(0);
            String originalFieldName = (String)expr.names.get(1);
            SqlNameMatcher nameMatcher = scope.getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            scope.resolve(ImmutableList.of(originalRelName), nameMatcher, false, resolved);
            assert (resolved.count() == 1);
            SqlValidatorScope.Resolve resolve2 = resolved.only();
            RelDataType rowType = resolve2.rowType();
            int childNamespaceIndex = resolve2.path.steps().get((int)0).i;
            int namespaceOffset = 0;
            if (childNamespaceIndex > 0) {
                SqlValidatorScope ancestorScope = resolve2.scope;
                assert (ancestorScope instanceof ListScope);
                List<SqlValidatorNamespace> children2 = ((ListScope)ancestorScope).getChildren();
                for (int j = 0; j < childNamespaceIndex; ++j) {
                    namespaceOffset += children2.get(j).getRowType().getFieldCount();
                }
            }
            RelDataTypeField field = nameMatcher.field(rowType, originalFieldName);
            int origPos = namespaceOffset + field.getIndex();
            groupAnalyzer.groupExprProjection.put(origPos, ref);
        }
        return ImmutableBitSet.of(ref);
    }

    private static int lookupGroupExpr(GroupAnalyzer groupAnalyzer, SqlNode expr) {
        for (Ord node : Ord.zip(groupAnalyzer.groupExprs)) {
            if (!((SqlNode)node.e).equalsDeep(expr, Litmus.IGNORE)) continue;
            return node.i;
        }
        switch (expr.getKind()) {
            case HOP: 
            case TUMBLE: 
            case SESSION: {
                groupAnalyzer.extraExprs.add(expr);
            }
        }
        groupAnalyzer.groupExprs.add(expr);
        return groupAnalyzer.groupExprs.size() - 1;
    }

    @VisibleForTesting
    public static ImmutableList<ImmutableBitSet> rollup(List<ImmutableBitSet> bitSets) {
        LinkedHashSet<ImmutableBitSet> builder = Sets.newLinkedHashSet();
        while (true) {
            ImmutableBitSet union2 = ImmutableBitSet.union(bitSets);
            builder.add(union2);
            if (union2.isEmpty()) break;
            bitSets = bitSets.subList(0, bitSets.size() - 1);
        }
        return ImmutableList.copyOf(builder);
    }

    @VisibleForTesting
    public static ImmutableList<ImmutableBitSet> cube(List<ImmutableBitSet> bitSets) {
        LinkedHashSet<List<ImmutableBitSet>> builder = Sets.newLinkedHashSet();
        for (ImmutableBitSet bitSet : bitSets) {
            builder.add(Arrays.asList(bitSet, ImmutableBitSet.of()));
        }
        LinkedHashSet<ImmutableBitSet> flattenedBitSets = Sets.newLinkedHashSet();
        for (List o : Linq4j.product(builder)) {
            flattenedBitSets.add(ImmutableBitSet.union(o));
        }
        return ImmutableList.copyOf(flattenedBitSets);
    }

    public static boolean containsMonotonic(SqlValidatorScope scope) {
        for (SqlValidatorNamespace ns : SqlValidatorUtil.children(scope)) {
            ns = ns.resolve();
            for (String field : ns.getRowType().getFieldNames()) {
                if (ns.getMonotonicity(field).mayRepeat()) continue;
                return true;
            }
        }
        return false;
    }

    private static List<SqlValidatorNamespace> children(SqlValidatorScope scope) {
        return scope instanceof ListScope ? ((ListScope)scope).getChildren() : ImmutableList.of();
    }

    static boolean containsMonotonic(SelectScope scope, SqlNodeList nodes) {
        for (SqlNode node : nodes) {
            if (scope.getMonotonicity(node).mayRepeat()) continue;
            return true;
        }
        return false;
    }

    static class GroupAnalyzer {
        final List<SqlNode> extraExprs = new ArrayList<SqlNode>();
        final List<SqlNode> groupExprs;
        final Map<Integer, Integer> groupExprProjection = new HashMap<Integer, Integer>();
        int groupCount;

        GroupAnalyzer(List<SqlNode> groupExprs) {
            this.groupExprs = groupExprs;
        }

        SqlNode createGroupExpr() {
            return SqlLiteral.createCharString("xyz" + this.groupCount++, SqlParserPos.ZERO);
        }
    }

    public static interface Suggester {
        public String apply(String var1, int var2, int var3);
    }

    @Deprecated
    public static class DeepCopier
    extends SqlScopedShuttle {
        DeepCopier(SqlValidatorScope scope) {
            super(scope);
        }

        public static SqlNodeList copy(SqlValidatorScope scope, SqlNodeList list) {
            return (SqlNodeList)list.accept(new DeepCopier(scope));
        }

        @Override
        public SqlNode visit(SqlNodeList list) {
            SqlNodeList copy2 = new SqlNodeList(list.getParserPosition());
            for (SqlNode node : list) {
                copy2.add(node.accept(this));
            }
            return copy2;
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, true);
            call.getOperator().acceptCall(this, call, false, argHandler);
            return (SqlNode)argHandler.result();
        }

        @Override
        public SqlNode visit(SqlLiteral literal2) {
            return (SqlNode)literal2.clone();
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            SqlCall call = SqlUtil.makeCall(this.getScope().getValidator().getOperatorTable(), id);
            if (call != null) {
                return call;
            }
            return this.getScope().fullyQualify((SqlIdentifier)id).identifier;
        }

        @Override
        public SqlNode visit(SqlDataTypeSpec type) {
            return (SqlNode)type.clone();
        }

        @Override
        public SqlNode visit(SqlDynamicParam param) {
            return (SqlNode)param.clone();
        }

        @Override
        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return (SqlNode)intervalQualifier.clone();
        }
    }
}

