/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlNodeToRexConverter;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Util;

public class SqlNodeToRexConverterImpl
implements SqlNodeToRexConverter {
    private final SqlRexConvertletTable convertletTable;

    SqlNodeToRexConverterImpl(SqlRexConvertletTable convertletTable) {
        this.convertletTable = convertletTable;
    }

    @Override
    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        SqlRexConvertlet convertlet = this.convertletTable.get(call);
        if (convertlet != null) {
            return convertlet.convertCall(cx, call);
        }
        throw Util.needToImplement(call);
    }

    @Override
    public RexLiteral convertInterval(SqlRexContext cx, SqlIntervalQualifier intervalQualifier) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        return rexBuilder.makeIntervalLiteral(intervalQualifier);
    }

    @Override
    public RexNode convertLiteral(SqlRexContext cx, SqlLiteral literal2) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        SqlValidator validator = cx.getValidator();
        Object value = literal2.getValue();
        if (value == null) {
            RelDataType type;
            if (literal2.getTypeName() == SqlTypeName.BOOLEAN) {
                type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                type = typeFactory.createTypeWithNullability(type, true);
            } else {
                type = validator.getValidatedNodeType(literal2);
            }
            return rexBuilder.makeCast(type, rexBuilder.constantNull());
        }
        switch (literal2.getTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)value;
                return rexBuilder.makeExactLiteral(bd, literal2.createSqlType(typeFactory));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral((BigDecimal)value);
            }
            case CHAR: {
                return rexBuilder.makeCharLiteral((NlsString)value);
            }
            case BOOLEAN: {
                return rexBuilder.makeLiteral((Boolean)value);
            }
            case BINARY: {
                BitString bitString = (BitString)value;
                Preconditions.checkArgument(bitString.getBitCount() % 8 == 0, "incomplete octet");
                ByteString byteString = new ByteString(bitString.getAsByteArray());
                return rexBuilder.makeBinaryLiteral(byteString);
            }
            case SYMBOL: {
                return rexBuilder.makeFlag((Enum)value);
            }
            case TIMESTAMP: {
                return rexBuilder.makeTimestampLiteral((Calendar)value, ((SqlTimestampLiteral)literal2).getPrec());
            }
            case TIME: {
                return rexBuilder.makeTimeLiteral((Calendar)value, ((SqlTimeLiteral)literal2).getPrec());
            }
            case DATE: {
                return rexBuilder.makeDateLiteral((Calendar)value);
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                SqlIntervalQualifier sqlIntervalQualifier = ((SqlIntervalLiteral.IntervalValue)value).getIntervalQualifier();
                long l = (Long)SqlLiteral.value(literal2);
                return rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(l), sqlIntervalQualifier);
            }
        }
        throw Util.unexpected(literal2.getTypeName());
    }
}

