/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.BasicDatetime;

public abstract class ZonelessDatetime
implements BasicDatetime,
Serializable {
    private static final long serialVersionUID = -1274713852537224763L;
    public long internalTime;
    protected transient Calendar tempCal;
    protected transient DateFormat tempFormatter;
    protected transient String lastFormat;

    @Override
    public long getTime() {
        return this.internalTime;
    }

    @Override
    public void setZonelessTime(long value) {
        this.internalTime = value;
    }

    @Override
    public void setZonedTime(long value, TimeZone zone) {
        this.internalTime = value + (long)zone.getOffset(value);
    }

    public long getTimeValue() {
        long timePart = this.internalTime % 86400000L;
        if (timePart < 0L) {
            timePart += 86400000L;
        }
        return timePart;
    }

    public long getDateValue() {
        return this.internalTime - this.getTimeValue();
    }

    public void clearDate() {
        this.internalTime = this.getTimeValue();
    }

    public void clearTime() {
        this.internalTime = this.getDateValue();
    }

    public long getJdbcTime(TimeZone zone) {
        long timeValue = this.getTimeValue();
        return timeValue - (long)zone.getOffset(timeValue);
    }

    public long getJdbcDate(TimeZone zone) {
        Calendar cal = this.getCalendar(DateTimeUtils.GMT_ZONE);
        cal.setTimeInMillis(this.getDateValue());
        int year = cal.get(1);
        int doy = cal.get(6);
        cal.clear();
        cal.setTimeZone(zone);
        cal.set(1, year);
        cal.set(6, doy);
        return cal.getTimeInMillis();
    }

    public long getJdbcTimestamp(TimeZone zone) {
        Calendar cal = this.getCalendar(DateTimeUtils.GMT_ZONE);
        cal.setTimeInMillis(this.internalTime);
        int year = cal.get(1);
        int doy = cal.get(6);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millis = cal.get(14);
        cal.clear();
        cal.setTimeZone(zone);
        cal.set(1, year);
        cal.set(6, doy);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millis);
        return cal.getTimeInMillis();
    }

    public abstract Object toJdbcObject();

    protected Calendar getCalendar(TimeZone zone) {
        if (this.tempCal == null) {
            this.tempCal = Calendar.getInstance(zone, Locale.ROOT);
        } else {
            this.tempCal.setTimeZone(zone);
        }
        return this.tempCal;
    }

    protected DateFormat getFormatter(String format2) {
        if (this.tempFormatter != null && this.lastFormat.equals(format2)) {
            return this.tempFormatter;
        }
        this.tempFormatter = DateTimeUtils.newDateFormat(format2);
        this.tempFormatter.setTimeZone(DateTimeUtils.GMT_ZONE);
        this.lastFormat = format2;
        return this.tempFormatter;
    }
}

