/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.ZonelessDatetime;

public class ZonelessTimestamp
extends ZonelessDatetime {
    private static final long serialVersionUID = -6829714640541648394L;
    protected final int precision;
    protected transient Timestamp tempTimestamp;

    public ZonelessTimestamp() {
        this.precision = 0;
    }

    public ZonelessTimestamp(int precision) {
        this.precision = precision;
    }

    @Override
    public Object toJdbcObject() {
        return new Timestamp(this.getJdbcTimestamp(DateTimeUtils.DEFAULT_ZONE));
    }

    public String toString() {
        Timestamp ts = this.getTempTimestamp(this.getJdbcTimestamp(DateTimeUtils.DEFAULT_ZONE));
        String sts = ts.toString();
        if (sts.length() > 19 && ts.getNanos() == 0) {
            sts = sts.substring(0, 19);
        }
        return sts;
    }

    public String toString(String format2) {
        DateFormat formatter = this.getFormatter(format2);
        Timestamp ts = this.getTempTimestamp(this.getTime());
        return formatter.format(ts);
    }

    public static ZonelessTimestamp parse(String s) {
        return ZonelessTimestamp.parse(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static ZonelessTimestamp parse(String s, String format2) {
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral(s, format2, DateTimeUtils.GMT_ZONE);
        if (pt == null) {
            return null;
        }
        ZonelessTimestamp zt = new ZonelessTimestamp(pt.getPrecision());
        zt.setZonelessTime(pt.getCalendar().getTime().getTime());
        return zt;
    }

    protected Timestamp getTempTimestamp(long value) {
        if (this.tempTimestamp == null) {
            this.tempTimestamp = new Timestamp(value);
        } else {
            this.tempTimestamp.setTime(value);
        }
        return this.tempTimestamp;
    }
}

