/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ToStringBuilder {
    private static ToStringStyle defaultStyle = ToStringStyle.DEFAULT_STYLE;
    private final StringBuffer buffer;
    private final Object object;
    private final ToStringStyle style;

    public static ToStringStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static String reflectionToString(Object object) {
        return ReflectionToStringBuilder.toString(object);
    }

    public static String reflectionToString(Object object, ToStringStyle style) {
        return ReflectionToStringBuilder.toString(object, style);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, null);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients, Class reflectUpToClass) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, reflectUpToClass);
    }

    public static void setDefaultStyle(ToStringStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        defaultStyle = style;
    }

    public ToStringBuilder(Object object) {
        this(object, ToStringBuilder.getDefaultStyle(), null);
    }

    public ToStringBuilder(Object object, ToStringStyle style) {
        this(object, style, null);
    }

    public ToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer) {
        if (style == null) {
            style = ToStringBuilder.getDefaultStyle();
        }
        if (buffer == null) {
            buffer = new StringBuffer(512);
        }
        this.buffer = buffer;
        this.style = style;
        this.object = object;
        style.appendStart(buffer, object);
    }

    public ToStringBuilder append(boolean value) {
        this.style.append(this.buffer, null, value);
        return this;
    }

    public ToStringBuilder append(boolean[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(byte value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(byte[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(char value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(char[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(double value) {
        this.style.append(this.buffer, null, value);
        return this;
    }

    public ToStringBuilder append(double[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(float value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(float[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(int value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(int[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(long value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(long[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(Object obj) {
        this.style.append(this.buffer, null, obj, null);
        return this;
    }

    public ToStringBuilder append(Object[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(short value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder append(short[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, boolean value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, boolean[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, boolean[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, byte value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, byte[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, byte[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, char value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, char[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, char[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, double value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, double[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, double[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, float value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, float[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, float[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, int value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, int[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, int[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, long value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, long[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, long[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object obj) {
        this.style.append(this.buffer, fieldName2, obj, null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object obj, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, obj, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, Object[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder append(String fieldName2, short value) {
        this.style.append(this.buffer, fieldName2, value);
        return this;
    }

    public ToStringBuilder append(String fieldName2, short[] array) {
        this.style.append(this.buffer, fieldName2, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String fieldName2, short[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName2, array, BooleanUtils.toBooleanObject(fullDetail));
        return this;
    }

    public ToStringBuilder appendAsObjectToString(Object object) {
        ObjectUtils.appendIdentityToString(this.getStringBuffer(), object);
        return this;
    }

    public ToStringBuilder appendSuper(String superToString) {
        if (superToString != null) {
            this.style.appendSuper(this.buffer, superToString);
        }
        return this;
    }

    public ToStringBuilder appendToString(String toString2) {
        if (toString2 != null) {
            this.style.appendToString(this.buffer, toString2);
        }
        return this;
    }

    public Object getObject() {
        return this.object;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public ToStringStyle getStyle() {
        return this.style;
    }

    public String toString() {
        if (this.getObject() == null) {
            this.getStringBuffer().append(this.getStyle().getNullText());
        } else {
            this.style.appendEnd(this.getStringBuffer(), this.getObject());
        }
        return this.getStringBuffer().toString();
    }
}

