/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Access;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.Mod;
import org.codehaus.janino.util.ClassFile;

public class ClassFileIClass
extends IClass {
    private static final boolean DEBUG = false;
    private final ClassFile classFile;
    private final IClassLoader iClassLoader;
    private final short accessFlags;
    private final Map<ClassFile.FieldInfo, IClass.IField> resolvedFields = new HashMap<ClassFile.FieldInfo, IClass.IField>();
    private final Map<String, IClass> resolvedClasses = new HashMap<String, IClass>();
    private final Map<ClassFile.MethodInfo, IClass.IInvocable> resolvedMethods = new HashMap<ClassFile.MethodInfo, IClass.IInvocable>();

    public ClassFileIClass(ClassFile classFile, IClassLoader iClassLoader) {
        this.classFile = classFile;
        this.iClassLoader = iClassLoader;
        this.accessFlags = classFile.accessFlags;
    }

    @Override
    protected IClass.IConstructor[] getDeclaredIConstructors2() {
        ArrayList<IClass.IInvocable> iConstructors = new ArrayList<IClass.IInvocable>();
        for (ClassFile.MethodInfo mi : this.classFile.methodInfos) {
            IClass.IInvocable ii;
            try {
                ii = this.resolveMethod(mi);
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException(ex.getMessage(), ex);
            }
            if (!(ii instanceof IClass.IConstructor)) continue;
            iConstructors.add(ii);
        }
        return iConstructors.toArray(new IClass.IConstructor[iConstructors.size()]);
    }

    @Override
    protected IClass.IMethod[] getDeclaredIMethods2() {
        ArrayList<IClass.IMethod> iMethods = new ArrayList<IClass.IMethod>();
        for (ClassFile.MethodInfo mi : this.classFile.methodInfos) {
            IClass.IInvocable ii;
            if (Mod.isSynthetic(mi.getModifierFlags())) continue;
            try {
                ii = this.resolveMethod(mi);
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException(ex.getMessage(), ex);
            }
            if (!(ii instanceof IClass.IMethod)) continue;
            iMethods.add((IClass.IMethod)ii);
        }
        return iMethods.toArray(new IClass.IMethod[iMethods.size()]);
    }

    @Override
    protected IClass.IField[] getDeclaredIFields2() {
        IClass.IField[] ifs = new IClass.IField[this.classFile.fieldInfos.size()];
        for (int i = 0; i < this.classFile.fieldInfos.size(); ++i) {
            try {
                ifs[i] = this.resolveField(this.classFile.fieldInfos.get(i));
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new JaninoRuntimeException(ex.getMessage(), ex);
            }
        }
        return ifs;
    }

    @Override
    protected IClass[] getDeclaredIClasses2() throws CompileException {
        ClassFile.InnerClassesAttribute ica = this.classFile.getInnerClassesAttribute();
        if (ica == null) {
            return new IClass[0];
        }
        ArrayList<IClass> res = new ArrayList<IClass>();
        for (ClassFile.InnerClassesAttribute.Entry e : ica.getEntries()) {
            if (e.outerClassInfoIndex != this.classFile.thisClass) continue;
            try {
                res.add(this.resolveClass(e.innerClassInfoIndex));
            }
            catch (ClassNotFoundException ex) {
                throw new CompileException(ex.getMessage(), null);
            }
        }
        return res.toArray(new IClass[res.size()]);
    }

    @Override
    protected IClass getDeclaringIClass2() throws CompileException {
        ClassFile.InnerClassesAttribute ica = this.classFile.getInnerClassesAttribute();
        if (ica == null) {
            return null;
        }
        for (ClassFile.InnerClassesAttribute.Entry e : ica.getEntries()) {
            if (e.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (e.outerClassInfoIndex == 0) {
                return null;
            }
            try {
                return this.resolveClass(e.outerClassInfoIndex);
            }
            catch (ClassNotFoundException ex) {
                throw new CompileException(ex.getMessage(), null);
            }
        }
        return null;
    }

    @Override
    protected IClass getOuterIClass2() throws CompileException {
        ClassFile.InnerClassesAttribute ica = this.classFile.getInnerClassesAttribute();
        if (ica == null) {
            return null;
        }
        for (ClassFile.InnerClassesAttribute.Entry e : ica.getEntries()) {
            if (e.innerClassInfoIndex != this.classFile.thisClass) continue;
            if (e.outerClassInfoIndex == 0) {
                return null;
            }
            if (Mod.isStatic(e.innerClassAccessFlags)) {
                return null;
            }
            try {
                return this.resolveClass(e.outerClassInfoIndex);
            }
            catch (ClassNotFoundException ex) {
                throw new CompileException(ex.getMessage(), null);
            }
        }
        return null;
    }

    @Override
    protected IClass getSuperclass2() throws CompileException {
        if (this.classFile.superclass == 0) {
            return null;
        }
        try {
            return this.resolveClass(this.classFile.superclass);
        }
        catch (ClassNotFoundException e) {
            throw new CompileException(e.getMessage(), null);
        }
    }

    @Override
    public Access getAccess() {
        return ClassFileIClass.accessFlags2Access(this.accessFlags);
    }

    @Override
    public boolean isFinal() {
        return Mod.isFinal(this.accessFlags);
    }

    @Override
    protected IClass[] getInterfaces2() throws CompileException {
        return this.resolveClasses(this.classFile.interfaces);
    }

    @Override
    public boolean isAbstract() {
        return Mod.isAbstract(this.accessFlags);
    }

    @Override
    protected String getDescriptor2() {
        return Descriptor.fromClassName(this.classFile.getThisClassName());
    }

    @Override
    public boolean isInterface() {
        return Mod.isInterface(this.accessFlags);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isPrimitiveNumeric() {
        return false;
    }

    @Override
    protected IClass getComponentType2() {
        return null;
    }

    public void resolveAllClasses() throws ClassNotFoundException {
        for (short i = 0; i < this.classFile.getConstantPoolSize(); i = (short)(i + 1)) {
            ClassFile.ConstantPoolInfo cpi = this.classFile.getConstantPoolInfo(i);
            if (cpi instanceof ClassFile.ConstantClassInfo) {
                this.resolveClass(i);
                continue;
            }
            if (!(cpi instanceof ClassFile.ConstantNameAndTypeInfo)) continue;
            String descriptor = ((ClassFile.ConstantNameAndTypeInfo)cpi).getDescriptor(this.classFile);
            if (descriptor.charAt(0) == '(') {
                MethodDescriptor md = new MethodDescriptor(descriptor);
                this.resolveClass(md.returnFd);
                for (String parameterFd : md.parameterFds) {
                    this.resolveClass(parameterFd);
                }
                continue;
            }
            this.resolveClass(descriptor);
        }
    }

    private IClass resolveClass(short index) throws ClassNotFoundException {
        ClassFile.ConstantClassInfo cci = (ClassFile.ConstantClassInfo)this.classFile.getConstantPoolInfo(index);
        return this.resolveClass(Descriptor.fromInternalForm(cci.getName(this.classFile)));
    }

    private IClass resolveClass(String descriptor) throws ClassNotFoundException {
        IClass result2 = this.resolvedClasses.get(descriptor);
        if (result2 != null) {
            return result2;
        }
        result2 = this.iClassLoader.loadIClass(descriptor);
        if (result2 == null) {
            throw new ClassNotFoundException(descriptor);
        }
        this.resolvedClasses.put(descriptor, result2);
        return result2;
    }

    private IClass[] resolveClasses(short[] ifs) throws CompileException {
        IClass[] result2 = new IClass[ifs.length];
        for (int i = 0; i < result2.length; ++i) {
            try {
                result2[i] = this.resolveClass(ifs[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new CompileException(e.getMessage(), null);
            }
        }
        return result2;
    }

    private IClass.IInvocable resolveMethod(final ClassFile.MethodInfo methodInfo) throws ClassNotFoundException {
        ClassFile.AttributeInfo[] ais;
        IClass.IInvocable result2 = this.resolvedMethods.get(methodInfo);
        if (result2 != null) {
            return result2;
        }
        final String name = methodInfo.getName();
        MethodDescriptor md = new MethodDescriptor(methodInfo.getDescriptor());
        final IClass returnType = this.resolveClass(md.returnFd);
        final IClass[] parameterTypes = new IClass[md.parameterFds.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.resolveClass(md.parameterFds[i]);
        }
        IClass[] tes = null;
        for (ClassFile.AttributeInfo ai : ais = methodInfo.getAttributes()) {
            if (!(ai instanceof ClassFile.ExceptionsAttribute)) continue;
            ClassFile.ConstantClassInfo[] ccis = ((ClassFile.ExceptionsAttribute)ai).getExceptions(this.classFile);
            tes = new IClass[ccis.length];
            for (int i = 0; i < tes.length; ++i) {
                tes[i] = this.resolveClass(Descriptor.fromInternalForm(ccis[i].getName(this.classFile)));
            }
        }
        final IClass[] thrownExceptions = tes == null ? new IClass[]{} : tes;
        final Access access = ClassFileIClass.accessFlags2Access(methodInfo.getModifierFlags());
        result2 = "<init>".equals(name) ? new IClass.IConstructor(){

            @Override
            public boolean isVarargs() {
                return Mod.isVarargs(methodInfo.getModifierFlags());
            }

            @Override
            public IClass[] getParameterTypes2() throws CompileException {
                IClass outerIClass = ClassFileIClass.this.getOuterIClass();
                if (outerIClass != null) {
                    if (parameterTypes.length < 1) {
                        throw new JaninoRuntimeException("Inner class constructor lacks magic first parameter");
                    }
                    if (parameterTypes[0] != outerIClass) {
                        throw new JaninoRuntimeException("Magic first parameter of inner class constructor has type \"" + parameterTypes[0].toString() + "\" instead of that of its enclosing instance (\"" + outerIClass.toString() + "\")");
                    }
                    IClass[] tmp = new IClass[parameterTypes.length - 1];
                    System.arraycopy(parameterTypes, 1, tmp, 0, tmp.length);
                    return tmp;
                }
                return parameterTypes;
            }

            @Override
            public IClass[] getThrownExceptions2() {
                return thrownExceptions;
            }

            @Override
            public Access getAccess() {
                return access;
            }

            @Override
            public Java.Annotation[] getAnnotations() {
                return methodInfo.getAnnotations();
            }
        } : new IClass.IMethod(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public IClass getReturnType() {
                return returnType;
            }

            @Override
            public boolean isStatic() {
                return Mod.isStatic(methodInfo.getModifierFlags());
            }

            @Override
            public boolean isAbstract() {
                return Mod.isAbstract(methodInfo.getModifierFlags());
            }

            @Override
            public boolean isVarargs() {
                return Mod.isVarargs(methodInfo.getModifierFlags());
            }

            @Override
            public IClass[] getParameterTypes2() {
                return parameterTypes;
            }

            @Override
            public IClass[] getThrownExceptions2() {
                return thrownExceptions;
            }

            @Override
            public Access getAccess() {
                return access;
            }

            @Override
            public Java.Annotation[] getAnnotations() {
                return methodInfo.getAnnotations();
            }
        };
        this.resolvedMethods.put(methodInfo, result2);
        return result2;
    }

    private IClass.IField resolveField(final ClassFile.FieldInfo fieldInfo) throws ClassNotFoundException {
        IClass.IField result2 = this.resolvedFields.get(fieldInfo);
        if (result2 != null) {
            return result2;
        }
        final String name = fieldInfo.getName(this.classFile);
        String descriptor = fieldInfo.getDescriptor(this.classFile);
        final IClass type = this.resolveClass(descriptor);
        ClassFile.ConstantValueAttribute cva = null;
        for (ClassFile.AttributeInfo ai : fieldInfo.getAttributes()) {
            if (!(ai instanceof ClassFile.ConstantValueAttribute)) continue;
            cva = (ClassFile.ConstantValueAttribute)ai;
            break;
        }
        final Object optionalConstantValue = cva == null ? IClass.NOT_CONSTANT : cva.getConstantValue(this.classFile);
        final Access access = ClassFileIClass.accessFlags2Access(fieldInfo.getModifierFlags());
        result2 = new IClass.IField(){

            @Override
            public Object getConstantValue() {
                return optionalConstantValue;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public IClass getType() {
                return type;
            }

            @Override
            public boolean isStatic() {
                return Mod.isStatic(fieldInfo.getModifierFlags());
            }

            @Override
            public Access getAccess() {
                return access;
            }

            @Override
            public Java.Annotation[] getAnnotations() {
                return fieldInfo.getAnnotations();
            }
        };
        this.resolvedFields.put(fieldInfo, result2);
        return result2;
    }

    private static Access accessFlags2Access(short accessFlags) {
        return Mod.isPublicAccess(accessFlags) ? Access.PUBLIC : (Mod.isProtectedAccess(accessFlags) ? Access.PROTECTED : (Mod.isPrivateAccess(accessFlags) ? Access.PRIVATE : Access.DEFAULT));
    }
}

