/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.iterator;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.util.Producer;
import org.codehaus.janino.util.iterator.MultiDimensionalIterator;
import org.codehaus.janino.util.iterator.ProducerIterator;

public class DirectoryIterator
extends ProducerIterator<File> {
    public DirectoryIterator(final File rootDirectory, final FilenameFilter directoryNameFilter, final FilenameFilter fileNameFilter) {
        super(new Producer(){
            private final List<State> stateStack;
            {
                this.stateStack = DirectoryIterator.newArrayList(new State(rootDirectory));
            }

            public Object produce() {
                while (!this.stateStack.isEmpty()) {
                    State state = this.stateStack.get(this.stateStack.size() - 1);
                    if (state.directories.hasNext()) {
                        this.stateStack.add(new State(state.directories.next()));
                        continue;
                    }
                    if (state.files.hasNext()) {
                        File file = state.files.next();
                        return file;
                    }
                    this.stateStack.remove(this.stateStack.size() - 1);
                }
                return null;
            }

            class State {
                final Iterator<File> directories;
                final Iterator<File> files;

                State(File dir) {
                    File[] entries = dir.listFiles();
                    if (entries == null) {
                        throw new JaninoRuntimeException("Directory \"" + dir + "\" could not be read");
                    }
                    ArrayList<File> directoryList = new ArrayList<File>();
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (File entry2 : entries) {
                        if (entry2.isDirectory()) {
                            if (!directoryNameFilter.accept(dir, entry2.getName())) continue;
                            directoryList.add(entry2);
                            continue;
                        }
                        if (!entry2.isFile() || !fileNameFilter.accept(dir, entry2.getName())) continue;
                        fileList.add(entry2);
                    }
                    this.directories = directoryList.iterator();
                    this.files = fileList.iterator();
                }
            }
        });
    }

    public static Iterator<File> traverseDirectories(File[] rootDirectories, FilenameFilter directoryNameFilter, FilenameFilter fileNameFilter) {
        ArrayList<DirectoryIterator> result2 = new ArrayList<DirectoryIterator>();
        for (File rootDirectory : rootDirectories) {
            result2.add(new DirectoryIterator(rootDirectory, directoryNameFilter, fileNameFilter));
        }
        return new MultiDimensionalIterator(result2.iterator(), 2);
    }

    private static ArrayList newArrayList(Object initialElement) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add(initialElement);
        return result2;
    }
}

