/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.algorithm.impl;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.StatisticsProvider;
import org.pentaho.aggdes.util.BitSetPlus;

public class AggregateImpl
implements Aggregate {
    private final Schema schema;
    final BitSetPlus bits;
    double rowCount;
    boolean materialized;
    double cost;
    double queryLoad;

    public AggregateImpl(Schema schema, BitSetPlus bits) {
        this.schema = schema;
        this.bits = bits;
        StatisticsProvider provider = schema.getStatisticsProvider();
        this.rowCount = provider.getRowCount(this.getAttributes());
        assert (this.rowCount <= provider.getFactRowCount()) : this.getAttributes();
        if (this.rowCount <= 0.0) {
            provider.getRowCount(this.getAttributes());
            throw new AssertionError(this.getAttributes());
        }
    }

    public String toString() {
        return this.getAttributes().toString();
    }

    @Override
    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributes2 = new ArrayList<Attribute>();
        int i = this.bits.nextSetBit(0);
        while (i >= 0) {
            attributes2.add(this.schema.getAttributes().get(i));
            i = this.bits.nextSetBit(i + 1);
        }
        return attributes2;
    }

    @Override
    public List<Measure> getMeasures() {
        return this.schema.getMeasures();
    }

    @Override
    public double estimateRowCount() {
        return this.rowCount;
    }

    @Override
    public double estimateSpace() {
        return this.estimateRowCount() * this.schema.getStatisticsProvider().getSpace(this.getAttributes());
    }

    @Override
    public String getDescription() {
        StringBuilder buf = new StringBuilder("{");
        int i = 0;
        for (Attribute attribute2 : this.getAttributes()) {
            if (i++ > 0) {
                buf.append(", ");
            }
            buf.append(attribute2.getLabel());
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public String getCandidateTableName() {
        StringBuilder buf = new StringBuilder("agg ");
        for (Attribute attribute2 : this.getAttributes()) {
            buf.append(attribute2.getCandidateColumnName().charAt(0));
        }
        for (Attribute attribute3 : this.getMeasures()) {
            buf.append(attribute3.getCandidateColumnName().charAt(0));
        }
        return buf.toString();
    }

    public boolean hasCompleteAncestors(List<BitSetPlus> ancestorClosure) {
        int i = this.bits.nextSetBit(0);
        while (i >= 0) {
            BitSetPlus ancestorBitMap = ancestorClosure.get(i);
            if (!this.bits.contains(ancestorBitMap)) {
                return false;
            }
            i = this.bits.nextSetBit(i + 1);
        }
        return true;
    }
}

