/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.config;

import com.datamountaineer.streamreactor.connect.config.SSLConfig;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SSLConfigContext$ {
    public static SSLConfigContext$ MODULE$;

    static {
        new SSLConfigContext$();
    }

    public SSLContext apply(SSLConfig config) {
        return this.getSSLContext(config);
    }

    public SSLContext getSSLContext(SSLConfig config) {
        KeyManager[] keyManagerArray;
        boolean useClientCertAuth = config.useClientCert();
        boolean bl = useClientCertAuth;
        if (bl) {
            keyManagerArray = this.getKeyManagers(config);
        } else if (!bl) {
            keyManagerArray = (KeyManager[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(KeyManager.class));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        KeyManager[] keyManagers = keyManagerArray;
        SSLContext ctx = SSLContext.getInstance("SSL");
        TrustManager[] trustManagers = this.getTrustManagers(config);
        ctx.init(keyManagers, trustManagers, new SecureRandom());
        return ctx;
    }

    public TrustManager[] getTrustManagers(SSLConfig config) {
        FileInputStream tsf = new FileInputStream(config.trustStorePath());
        KeyStore ts = KeyStore.getInstance(config.trustStoreType());
        ts.load(tsf, config.trustStorePass().toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        return tmf.getTrustManagers();
    }

    public KeyManager[] getKeyManagers(SSLConfig config) {
        Predef$.MODULE$.require(config.keyStorePath().nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Key store path is not set!");
        Predef$.MODULE$.require(config.keyStorePass().nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Key store password is not set!");
        FileInputStream ksf = new FileInputStream((String)config.keyStorePath().get());
        KeyStore ks = KeyStore.getInstance(config.keyStoreType());
        ks.load(ksf, ((String)config.keyStorePass().get()).toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, ((String)config.keyStorePass().get()).toCharArray());
        return kmf.getKeyManagers();
    }

    private SSLConfigContext$() {
        MODULE$ = this;
    }
}

