/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.converters.source;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.json4s.JsonAST;
import org.json4s.JsonAST$JNothing$;
import org.json4s.JsonAST$JNull$;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;

public final class JsonOptNullConverter$ {
    public static JsonOptNullConverter$ MODULE$;

    static {
        new JsonOptNullConverter$();
    }

    public SchemaAndValue convert(String name, String str) {
        return this.convert(name, JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(str), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public SchemaAndValue convert(String name, JsonAST.JValue value) {
        SchemaAndValue schemaAndValue;
        JsonAST.JValue jValue = value;
        if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            List<JsonAST.JValue> arr = jArray.arr();
            ArrayList<Object> values = new ArrayList<Object>();
            SchemaAndValue sv = this.convert(name, (JsonAST.JValue)arr.head());
            values.add(sv.value());
            ((List)arr.tail()).foreach((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)values.add(JsonOptNullConverter$.MODULE$.convert(name, v).value())));
            Schema schema = SchemaBuilder.array((Schema)sv.schema()).optional().build();
            schemaAndValue = new SchemaAndValue(schema, values);
        } else if (jValue instanceof JsonAST.JBool) {
            JsonAST.JBool jBool = (JsonAST.JBool)jValue;
            boolean b = jBool.value();
            schemaAndValue = new SchemaAndValue(Schema.BOOLEAN_SCHEMA, (Object)BoxesRunTime.boxToBoolean((boolean)b));
        } else if (jValue instanceof JsonAST.JDecimal) {
            JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
            scala.math.BigDecimal d = jDecimal.num();
            Schema schema = Decimal.builder((int)d.scale()).optional().build();
            schemaAndValue = new SchemaAndValue(schema, (Object)Decimal.fromLogical((Schema)schema, (BigDecimal)d.bigDecimal()));
        } else if (jValue instanceof JsonAST.JDouble) {
            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
            double d = jDouble.num();
            schemaAndValue = new SchemaAndValue(Schema.FLOAT64_SCHEMA, (Object)BoxesRunTime.boxToDouble((double)d));
        } else if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            BigInt i = jInt.num();
            schemaAndValue = new SchemaAndValue(Schema.INT64_SCHEMA, (Object)BoxesRunTime.boxToLong((long)i.toLong()));
        } else if (jValue instanceof JsonAST.JLong) {
            JsonAST.JLong jLong = (JsonAST.JLong)jValue;
            long l = jLong.num();
            schemaAndValue = new SchemaAndValue(Schema.INT64_SCHEMA, (Object)BoxesRunTime.boxToLong((long)l));
        } else {
            boolean bl;
            JsonAST$JNull$ jsonAST$JNull$ = package$.MODULE$.JNull();
            JsonAST.JValue jValue2 = jValue;
            if (!(jsonAST$JNull$ != null ? !jsonAST$JNull$.equals(jValue2) : jValue2 != null)) {
                bl = true;
            } else {
                JsonAST$JNothing$ jsonAST$JNothing$ = package$.MODULE$.JNothing();
                JsonAST.JValue jValue3 = jValue;
                bl = !(jsonAST$JNothing$ != null ? !jsonAST$JNothing$.equals(jValue3) : jValue3 != null);
            }
            if (bl) {
                schemaAndValue = new SchemaAndValue(Schema.OPTIONAL_STRING_SCHEMA, null);
            } else if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                schemaAndValue = new SchemaAndValue(Schema.STRING_SCHEMA, (Object)s);
            } else if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List<Tuple2<String, JsonAST.JValue>> values = jObject.obj();
                SchemaBuilder builder = SchemaBuilder.struct().name(name.replace("/", "_"));
                Map fields = ((TraversableOnce)values.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String n = (String)tuple2._1();
                    JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                    SchemaAndValue schemaAndValue = MODULE$.convert(n, v);
                    builder.field(n, schemaAndValue.schema());
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), schemaAndValue.value());
                    return tuple22;
                }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Schema schema = builder.build();
                Struct struct = new Struct(schema);
                fields.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String field = (String)tuple2._1();
                    Object v = tuple2._2();
                    Struct struct = struct.put(field, v);
                    return struct;
                });
                schemaAndValue = new SchemaAndValue(schema, (Object)struct);
            } else {
                throw new MatchError((Object)jValue);
            }
        }
        return schemaAndValue;
    }

    private JsonOptNullConverter$() {
        MODULE$ = this;
    }
}

