/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.converters.source;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer$;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class KeyExtractor$ {
    public static KeyExtractor$ MODULE$;

    static {
        new KeyExtractor$();
    }

    public Object extract(JsonNode node, Vector<String> path) {
        if (node == null) {
            throw new NullPointerException("Invalid parameter 'node'");
        }
        return this.innerExtract$1(node, path, path);
    }

    public Object extract(Struct struct, Vector<String> path) {
        Field field = (Field)Option$.MODULE$.apply((Object)struct.schema().field((String)path.head())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(37).append("Couldn't find field '").append(path.head()).append("' in the schema:").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(struct.schema().fields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).toString());
        });
        return KeyExtractor$.innerExtract$2(field, struct.get(field), path.tail(), path);
    }

    private static final void checkValidPath$1(Vector p$1, Vector path$1) {
        if (p$1.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Invalid field selection for '").append(path$1.mkString(".")).append("'. It doesn't resolve to a primitive field").toString());
        }
    }

    private final Object innerExtract$1(JsonNode n, Vector p, Vector path$1) {
        Object object;
        block16: {
            JsonNode jsonNode;
            while (true) {
                if ((jsonNode = n) == null) {
                    object = null;
                    break block16;
                }
                if (jsonNode instanceof BinaryNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = n.binaryValue();
                    break block16;
                }
                if (jsonNode instanceof BooleanNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = BoxesRunTime.boxToBoolean((boolean)n.booleanValue());
                    break block16;
                }
                if (jsonNode instanceof BigIntegerNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = n.bigIntegerValue();
                    break block16;
                }
                if (jsonNode instanceof DecimalNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = n.decimalValue();
                    break block16;
                }
                if (jsonNode instanceof DoubleNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = BoxesRunTime.boxToDouble((double)n.doubleValue());
                    break block16;
                }
                if (jsonNode instanceof FloatNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = BoxesRunTime.boxToFloat((float)n.floatValue());
                    break block16;
                }
                if (jsonNode instanceof IntNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = BoxesRunTime.boxToInteger((int)n.intValue());
                    break block16;
                }
                if (jsonNode instanceof LongNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = BoxesRunTime.boxToLong((long)n.longValue());
                    break block16;
                }
                if (jsonNode instanceof ShortNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = BoxesRunTime.boxToShort((short)n.shortValue());
                    break block16;
                }
                if (jsonNode instanceof TextNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = n.textValue();
                    break block16;
                }
                if (jsonNode instanceof NullNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = null;
                    break block16;
                }
                if (jsonNode instanceof MissingNode) {
                    KeyExtractor$.checkValidPath$1(p, path$1);
                    object = null;
                    break block16;
                }
                if (!(jsonNode instanceof ObjectNode)) break;
                ObjectNode objectNode = (ObjectNode)jsonNode;
                if (p.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Invalid field selection for '").append(path$1.mkString(".")).append("'. The path is not resolving to a primitive field").toString());
                }
                JsonNode childNode = (JsonNode)Option$.MODULE$.apply((Object)objectNode.get((String)p.head())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(67).append("Invalid field selection for '").append(path$1.mkString(".")).append("'. Can't find ").append(p.head()).append(" field. Field found are:").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(objectNode.fieldNames()).asScala()).mkString(",")).toString());
                });
                p = p.tail();
                n = childNode;
            }
            if (jsonNode instanceof ArrayNode) {
                throw new IllegalArgumentException(new StringBuilder(72).append("Invalid field selection for '").append(path$1.mkString(".")).append("'. The path is involving an array structure").toString());
            }
            throw new IllegalArgumentException(new StringBuilder(47).append("Invalid field selection for '").append(path$1.mkString(".")).append("'. ").append(jsonNode).append(" is not handled").toString());
        }
        return object;
    }

    public static final void com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(Vector p$2, Vector path$2) {
        if (p$2.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Invalid field selection for '").append(path$2.mkString(".")).append("'. It doesn't resolve to a primitive field").toString());
        }
    }

    private static final Object innerExtract$2(Field field, Object value, Vector p, Vector path$2) {
        if (value == null) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Invalid field selection for '").append(path$2.mkString(".")).append("'. Field '").append(field.name()).append("' is null").toString());
        }
        return Option$.MODULE$.apply((Object)field.schema().name()).collect((PartialFunction)new scala.Serializable(value, field, p, path$2){
            public static final long serialVersionUID = 0L;
            private final Object value$1;
            private final Field field$1;
            private final Vector p$2;
            private final Vector path$2;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if ("org.apache.kafka.connect.data.Decimal".equals(A1)) {
                    Object object2;
                    Object object3 = this.value$1;
                    if (object3 instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)object3;
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        object2 = bigDecimal;
                    } else if (object3 instanceof byte[]) {
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        object2 = Decimal.toLogical((Schema)this.field$1.schema(), (byte[])((byte[])this.value$1));
                    } else {
                        throw new MatchError(object3);
                    }
                    object = object2;
                } else if ("org.apache.kafka.connect.data.Date".equals(A1)) {
                    java.util.Date date;
                    Object object4 = this.value$1;
                    if (object4 instanceof java.util.Date) {
                        java.util.Date date2 = (java.util.Date)object4;
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        date = date2;
                    } else if (object4 instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)object4);
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        date = Date.toLogical((Schema)this.field$1.schema(), (int)n);
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(34).append("Can't convert ").append(this.value$1).append(" to Date for schema:").append(this.field$1.schema().type()).toString());
                    }
                    object = date;
                } else if ("org.apache.kafka.connect.data.Time".equals(A1)) {
                    java.util.Date date;
                    Object object5 = this.value$1;
                    if (object5 instanceof Integer) {
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        date = Time.toLogical((Schema)this.field$1.schema(), (int)BoxesRunTime.unboxToInt((Object)this.value$1));
                    } else if (object5 instanceof java.util.Date) {
                        java.util.Date date3 = (java.util.Date)object5;
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        date = date3;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(34).append("Can't convert ").append(this.value$1).append(" to Date for schema:").append(this.field$1.schema().type()).toString());
                    }
                    object = date;
                } else if ("org.apache.kafka.connect.data.Timestamp".equals(A1)) {
                    java.util.Date date;
                    Object object6 = this.value$1;
                    if (object6 instanceof Long) {
                        long l = BoxesRunTime.unboxToLong((Object)object6);
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        date = Timestamp.toLogical((Schema)this.field$1.schema(), (long)l);
                    } else if (object6 instanceof java.util.Date) {
                        java.util.Date date4 = (java.util.Date)object6;
                        KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(this.p$2, this.path$2);
                        date = date4;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(34).append("Can't convert ").append(this.value$1).append(" to Date for schema:").append(this.field$1.schema().type()).toString());
                    }
                    object = date;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = "org.apache.kafka.connect.data.Decimal".equals(string) ? true : ("org.apache.kafka.connect.data.Date".equals(string) ? true : ("org.apache.kafka.connect.data.Time".equals(string) ? true : "org.apache.kafka.connect.data.Timestamp".equals(string)));
                return bl;
            }
            {
                this.value$1 = value$1;
                this.field$1 = field$1;
                this.p$2 = p$2;
                this.path$2 = path$2;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Schema.Type type = field.schema().type();
            if (Schema.Type.BOOLEAN.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value));
            } else if (Schema.Type.BYTES.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = (byte[])value;
            } else if (Schema.Type.FLOAT32.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)value));
            } else if (Schema.Type.FLOAT64.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value));
            } else if (Schema.Type.INT8.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)value));
            } else if (Schema.Type.INT16.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)value));
            } else if (Schema.Type.INT32.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value));
            } else if (Schema.Type.INT64.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)value));
            } else if (Schema.Type.STRING.equals(type)) {
                KeyExtractor$.com$datamountaineer$streamreactor$connect$converters$source$KeyExtractor$$checkValidPath$2(p, path$2);
                object = value.toString();
            } else if (Schema.Type.MAP.equals(type)) {
                if (p.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(88).append("Invalid field selection for '").append(path$2.mkString(".")).append("'. It doesn't resolve to a primitive field. It resolves to:").append(field.schema()).toString());
                }
                Map map = (Map)value;
                Field f = new Field((String)p.head(), 0, field.schema().valueSchema());
                object = KeyExtractor$.innerExtract$2(f, map.get(p.head()), p.tail(), path$2);
            } else if (Schema.Type.STRUCT.equals(type)) {
                if (p.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(88).append("Invalid field selection for '").append(path$2.mkString(".")).append("'. It doesn't resolve to a primitive field. It resolves to:").append(field.schema()).toString());
                }
                Struct s = (Struct)value;
                Field childField = (Field)Option$.MODULE$.apply((Object)s.schema().field((String)p.head())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(70).append("Invalid field selection for '").append(path$2.mkString(".")).append("'. Can't find field '").append(p.head()).append("'. Fields available:").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(s.schema().fields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).toString());
                });
                object = KeyExtractor$.innerExtract$2(childField, s.get(childField), p.tail(), path$2);
            } else {
                throw package$.MODULE$.error(new StringBuilder(27).append(type).append(" is not a recognized schema").toString());
            }
            Boolean v = object;
            return v;
        });
    }

    private KeyExtractor$() {
        MODULE$ = this;
    }
}

