/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;

public class SimpleJsonConverter {
    public static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSSZ");
    private static final HashMap<String, LogicalTypeConverter> TO_CONNECT_LOGICAL_CONVERTERS;

    public JsonNode fromConnectData(Schema schema, Object value) {
        return SimpleJsonConverter.convertToJson(schema, value);
    }

    /*
     * Unable to fully structure code
     */
    private static JsonNode convertToJson(Schema schema, Object logicalValue) {
        if (logicalValue == null) {
            if (schema == null) {
                return null;
            }
            if (schema.defaultValue() != null) {
                return SimpleJsonConverter.convertToJson(schema, schema.defaultValue());
            }
            if (schema.isOptional()) {
                return JsonNodeFactory.instance.nullNode();
            }
            throw new DataException("Conversion error: null value for field that is required and has no default value");
        }
        value = logicalValue;
        try {
            if (schema == null) {
                schemaType = ConnectSchema.schemaType(value.getClass());
                if (schemaType == null) {
                    throw new DataException("Java class " + value.getClass() + " does not have corresponding schema type.");
                }
            } else {
                schemaType = schema.type();
            }
            switch (5.$SwitchMap$org$apache$kafka$connect$data$Schema$Type[schemaType.ordinal()]) {
                case 1: {
                    return JsonNodeFactory.instance.numberNode((Byte)value);
                }
                case 2: {
                    return JsonNodeFactory.instance.numberNode((Short)value);
                }
                case 3: {
                    if (schema != null && "org.apache.kafka.connect.data.Date".equals(schema.name())) {
                        return JsonNodeFactory.instance.textNode(SimpleJsonConverter.ISO_DATE_FORMAT.format((Date)value));
                    }
                    if (schema != null && "org.apache.kafka.connect.data.Time".equals(schema.name())) {
                        return JsonNodeFactory.instance.textNode(SimpleJsonConverter.TIME_FORMAT.format((Date)value));
                    }
                    return JsonNodeFactory.instance.numberNode((Integer)value);
                }
                case 4: {
                    schemaName = schema.name();
                    if ("org.apache.kafka.connect.data.Timestamp".equals(schemaName)) {
                        return JsonNodeFactory.instance.numberNode(Timestamp.fromLogical((Schema)schema, (Date)((Date)value)));
                    }
                    return JsonNodeFactory.instance.numberNode((Long)value);
                }
                case 5: {
                    return JsonNodeFactory.instance.numberNode((Float)value);
                }
                case 6: {
                    return JsonNodeFactory.instance.numberNode((Double)value);
                }
                case 7: {
                    return JsonNodeFactory.instance.booleanNode((Boolean)value);
                }
                case 8: {
                    charSeq = (CharSequence)value;
                    return JsonNodeFactory.instance.textNode(charSeq.toString());
                }
                case 9: {
                    if ("org.apache.kafka.connect.data.Decimal".equals(schema.name())) {
                        return JsonNodeFactory.instance.numberNode((BigDecimal)value);
                    }
                    valueArr = null;
                    if (value instanceof byte[]) {
                        valueArr = (byte[])value;
                    } else if (value instanceof ByteBuffer) {
                        valueArr = ((ByteBuffer)value).array();
                    }
                    if (valueArr == null) {
                        throw new DataException("Invalid type for bytes type: " + value.getClass());
                    }
                    return JsonNodeFactory.instance.binaryNode(valueArr);
                }
                case 10: {
                    collection = (Collection)value;
                    list = JsonNodeFactory.instance.arrayNode();
                    for (E elem : collection) {
                        valueSchema = schema == null ? null : schema.valueSchema();
                        fieldValue = SimpleJsonConverter.convertToJson(valueSchema, elem);
                        list.add(fieldValue);
                    }
                    return list;
                }
                case 11: {
                    map = (Map)value;
                    if (schema != null) ** GOTO lbl73
                    objectMode = true;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (entry.getKey() instanceof String) continue;
                        objectMode = false;
                        ** GOTO lbl74
                    }
                    ** GOTO lbl74
lbl73:
                    // 1 sources

                    objectMode = schema.keySchema().type() == Schema.Type.STRING;
lbl74:
                    // 3 sources

                    obj = null;
                    list = null;
                    if (objectMode) {
                        obj = JsonNodeFactory.instance.objectNode();
                    } else {
                        list = JsonNodeFactory.instance.arrayNode();
                    }
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        keySchema = schema == null ? null : schema.keySchema();
                        valueSchema = schema == null ? null : schema.valueSchema();
                        mapKey = SimpleJsonConverter.convertToJson(keySchema, entry.getKey());
                        mapValue = SimpleJsonConverter.convertToJson(valueSchema, entry.getValue());
                        if (objectMode) {
                            obj.set(mapKey.asText(), mapValue);
                            continue;
                        }
                        list.add(JsonNodeFactory.instance.arrayNode().add(mapKey).add(mapValue));
                    }
                    return objectMode != false ? obj : list;
                }
                case 12: {
                    struct = (Struct)value;
                    if (struct.schema() != schema) {
                        throw new DataException("Mismatching schema.");
                    }
                    obj = JsonNodeFactory.instance.objectNode();
                    for (Field field : schema.fields()) {
                        obj.set(field.name(), SimpleJsonConverter.convertToJson(field.schema(), struct.get(field)));
                    }
                    return obj;
                }
            }
            throw new DataException("Couldn't convert " + value + " to JSON.");
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        TO_CONNECT_LOGICAL_CONVERTERS = new HashMap();
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof byte[])) {
                    throw new DataException("Invalid type for Decimal, underlying representation should be bytes but was " + value.getClass());
                }
                return Decimal.toLogical((Schema)schema, (byte[])((byte[])value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new DataException("Invalid type for Date, underlying representation should be int32 but was " + value.getClass());
                }
                return org.apache.kafka.connect.data.Date.toLogical((Schema)schema, (int)((Integer)value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new DataException("Invalid type for Time, underlying representation should be int32 but was " + value.getClass());
                }
                return Time.toLogical((Schema)schema, (int)((Integer)value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof Long)) {
                    throw new DataException("Invalid type for Timestamp, underlying representation should be int64 but was " + value.getClass());
                }
                return Timestamp.toLogical((Schema)schema, (long)((Long)value));
            }
        });
    }

    private static interface LogicalTypeConverter {
        public Object convert(Schema var1, Object var2);
    }

    private static interface JsonToConnectTypeConverter {
        public Object convert(Schema var1, JsonNode var2);
    }
}

