/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.rel.core.Filter;

public class FilterNode
extends AbstractSingleNode<Filter> {
    private final Scalar condition;
    private final Context context;

    public FilterNode(Interpreter interpreter, Filter rel) {
        super(interpreter, rel);
        this.condition = interpreter.compile(ImmutableList.of(rel.getCondition()), rel.getRowType());
        this.context = interpreter.createContext();
    }

    @Override
    public void run() throws InterruptedException {
        Row row;
        while ((row = this.source.receive()) != null) {
            this.context.values = row.getValues();
            Boolean b = (Boolean)this.condition.execute(this.context);
            if (b == null || !b.booleanValue()) continue;
            this.sink.send(row);
        }
    }
}

