/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.Graphs;

public class ConventionTraitDef
extends RelTraitDef<Convention> {
    public static final ConventionTraitDef INSTANCE = new ConventionTraitDef();
    private final LoadingCache<RelOptPlanner, ConversionData> conversionCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<RelOptPlanner, ConversionData>(){

        @Override
        public ConversionData load(@Nonnull RelOptPlanner key) {
            return new ConversionData();
        }
    });

    private ConventionTraitDef() {
    }

    @Override
    public Class<Convention> getTraitClass() {
        return Convention.class;
    }

    @Override
    public String getSimpleName() {
        return "convention";
    }

    @Override
    public Convention getDefault() {
        return Convention.NONE;
    }

    @Override
    public void registerConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
        if (converterRule.isGuaranteed()) {
            ConversionData conversionData = this.getConversionData(planner);
            Convention inConvention = (Convention)converterRule.getInTrait();
            Convention outConvention = (Convention)converterRule.getOutTrait();
            conversionData.conversionGraph.addVertex(inConvention);
            conversionData.conversionGraph.addVertex(outConvention);
            conversionData.conversionGraph.addEdge(inConvention, outConvention);
            conversionData.mapArcToConverterRule.put(Pair.of(inConvention, outConvention), converterRule);
        }
    }

    @Override
    public void deregisterConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
        if (converterRule.isGuaranteed()) {
            ConversionData conversionData = this.getConversionData(planner);
            Convention inConvention = (Convention)converterRule.getInTrait();
            Convention outConvention = (Convention)converterRule.getOutTrait();
            boolean removed = conversionData.conversionGraph.removeEdge(inConvention, outConvention);
            assert (removed);
            conversionData.mapArcToConverterRule.remove(Pair.of(inConvention, outConvention), converterRule);
        }
    }

    @Override
    public RelNode convert(RelOptPlanner planner, RelNode rel, Convention toConvention, boolean allowInfiniteCostConverters) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        ConversionData conversionData = this.getConversionData(planner);
        Convention fromConvention = rel.getConvention();
        List<List<Convention>> conversionPaths = conversionData.getPaths(fromConvention, toConvention);
        block0: for (List<Convention> conversionPath : conversionPaths) {
            assert (conversionPath.get(0) == fromConvention);
            assert (conversionPath.get(conversionPath.size() - 1) == toConvention);
            RelNode converted = rel;
            Convention previous = null;
            for (Convention arc : conversionPath) {
                if (planner.getCost(converted, mq).isInfinite() && !allowInfiniteCostConverters) continue block0;
                if (previous != null && (converted = this.changeConvention(converted, previous, arc, conversionData.mapArcToConverterRule)) == null) {
                    throw new AssertionError((Object)("Converter from " + previous + " to " + arc + " guaranteed that it could convert any relexp"));
                }
                previous = arc;
            }
            return converted;
        }
        return null;
    }

    private RelNode changeConvention(RelNode rel, Convention source, Convention target, Multimap<Pair<Convention, Convention>, ConverterRule> mapArcToConverterRule) {
        assert (source == rel.getConvention());
        Pair<Convention, Convention> key = Pair.of(source, target);
        for (ConverterRule rule : mapArcToConverterRule.get(key)) {
            assert (rule.getInTrait() == source);
            assert (rule.getOutTrait() == target);
            RelNode converted = rule.convert(rel);
            if (converted == null) continue;
            return converted;
        }
        return null;
    }

    @Override
    public boolean canConvert(RelOptPlanner planner, Convention fromConvention, Convention toConvention) {
        ConversionData conversionData = this.getConversionData(planner);
        return fromConvention.canConvertConvention(toConvention) || conversionData.getShortestPath(fromConvention, toConvention) != null;
    }

    private ConversionData getConversionData(RelOptPlanner planner) {
        return this.conversionCache.getUnchecked(planner);
    }

    private static final class ConversionData {
        final DirectedGraph<Convention, DefaultEdge> conversionGraph = DefaultDirectedGraph.create();
        final Multimap<Pair<Convention, Convention>, ConverterRule> mapArcToConverterRule = HashMultimap.create();
        private Graphs.FrozenGraph<Convention, DefaultEdge> pathMap;

        private ConversionData() {
        }

        public List<List<Convention>> getPaths(Convention fromConvention, Convention toConvention) {
            return this.getPathMap().getPaths(fromConvention, toConvention);
        }

        private Graphs.FrozenGraph<Convention, DefaultEdge> getPathMap() {
            if (this.pathMap == null) {
                this.pathMap = Graphs.makeImmutable(this.conversionGraph);
            }
            return this.pathMap;
        }

        public List<Convention> getShortestPath(Convention fromConvention, Convention toConvention) {
            return this.getPathMap().getShortestPath(fromConvention, toConvention);
        }
    }
}

