/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;

public class Strong {
    private static final Map<SqlKind, Policy> MAP = Strong.createPolicyMap();

    public static Strong of(final ImmutableBitSet nullColumns) {
        return new Strong(){

            @Override
            public boolean isNull(RexInputRef ref) {
                return nullColumns.get(ref.getIndex());
            }
        };
    }

    public static boolean isNull(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).isNull(node);
    }

    public static boolean isNotTrue(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).isNotTrue(node);
    }

    public static Policy policy(SqlKind kind) {
        return Preconditions.checkNotNull(MAP.get((Object)kind), (Object)kind);
    }

    public boolean isNotTrue(RexNode node) {
        switch (node.getKind()) {
            case IS_NOT_NULL: {
                return this.anyNull(((RexCall)node).getOperands());
            }
        }
        return this.isNull(node);
    }

    public boolean isNull(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                return ((RexLiteral)node).getValue() == null;
            }
            case AND: 
            case NOT: 
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case PLUS_PREFIX: 
            case MINUS_PREFIX: 
            case PLUS: 
            case TIMESTAMP_ADD: 
            case MINUS: 
            case TIMESTAMP_DIFF: 
            case TIMES: 
            case DIVIDE: 
            case CAST: 
            case REINTERPRET: 
            case TRIM: 
            case LTRIM: 
            case RTRIM: 
            case CEIL: 
            case FLOOR: 
            case EXTRACT: 
            case GREATEST: 
            case LEAST: {
                return this.anyNull(((RexCall)node).getOperands());
            }
            case OR: {
                return this.allNull(((RexCall)node).getOperands());
            }
            case INPUT_REF: {
                return this.isNull((RexInputRef)node);
            }
        }
        return false;
    }

    public boolean isNull(RexInputRef ref) {
        return false;
    }

    private boolean allNull(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (this.isNull(operand)) continue;
            return false;
        }
        return true;
    }

    private boolean anyNull(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (!this.isNull(operand)) continue;
            return true;
        }
        return false;
    }

    private static Map<SqlKind, Policy> createPolicyMap() {
        EnumMap<SqlKind, Policy> map = new EnumMap<SqlKind, Policy>(SqlKind.class);
        map.put(SqlKind.INPUT_REF, Policy.AS_IS);
        map.put(SqlKind.LOCAL_REF, Policy.AS_IS);
        map.put(SqlKind.DYNAMIC_PARAM, Policy.AS_IS);
        map.put(SqlKind.OTHER_FUNCTION, Policy.AS_IS);
        map.put(SqlKind.CASE, Policy.AS_IS);
        map.put(SqlKind.DECODE, Policy.AS_IS);
        map.put(SqlKind.NULLIF, Policy.AS_IS);
        map.put(SqlKind.COALESCE, Policy.AS_IS);
        map.put(SqlKind.NVL, Policy.AS_IS);
        map.put(SqlKind.AND, Policy.AS_IS);
        map.put(SqlKind.OR, Policy.AS_IS);
        map.put(SqlKind.LITERAL, Policy.CUSTOM);
        map.put(SqlKind.EXISTS, Policy.NOT_NULL);
        map.put(SqlKind.IS_DISTINCT_FROM, Policy.NOT_NULL);
        map.put(SqlKind.IS_NOT_DISTINCT_FROM, Policy.NOT_NULL);
        map.put(SqlKind.IS_NULL, Policy.NOT_NULL);
        map.put(SqlKind.IS_NOT_NULL, Policy.NOT_NULL);
        map.put(SqlKind.IS_TRUE, Policy.NOT_NULL);
        map.put(SqlKind.IS_NOT_TRUE, Policy.NOT_NULL);
        map.put(SqlKind.IS_FALSE, Policy.NOT_NULL);
        map.put(SqlKind.IS_NOT_FALSE, Policy.NOT_NULL);
        map.put(SqlKind.IS_DISTINCT_FROM, Policy.NOT_NULL);
        map.put(SqlKind.IS_NOT_DISTINCT_FROM, Policy.NOT_NULL);
        map.put(SqlKind.NOT, Policy.ANY);
        map.put(SqlKind.EQUALS, Policy.ANY);
        map.put(SqlKind.NOT_EQUALS, Policy.ANY);
        map.put(SqlKind.LESS_THAN, Policy.ANY);
        map.put(SqlKind.LESS_THAN_OR_EQUAL, Policy.ANY);
        map.put(SqlKind.GREATER_THAN, Policy.ANY);
        map.put(SqlKind.GREATER_THAN_OR_EQUAL, Policy.ANY);
        map.put(SqlKind.LIKE, Policy.ANY);
        map.put(SqlKind.SIMILAR, Policy.ANY);
        map.put(SqlKind.PLUS_PREFIX, Policy.ANY);
        map.put(SqlKind.MINUS_PREFIX, Policy.ANY);
        map.put(SqlKind.PLUS, Policy.ANY);
        map.put(SqlKind.MINUS, Policy.ANY);
        map.put(SqlKind.TIMES, Policy.ANY);
        map.put(SqlKind.DIVIDE, Policy.ANY);
        map.put(SqlKind.CAST, Policy.ANY);
        map.put(SqlKind.REINTERPRET, Policy.ANY);
        map.put(SqlKind.TRIM, Policy.ANY);
        map.put(SqlKind.LTRIM, Policy.ANY);
        map.put(SqlKind.RTRIM, Policy.ANY);
        map.put(SqlKind.CEIL, Policy.ANY);
        map.put(SqlKind.FLOOR, Policy.ANY);
        map.put(SqlKind.EXTRACT, Policy.ANY);
        map.put(SqlKind.GREATEST, Policy.ANY);
        map.put(SqlKind.LEAST, Policy.ANY);
        for (SqlKind k : Iterables.concat(SqlKind.EXPRESSION, SqlKind.AGGREGATE)) {
            if (map.containsKey((Object)k)) continue;
            map.put(k, Policy.AS_IS);
        }
        return map;
    }

    public static enum Policy {
        NOT_NULL,
        CUSTOM,
        ANY,
        AS_IS;

    }
}

