/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;

public abstract class Match
extends SingleRel {
    protected final ImmutableMap<String, RexNode> measures;
    protected final RexNode pattern;
    protected final boolean strictStart;
    protected final boolean strictEnd;
    protected final ImmutableMap<String, RexNode> patternDefinitions;
    protected final Set<RexMRAggCall> aggregateCalls;

    protected Match(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, RelDataType rowType) {
        super(cluster, traitSet, input);
        this.pattern = Preconditions.checkNotNull(pattern);
        Preconditions.checkArgument(patternDefinitions.size() > 0);
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefinitions = ImmutableMap.copyOf(patternDefinitions);
        this.rowType = rowType;
        this.measures = ImmutableMap.of();
        AggregateFinder aggregateFinder = new AggregateFinder();
        for (RexNode rex : this.patternDefinitions.values()) {
            if (!(rex instanceof RexCall)) continue;
            aggregateFinder.go((RexCall)rex);
        }
        this.aggregateCalls = ImmutableSortedSet.copyOf(aggregateFinder.aggregateCalls);
    }

    public Set<RexMRAggCall> getAggregateCalls() {
        return this.aggregateCalls;
    }

    public ImmutableMap<String, RexNode> getMeasures() {
        return this.measures;
    }

    public RexNode getPattern() {
        return this.pattern;
    }

    public boolean isStrictStart() {
        return this.strictStart;
    }

    public boolean isStrictEnd() {
        return this.strictEnd;
    }

    public ImmutableMap<String, RexNode> getPatternDefinitions() {
        return this.patternDefinitions;
    }

    public abstract Match copy(RelNode var1, RexNode var2, boolean var3, boolean var4, Map<String, RexNode> var5, RelDataType var6);

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        if (this.getInputs().equals(inputs) && traitSet == this.getTraitSet()) {
            return this;
        }
        return this.copy(inputs.get(0), this.pattern, this.strictStart, this.strictEnd, this.patternDefinitions, this.rowType);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("fields", this.rowType.getFieldNames());
            pw.item("exprs", ((ImmutableCollection)this.getMeasures().values()).asList());
        } else {
            for (Ord field : Ord.zip(this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "Field#" + field.i;
                }
                pw.item(fieldName, this.getMeasures().get(field.i));
            }
        }
        return pw;
    }

    public static class RexMRAggCall
    extends RexCall
    implements Comparable<RexMRAggCall> {
        public final int ordinal;

        public RexMRAggCall(SqlAggFunction aggFun, RelDataType type, List<RexNode> operands, int ordinal) {
            super(type, aggFun, operands);
            this.ordinal = ordinal;
            this.digest = this.computeDigest();
        }

        public String computeDigest() {
            return super.computeDigest(false);
        }

        @Override
        public int compareTo(RexMRAggCall o) {
            if (o.computeDigest() == null) {
                return 0;
            }
            if (this.computeDigest() == null) {
                return 1;
            }
            return o.computeDigest().compareTo(this.computeDigest());
        }
    }

    private static class PatternVarFinder
    extends RexVisitorImpl {
        final Set<String> patternVars = new HashSet<String>();

        PatternVarFinder() {
            super(true);
        }

        @Override
        public Object visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            this.patternVars.add(fieldRef.getAlpha());
            return null;
        }

        @Override
        public Object visitCall(RexCall call) {
            for (RexNode node : call.getOperands()) {
                node.accept(this);
            }
            return null;
        }

        public Set<String> go(RexNode rex) {
            rex.accept(this);
            return this.patternVars;
        }

        public Set<String> go(List<RexNode> rexNodeList) {
            for (RexNode rex : rexNodeList) {
                rex.accept(this);
            }
            return this.patternVars;
        }
    }

    private static class AggregateFinder
    extends RexVisitorImpl {
        final SortedSet<RexMRAggCall> aggregateCalls = new TreeSet<RexMRAggCall>();

        AggregateFinder() {
            super(true);
        }

        @Override
        public Object visitCall(RexCall call) {
            SqlAggFunction aggFunction = null;
            switch (call.getKind()) {
                case SUM: {
                    aggFunction = new SqlSumAggFunction(call.getType());
                    break;
                }
                case SUM0: {
                    aggFunction = new SqlSumEmptyIsZeroAggFunction();
                    break;
                }
                case MAX: 
                case MIN: {
                    aggFunction = new SqlMinMaxAggFunction(call.getKind());
                    break;
                }
                case COUNT: {
                    aggFunction = new SqlCountAggFunction();
                    break;
                }
                default: {
                    for (RexNode rex : call.getOperands()) {
                        rex.accept(this);
                    }
                }
            }
            if (aggFunction != null) {
                RexMRAggCall aggCall = new RexMRAggCall(aggFunction, call.getType(), call.getOperands(), this.aggregateCalls.size());
                this.aggregateCalls.add(aggCall);
                Set<String> set = new PatternVarFinder().go(call.getOperands());
            }
            return null;
        }

        public void go(RexCall call) {
            call.accept(this);
        }
    }
}

