/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public final class AggregateExpandDistinctAggregatesRule
extends RelOptRule {
    public static final AggregateExpandDistinctAggregatesRule INSTANCE = new AggregateExpandDistinctAggregatesRule(LogicalAggregate.class, true, RelFactories.LOGICAL_BUILDER);
    public static final AggregateExpandDistinctAggregatesRule JOIN = new AggregateExpandDistinctAggregatesRule(LogicalAggregate.class, false, RelFactories.LOGICAL_BUILDER);
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    public final boolean useGroupingSets;

    public AggregateExpandDistinctAggregatesRule(Class<? extends LogicalAggregate> clazz, boolean useGroupingSets, RelBuilderFactory relBuilderFactory) {
        super(AggregateExpandDistinctAggregatesRule.operand(clazz, AggregateExpandDistinctAggregatesRule.any()), relBuilderFactory, null);
        this.useGroupingSets = useGroupingSets;
    }

    @Deprecated
    public AggregateExpandDistinctAggregatesRule(Class<? extends LogicalAggregate> clazz, boolean useGroupingSets, RelFactories.JoinFactory joinFactory) {
        this(clazz, useGroupingSets, RelBuilder.proto(Contexts.of((Object)joinFactory)));
    }

    @Deprecated
    public AggregateExpandDistinctAggregatesRule(Class<? extends LogicalAggregate> clazz, RelFactories.JoinFactory joinFactory) {
        this(clazz, false, RelBuilder.proto(Contexts.of((Object)joinFactory)));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        if (!aggregate.containsDistinctCall()) {
            return;
        }
        int nonDistinctCount = 0;
        int distinctCount = 0;
        int filterCount = 0;
        int unsupportedAggCount = 0;
        LinkedHashSet<Pair<List<Integer>, Integer>> argLists = new LinkedHashSet<Pair<List<Integer>, Integer>>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (aggCall.filterArg >= 0) {
                ++filterCount;
            }
            if (!aggCall.isDistinct()) {
                ++nonDistinctCount;
                if (aggCall.getAggregation() instanceof SqlCountAggFunction || aggCall.getAggregation() instanceof SqlSumAggFunction || aggCall.getAggregation() instanceof SqlMinMaxAggFunction) continue;
                ++unsupportedAggCount;
                continue;
            }
            ++distinctCount;
            argLists.add(Pair.of(aggCall.getArgList(), aggCall.filterArg));
        }
        Preconditions.checkState(argLists.size() > 0, "containsDistinctCall lied");
        if (nonDistinctCount == 0 && argLists.size() == 1) {
            Pair pair = (Pair)Iterables.getOnlyElement(argLists);
            RelBuilder relBuilder = call.builder();
            this.convertMonopole(relBuilder, aggregate, (List)pair.left, (Integer)pair.right);
            call.transformTo(relBuilder.build());
            return;
        }
        if (this.useGroupingSets) {
            this.rewriteUsingGroupingSets(call, aggregate, argLists);
            return;
        }
        if (distinctCount == 1 && filterCount == 0 && unsupportedAggCount == 0 && nonDistinctCount > 0) {
            RelBuilder relBuilder = call.builder();
            this.convertSingletonDistinct(relBuilder, aggregate, argLists);
            call.transformTo(relBuilder.build());
            return;
        }
        List<RelDataTypeField> aggFields = aggregate.getRowType().getFieldList();
        ArrayList<RexInputRef> refs = new ArrayList<RexInputRef>();
        List<String> fieldNames = aggregate.getRowType().getFieldNames();
        ImmutableBitSet groupSet = aggregate.getGroupSet();
        int groupAndIndicatorCount = aggregate.getGroupCount() + aggregate.getIndicatorCount();
        for (int i2 : Util.range(groupAndIndicatorCount)) {
            refs.add(RexInputRef.of(i2, aggFields));
        }
        ArrayList<AggregateCall> newAggCallList = new ArrayList<AggregateCall>();
        int i = -1;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            ++i;
            if (aggCall.isDistinct()) {
                refs.add(null);
                continue;
            }
            refs.add(new RexInputRef(groupAndIndicatorCount + newAggCallList.size(), aggFields.get(groupAndIndicatorCount + i).getType()));
            newAggCallList.add(aggCall);
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(aggregate.getInput());
        int n = 0;
        if (!newAggCallList.isEmpty()) {
            RelBuilder.GroupKey groupKey = relBuilder.groupKey(groupSet, aggregate.indicator, aggregate.getGroupSets());
            relBuilder.aggregate(groupKey, (List<AggregateCall>)newAggCallList);
            ++n;
        }
        for (Pair pair : argLists) {
            this.doRewrite(relBuilder, aggregate, n++, (List)pair.left, (Integer)pair.right, refs);
        }
        relBuilder.project(refs, fieldNames);
        call.transformTo(relBuilder.build());
    }

    /*
     * WARNING - void declaration
     */
    private RelBuilder convertSingletonDistinct(RelBuilder relBuilder, Aggregate aggregate, Set<Pair<List<Integer>, Integer>> argLists) {
        relBuilder.push(aggregate.getInput());
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        TreeSet<Integer> newGroupSet = new TreeSet<Integer>();
        List<RelDataTypeField> childFields = relBuilder.peek().getRowType().getFieldList();
        boolean hasGroupBy = aggregate.getGroupSet().size() > 0;
        Set<Integer> groupSet = aggregate.getGroupSet().asSet();
        newGroupSet.addAll(aggregate.getGroupSet().asList());
        for (Pair<List<Integer>, Integer> argList : argLists) {
            newGroupSet.addAll((Collection)argList.getKey());
        }
        Iterator<Pair<List<Integer>, Integer>> iterator = newGroupSet.iterator();
        while (iterator.hasNext()) {
            int arg = (Integer)((Object)iterator.next());
            sourceOf.put(arg, projects.size());
            projects.add(RexInputRef.of2(arg, childFields));
        }
        List<AggregateCall> aggCalls = aggregate.getAggCallList();
        ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>();
        ArrayList<Integer> fakeArgs = new ArrayList<Integer>();
        HashMap<AggregateCall, Integer> callArgMap = new HashMap<AggregateCall, Integer>();
        for (AggregateCall aggregateCall : aggCalls) {
            if (aggregateCall.isDistinct()) continue;
            for (int arg : aggregateCall.getArgList()) {
                if (groupSet.contains(arg)) continue;
                sourceOf.put(arg, projects.size());
            }
        }
        int fakeArg0 = 0;
        for (AggregateCall aggregateCall : aggCalls) {
            if (aggregateCall.isDistinct() || !aggregateCall.getArgList().isEmpty() && !Util.intersects(groupSet, aggregateCall.getArgList())) continue;
            while (sourceOf.get(fakeArg0) != null) {
                ++fakeArg0;
            }
            fakeArgs.add(fakeArg0);
            ++fakeArg0;
        }
        for (AggregateCall aggregateCall : aggCalls) {
            if (aggregateCall.isDistinct()) continue;
            for (int arg : aggregateCall.getArgList()) {
                if (groupSet.contains(arg)) continue;
                sourceOf.remove(arg);
            }
        }
        boolean bl = false;
        for (AggregateCall aggCall : aggCalls) {
            void var15_22;
            if (aggCall.isDistinct()) continue;
            AggregateCall newCall = AggregateCall.create(aggCall.getAggregation(), false, aggCall.getArgList(), -1, ImmutableBitSet.of(newGroupSet).cardinality(), relBuilder.peek(), null, aggCall.name);
            newAggCalls.add(newCall);
            if (newCall.getArgList().size() == 0) {
                int fakeArg = (Integer)fakeArgs.get((int)var15_22);
                callArgMap.put(newCall, fakeArg);
                sourceOf.put(fakeArg, projects.size());
                projects.add(Pair.of(new RexInputRef(fakeArg, newCall.getType()), newCall.getName()));
                ++var15_22;
                continue;
            }
            for (int arg : newCall.getArgList()) {
                if (groupSet.contains(arg)) {
                    arg = (Integer)fakeArgs.get((int)var15_22++);
                    callArgMap.put(newCall, arg);
                }
                sourceOf.put(arg, projects.size());
                projects.add(Pair.of(new RexInputRef(arg, newCall.getType()), newCall.getName()));
            }
        }
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), false, ImmutableBitSet.of(newGroupSet), null, newAggCalls));
        ArrayList<AggregateCall> arrayList = Lists.newArrayList(aggregate.getAggCallList());
        for (int i = 0; i < arrayList.size(); ++i) {
            AggregateCall newCall;
            AggregateCall aggCall = (AggregateCall)arrayList.get(i);
            int argCount = aggCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j = 0; j < argCount; ++j) {
                Integer arg = aggCall.getArgList().get(j);
                if (callArgMap.containsKey(aggCall)) {
                    newArgs.add((Integer)sourceOf.get(callArgMap.get(aggCall)));
                    continue;
                }
                newArgs.add((Integer)sourceOf.get(arg));
            }
            if (aggCall.isDistinct()) {
                newCall = AggregateCall.create(aggCall.getAggregation(), false, newArgs, -1, aggregate.getGroupSet().cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.name);
            } else if (aggCall.getAggregation() instanceof SqlCountAggFunction) {
                if (aggCall.getArgList().size() == 0) {
                    newArgs.add((Integer)sourceOf.get(callArgMap.get(aggCall)));
                }
                if (hasGroupBy) {
                    SqlSumAggFunction sumAgg = new SqlSumAggFunction(null);
                    newCall = AggregateCall.create(sumAgg, false, newArgs, -1, aggregate.getGroupSet().cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.getName());
                } else {
                    SqlSumEmptyIsZeroAggFunction sumAgg = new SqlSumEmptyIsZeroAggFunction();
                    newCall = AggregateCall.create(sumAgg, false, newArgs, -1, aggregate.getGroupSet().cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.getName());
                }
            } else {
                newCall = AggregateCall.create(aggCall.getAggregation(), false, newArgs, -1, aggregate.getGroupSet().cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.name);
            }
            arrayList.set(i, newCall);
        }
        newGroupSet.clear();
        for (int arg : aggregate.getGroupSet()) {
            newGroupSet.add((Integer)sourceOf.get(arg));
        }
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), aggregate.indicator, ImmutableBitSet.of(newGroupSet), null, arrayList));
        return relBuilder;
    }

    private void rewriteUsingGroupingSets(RelOptRuleCall call, Aggregate aggregate, Set<Pair<List<Integer>, Integer>> argLists) {
        TreeSet<ImmutableBitSet> groupSetTreeSet = new TreeSet<ImmutableBitSet>(ImmutableBitSet.ORDERING);
        groupSetTreeSet.add(aggregate.getGroupSet());
        for (Pair<List<Integer>, Integer> argList : argLists) {
            groupSetTreeSet.add(ImmutableBitSet.of((Iterable)argList.left).setIf((Integer)argList.right, (Integer)argList.right >= 0).union(aggregate.getGroupSet()));
        }
        ImmutableList<ImmutableBitSet> groupSets = ImmutableList.copyOf(groupSetTreeSet);
        final ImmutableBitSet fullGroupSet = ImmutableBitSet.union(groupSets);
        final ArrayList<AggregateCall> distinctAggCalls = new ArrayList<AggregateCall>();
        for (Pair<AggregateCall, String> aggCall : aggregate.getNamedAggCalls()) {
            if (((AggregateCall)aggCall.left).isDistinct()) continue;
            distinctAggCalls.add(((AggregateCall)aggCall.left).rename((String)aggCall.right));
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(aggregate.getInput());
        relBuilder.aggregate(relBuilder.groupKey(fullGroupSet, groupSets.size() > 1, groupSets), (List<AggregateCall>)distinctAggCalls);
        RelNode distinct = relBuilder.peek();
        final int groupCount = fullGroupSet.cardinality();
        final int indicatorCount = groupSets.size() > 1 ? groupCount : 0;
        RelOptCluster cluster = aggregate.getCluster();
        final RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        final RelDataType booleanType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
        final ArrayList predicates = new ArrayList();
        HashMap<ImmutableBitSet, Integer> filters = new HashMap<ImmutableBitSet, Integer>();
        class Registrar {
            RexNode group = null;

            Registrar() {
            }

            private int register(ImmutableBitSet groupSet) {
                if (this.group == null) {
                    this.group = this.makeGroup(groupCount - 1);
                }
                RexNode node = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, this.group, rexBuilder.makeExactLiteral(this.toNumber(AggregateExpandDistinctAggregatesRule.remap(fullGroupSet, groupSet))));
                predicates.add(Pair.of(node, this.toString(groupSet)));
                return groupCount + indicatorCount + distinctAggCalls.size() + predicates.size() - 1;
            }

            private RexNode makeGroup(int i) {
                RexInputRef ref = rexBuilder.makeInputRef(booleanType, groupCount + i);
                RexNode kase = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, ref, rexBuilder.makeExactLiteral(BigDecimal.ZERO), rexBuilder.makeExactLiteral(TWO.pow(i)));
                if (i == 0) {
                    return kase;
                }
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, this.makeGroup(i - 1), kase);
            }

            private BigDecimal toNumber(ImmutableBitSet bitSet) {
                BigDecimal n = BigDecimal.ZERO;
                for (int key : bitSet) {
                    n = n.add(TWO.pow(key));
                }
                return n;
            }

            private String toString(ImmutableBitSet bitSet) {
                StringBuilder buf = new StringBuilder("$i");
                for (int key : bitSet) {
                    buf.append(key).append('_');
                }
                return buf.substring(0, buf.length() - 1);
            }
        }
        Registrar registrar = new Registrar();
        for (ImmutableBitSet immutableBitSet : groupSets) {
            filters.put(immutableBitSet, registrar.register(immutableBitSet));
        }
        if (!predicates.isEmpty()) {
            ArrayList<Pair<RexInputRef, String>> nodes = new ArrayList<Pair<RexInputRef, String>>();
            for (RelDataTypeField f : relBuilder.peek().getRowType().getFieldList()) {
                RexInputRef node = rexBuilder.makeInputRef(f.getType(), f.getIndex());
                nodes.add(Pair.of(node, f.getName()));
            }
            nodes.addAll(predicates);
            relBuilder.project(Pair.left(nodes), Pair.right(nodes));
        }
        int x = groupCount + indicatorCount;
        ArrayList<AggregateCall> arrayList = new ArrayList<AggregateCall>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            int newFilterArg;
            ImmutableIntList newArgList;
            SqlAggFunction aggregation;
            if (!aggCall.isDistinct()) {
                aggregation = SqlStdOperatorTable.MIN;
                newArgList = ImmutableIntList.of(x++);
                newFilterArg = (Integer)filters.get(aggregate.getGroupSet());
            } else {
                aggregation = aggCall.getAggregation();
                newArgList = AggregateExpandDistinctAggregatesRule.remap(fullGroupSet, aggCall.getArgList());
                newFilterArg = (Integer)filters.get(ImmutableBitSet.of(aggCall.getArgList()).setIf(aggCall.filterArg, aggCall.filterArg >= 0).union(aggregate.getGroupSet()));
            }
            AggregateCall newCall = AggregateCall.create(aggregation, false, newArgList, newFilterArg, aggregate.getGroupCount(), distinct, null, aggCall.name);
            arrayList.add(newCall);
        }
        relBuilder.aggregate(relBuilder.groupKey(AggregateExpandDistinctAggregatesRule.remap(fullGroupSet, aggregate.getGroupSet()), aggregate.indicator, AggregateExpandDistinctAggregatesRule.remap(fullGroupSet, aggregate.getGroupSets())), (List<AggregateCall>)arrayList);
        relBuilder.convert(aggregate.getRowType(), true);
        call.transformTo(relBuilder.build());
    }

    private static ImmutableBitSet remap(ImmutableBitSet groupSet, ImmutableBitSet bitSet) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (Integer bit : bitSet) {
            builder.set(AggregateExpandDistinctAggregatesRule.remap(groupSet, bit));
        }
        return builder.build();
    }

    private static ImmutableList<ImmutableBitSet> remap(ImmutableBitSet groupSet, Iterable<ImmutableBitSet> bitSets) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableBitSet bitSet : bitSets) {
            builder.add(AggregateExpandDistinctAggregatesRule.remap(groupSet, bitSet));
        }
        return builder.build();
    }

    private static List<Integer> remap(ImmutableBitSet groupSet, List<Integer> argList) {
        ImmutableIntList list = ImmutableIntList.of();
        for (int arg : argList) {
            list = list.append(AggregateExpandDistinctAggregatesRule.remap(groupSet, arg));
        }
        return list;
    }

    private static int remap(ImmutableBitSet groupSet, int arg) {
        return arg < 0 ? -1 : groupSet.indexOf(arg);
    }

    private RelBuilder convertMonopole(RelBuilder relBuilder, Aggregate aggregate, List<Integer> argList, int filterArg) {
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        this.createSelectDistinct(relBuilder, aggregate, argList, filterArg, sourceOf);
        ArrayList<AggregateCall> newAggCalls = Lists.newArrayList(aggregate.getAggCallList());
        AggregateExpandDistinctAggregatesRule.rewriteAggCalls(newAggCalls, argList, sourceOf);
        int cardinality = aggregate.getGroupSet().cardinality();
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), aggregate.indicator, ImmutableBitSet.range(cardinality), null, newAggCalls));
        return relBuilder;
    }

    private void doRewrite(RelBuilder relBuilder, Aggregate aggregate, int n, List<Integer> argList, int filterArg, List<RexInputRef> refs) {
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        List<RelDataTypeField> leftFields = n == 0 ? null : relBuilder.peek().getRowType().getFieldList();
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        this.createSelectDistinct(relBuilder, aggregate, argList, filterArg, sourceOf);
        ArrayList<AggregateCall> aggCallList = new ArrayList<AggregateCall>();
        List<AggregateCall> aggCalls = aggregate.getAggCallList();
        int groupAndIndicatorCount = aggregate.getGroupCount() + aggregate.getIndicatorCount();
        int i = groupAndIndicatorCount - 1;
        for (AggregateCall aggregateCall : aggCalls) {
            ++i;
            if (!aggregateCall.isDistinct() || !aggregateCall.getArgList().equals(argList)) continue;
            int argCount = aggregateCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j = 0; j < argCount; ++j) {
                Integer arg = aggregateCall.getArgList().get(j);
                newArgs.add((Integer)sourceOf.get(arg));
            }
            int newFilterArg = aggregateCall.filterArg >= 0 ? (Integer)sourceOf.get(aggregateCall.filterArg) : -1;
            AggregateCall newAggCall = AggregateCall.create(aggregateCall.getAggregation(), false, newArgs, newFilterArg, aggregateCall.getType(), aggregateCall.getName());
            assert (refs.get(i) == null);
            if (n == 0) {
                refs.set(i, new RexInputRef(groupAndIndicatorCount + aggCallList.size(), newAggCall.getType()));
            } else {
                refs.set(i, new RexInputRef(leftFields.size() + groupAndIndicatorCount + aggCallList.size(), newAggCall.getType()));
            }
            aggCallList.add(newAggCall);
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Integer key : aggregate.getGroupSet()) {
            map.put(key, map.size());
        }
        ImmutableBitSet immutableBitSet = aggregate.getGroupSet().permute(map);
        assert (immutableBitSet.equals(ImmutableBitSet.range(aggregate.getGroupSet().cardinality())));
        ImmutableList<ImmutableBitSet> newGroupingSets = null;
        if (aggregate.indicator) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), aggregate.indicator, immutableBitSet, newGroupingSets, aggCallList));
        if (n == 0) {
            return;
        }
        List<RelDataTypeField> distinctFields = relBuilder.peek().getRowType().getFieldList();
        ArrayList<RexNode> conditions = Lists.newArrayList();
        for (i = 0; i < groupAndIndicatorCount; ++i) {
            conditions.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, RexInputRef.of(i, leftFields), new RexInputRef(leftFields.size() + i, distinctFields.get(i).getType())));
        }
        relBuilder.join(JoinRelType.INNER, conditions);
    }

    private static void rewriteAggCalls(List<AggregateCall> newAggCalls, List<Integer> argList, Map<Integer, Integer> sourceOf) {
        for (int i = 0; i < newAggCalls.size(); ++i) {
            AggregateCall aggCall = newAggCalls.get(i);
            if (!aggCall.isDistinct() || !aggCall.getArgList().equals(argList)) continue;
            int argCount = aggCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j = 0; j < argCount; ++j) {
                Integer arg = aggCall.getArgList().get(j);
                newArgs.add(sourceOf.get(arg));
            }
            AggregateCall newAggCall = AggregateCall.create(aggCall.getAggregation(), false, newArgs, -1, aggCall.getType(), aggCall.getName());
            newAggCalls.set(i, newAggCall);
        }
    }

    private RelBuilder createSelectDistinct(RelBuilder relBuilder, Aggregate aggregate, List<Integer> argList, int filterArg, Map<Integer, Integer> sourceOf) {
        relBuilder.push(aggregate.getInput());
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> childFields = relBuilder.peek().getRowType().getFieldList();
        for (int i : aggregate.getGroupSet()) {
            sourceOf.put(i, projects.size());
            projects.add(RexInputRef.of2(i, childFields));
        }
        for (Integer arg : argList) {
            if (filterArg >= 0) {
                RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
                RexInputRef filterRef = RexInputRef.of(filterArg, childFields);
                Pair<RexNode, String> argRef = RexInputRef.of2(arg, childFields);
                RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, filterRef, (RexNode)argRef.left, rexBuilder.ensureType(((RexNode)argRef.left).getType(), rexBuilder.makeCast(((RexNode)argRef.left).getType(), rexBuilder.constantNull()), true));
                sourceOf.put(arg, projects.size());
                projects.add(Pair.of(condition, "i$" + (String)argRef.right));
                continue;
            }
            if (sourceOf.get(arg) != null) continue;
            sourceOf.put(arg, projects.size());
            projects.add(RexInputRef.of2(arg, childFields));
        }
        relBuilder.project(Pair.left(projects), Pair.right(projects));
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), false, ImmutableBitSet.range(projects.size()), null, ImmutableList.of()));
        return relBuilder;
    }
}

