/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class RexSimplify {
    public final RexBuilder rexBuilder;
    final boolean unknownAsFalse;
    private final RexExecutor executor;

    public RexSimplify(RexBuilder rexBuilder, boolean unknownAsFalse, RexExecutor executor) {
        this.rexBuilder = Preconditions.checkNotNull(rexBuilder);
        this.unknownAsFalse = unknownAsFalse;
        this.executor = Preconditions.checkNotNull(executor);
    }

    public RexSimplify withUnknownAsFalse(boolean unknownAsFalse) {
        return unknownAsFalse == this.unknownAsFalse ? this : new RexSimplify(this.rexBuilder, unknownAsFalse, this.executor);
    }

    public RexNode simplifyPreservingType(RexNode e) {
        RexNode e2 = this.simplify(e);
        if (e2.getType() == e.getType()) {
            return e2;
        }
        RexNode e3 = this.rexBuilder.makeCast(e.getType(), e2, true);
        if (e3.equals(e)) {
            return e;
        }
        return e3;
    }

    public RexNode simplify(RexNode e) {
        switch (e.getKind()) {
            case AND: {
                return this.simplifyAnd((RexCall)e);
            }
            case OR: {
                return this.simplifyOr((RexCall)e);
            }
            case NOT: {
                return this.simplifyNot((RexCall)e);
            }
            case CASE: {
                return this.simplifyCase((RexCall)e);
            }
            case CAST: {
                return this.simplifyCast((RexCall)e);
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case IS_TRUE: 
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                assert (e instanceof RexCall);
                return this.simplifyIs((RexCall)e);
            }
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case NOT_EQUALS: {
                return this.simplifyComparison((RexCall)e);
            }
        }
        return e;
    }

    private RexNode simplifyComparison(RexCall e) {
        ArrayList<RexNode> operands = new ArrayList<RexNode>(e.operands);
        this.simplifyList(operands);
        RexNode o0 = (RexNode)operands.get(0);
        RexNode o1 = (RexNode)operands.get(1);
        if (RexUtil.eq(o0, o1) && (this.unknownAsFalse || !o0.getType().isNullable() && !o1.getType().isNullable())) {
            switch (e.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: {
                    return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, o0));
                }
            }
            return this.rexBuilder.makeLiteral(false);
        }
        if (o0.isA(SqlKind.LITERAL) && o1.isA(SqlKind.LITERAL) && o0.getType().equals(o1.getType())) {
            Comparable v0 = ((RexLiteral)o0).getValue();
            Comparable v1 = ((RexLiteral)o1).getValue();
            if (v0 == null || v1 == null) {
                return this.unknownAsFalse ? this.rexBuilder.makeLiteral(false) : this.rexBuilder.makeNullLiteral(e.getType());
            }
            int comparisonResult = v0.compareTo(v1);
            switch (e.getKind()) {
                case EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult == 0);
                }
                case GREATER_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult > 0);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult >= 0);
                }
                case LESS_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult < 0);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult <= 0);
                }
                case NOT_EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult != 0);
                }
            }
            throw new AssertionError();
        }
        if (operands.equals(e.operands)) {
            return e;
        }
        return this.rexBuilder.makeCall(e.op, operands);
    }

    public RexNode simplifyAnds(Iterable<? extends RexNode> nodes) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (RexNode rexNode : nodes) {
            RelOptUtil.decomposeConjunction(rexNode, terms, notTerms);
        }
        this.simplifyList(terms);
        this.simplifyList(notTerms);
        if (this.unknownAsFalse) {
            return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms);
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    private void simplifyList(List<RexNode> terms) {
        for (int i = 0; i < terms.size(); ++i) {
            terms.set(i, this.withUnknownAsFalse(false).simplify(terms.get(i)));
        }
    }

    private RexNode simplifyNot(RexCall call) {
        RexNode a = call.getOperands().get(0);
        switch (a.getKind()) {
            case NOT: {
                return this.simplify(((RexCall)a).getOperands().get(0));
            }
        }
        SqlKind negateKind = a.getKind().negate();
        if (a.getKind() != negateKind) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind), ImmutableList.of(((RexCall)a).getOperands().get(0))));
        }
        SqlKind negateKind2 = a.getKind().negateNullSafe();
        if (a.getKind() != negateKind2) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind2), ((RexCall)a).getOperands()));
        }
        if (a.getKind() == SqlKind.AND) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand)));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands));
        }
        if (a.getKind() == SqlKind.OR) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand)));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newOperands));
        }
        return call;
    }

    private RexNode simplifyIs(RexCall call) {
        RexNode a;
        SqlKind kind = call.getKind();
        RexNode simplified = this.simplifyIs2(kind, a = call.getOperands().get(0));
        if (simplified != null) {
            return simplified;
        }
        return call;
    }

    private RexNode simplifyIs2(SqlKind kind, RexNode a) {
        switch (kind) {
            case IS_NULL: {
                if (a.getType().isNullable()) break;
                return this.rexBuilder.makeLiteral(false);
            }
            case IS_NOT_NULL: {
                RexNode simplified = this.simplifyIsNotNull(a);
                if (simplified == null) break;
                return simplified;
            }
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                if (a.getType().isNullable()) break;
                return this.simplify(a);
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: {
                if (a.getType().isNullable()) break;
                return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a));
            }
        }
        switch (a.getKind()) {
            case NOT: {
                SqlOperator notKind = RexUtil.op(kind.negate());
                RexNode arg = (RexNode)((RexCall)a).operands.get(0);
                return this.simplify(this.rexBuilder.makeCall(notKind, arg));
            }
        }
        RexNode a2 = this.simplify(a);
        if (a != a2) {
            return this.rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(a2));
        }
        return null;
    }

    private RexNode simplifyIsNotNull(RexNode a) {
        if (!a.getType().isNullable()) {
            return this.rexBuilder.makeLiteral(true);
        }
        switch (Strong.policy(a.getKind())) {
            case ANY: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (RexNode operand : ((RexCall)a).getOperands()) {
                    RexNode simplified = this.simplifyIsNotNull(operand);
                    if (simplified == null) {
                        operands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
                        continue;
                    }
                    if (simplified.isAlwaysFalse()) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    operands.add(simplified);
                }
                return RexUtil.composeConjunction(this.rexBuilder, operands, false);
            }
            case CUSTOM: {
                switch (a.getKind()) {
                    case LITERAL: {
                        return this.rexBuilder.makeLiteral(((RexLiteral)a).getValue() != null);
                    }
                }
                throw new AssertionError((Object)("every CUSTOM policy needs a handler, " + (Object)((Object)a.getKind())));
            }
        }
        return null;
    }

    private RexNode simplifyCase(RexCall call) {
        ArrayList<RexNode> newOperands;
        List<RexNode> operands;
        block22: {
            operands = call.getOperands();
            newOperands = new ArrayList<RexNode>();
            HashSet<String> values = new HashSet<String>();
            for (int i = 0; i < operands.size(); ++i) {
                RexNode operand = operands.get(i);
                if (RexUtil.isCasePredicate(call, i)) {
                    if (operand.isAlwaysTrue()) {
                        newOperands.add(operands.get(++i));
                        if (this.unknownAsFalse && RexUtil.isNull(operands.get(i))) {
                            values.add(this.rexBuilder.makeLiteral(false).toString());
                            break;
                        }
                        values.add(operands.get(i).toString());
                        break;
                    }
                    if (operand.isAlwaysFalse() || RexUtil.isNull(operand)) {
                        ++i;
                        continue;
                    }
                } else if (this.unknownAsFalse && RexUtil.isNull(operand)) {
                    values.add(this.rexBuilder.makeLiteral(false).toString());
                } else {
                    values.add(operand.toString());
                }
                newOperands.add(operand);
            }
            assert (newOperands.size() % 2 == 1);
            if (newOperands.size() == 1 || values.size() == 1) {
                RexNode last = (RexNode)Util.last(newOperands);
                if (!call.getType().equals(last.getType())) {
                    return this.rexBuilder.makeAbstractCast(call.getType(), last);
                }
                return last;
            }
            if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                Object disjunction;
                ArrayList<RexNode> terms;
                List<Pair<RexNode, RexNode>> pairs = RexSimplify.casePairs(this.rexBuilder, newOperands);
                if (this.unknownAsFalse) {
                    Pair<RexNode, RexNode> pair;
                    int pos;
                    terms = new ArrayList();
                    for (pos = 0; pos < pairs.size() && (pair = pairs.get(pos)).getValue().isAlwaysTrue(); ++pos) {
                        terms.add(pair.getKey());
                    }
                    while (pos < pairs.size() && ((pair = pairs.get(pos)).getValue().isAlwaysFalse() || RexUtil.isNull(pair.getValue()))) {
                        ++pos;
                    }
                    if (pos == pairs.size()) {
                        disjunction = RexUtil.composeDisjunction(this.rexBuilder, terms);
                        if (!call.getType().equals(((RexNode)disjunction).getType())) {
                            return this.rexBuilder.makeCast(call.getType(), (RexNode)disjunction);
                        }
                        return disjunction;
                    }
                }
                for (Ord pair : Ord.zip(pairs)) {
                    if (!((RexNode)((Pair)pair.e).getKey()).getType().isNullable() && (((RexNode)((Pair)pair.e).getValue()).isAlwaysTrue() || ((RexNode)((Pair)pair.e).getValue()).isAlwaysFalse() || this.unknownAsFalse && RexUtil.isNull((RexNode)((Pair)pair.e).getValue()))) continue;
                    break block22;
                }
                terms = new ArrayList<RexNode>();
                ArrayList notTerms = new ArrayList();
                for (Ord pair : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)pair.e).getValue()).isAlwaysTrue()) {
                        terms.add(RexUtil.andNot(this.rexBuilder, (RexNode)((Pair)pair.e).getKey(), notTerms));
                        continue;
                    }
                    notTerms.add(((Pair)pair.e).getKey());
                }
                disjunction = RexUtil.composeDisjunction(this.rexBuilder, terms);
                if (!call.getType().equals(((RexNode)disjunction).getType())) {
                    return this.rexBuilder.makeCast(call.getType(), (RexNode)disjunction);
                }
                return disjunction;
            }
        }
        if (newOperands.equals(operands)) {
            return call;
        }
        return call.clone(call.getType(), newOperands);
    }

    private static List<Pair<RexNode, RexNode>> casePairs(RexBuilder rexBuilder, List<RexNode> operands) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            builder.add(Pair.of(operands.get(i), operands.get(i + 1)));
        }
        builder.add(Pair.of(rexBuilder.makeLiteral(true), Util.last(operands)));
        return builder.build();
    }

    public RexNode simplifyAnd(RexCall e) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e, terms, notTerms);
        this.simplifyList(terms);
        this.simplifyList(notTerms);
        if (this.unknownAsFalse) {
            return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms);
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    RexNode simplifyAnd2(List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term : terms) {
            if (!term.isAlwaysFalse()) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return this.simplify(terms.get(0));
        }
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2 = RelOptUtil.conjunctions(notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction)));
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms, false);
    }

    RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term : terms) {
            if (!term.isAlwaysFalse()) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return this.simplify(terms.get(0));
        }
        ArrayListMultimap<String, Pair<String, RexNode>> equalityTerms = ArrayListMultimap.create();
        HashMap<String, String> equalityConstantTerms = new HashMap<String, String>();
        HashSet<String> negatedTerms = new HashSet<String>();
        HashSet<String> nullOperands = new HashSet<String>();
        LinkedHashSet<RexNode> notNullOperands = new LinkedHashSet<RexNode>();
        HashSet<String> comparedOperands = new HashSet<String>();
        block8: for (int i = 0; i < terms.size(); ++i) {
            RexCall call;
            RexNode term = terms.get(i);
            if (!RexUtil.isDeterministic(term)) continue;
            while (term.getKind() == SqlKind.EQUALS) {
                call = (RexCall)term;
                if (call.getOperands().get(0).isAlwaysTrue()) {
                    term = call.getOperands().get(1);
                    terms.set(i, term);
                    continue;
                }
                if (!call.getOperands().get(1).isAlwaysTrue()) break;
                term = call.getOperands().get(0);
                terms.set(i, term);
            }
            switch (term.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexNode negatedTerm;
                    call = (RexCall)term;
                    RexNode left = call.getOperands().get(0);
                    comparedOperands.add(left.toString());
                    if (left.getKind() == SqlKind.CAST) {
                        RexCall leftCast = (RexCall)left;
                        comparedOperands.add(leftCast.getOperands().get(0).toString());
                    }
                    RexNode right = call.getOperands().get(1);
                    comparedOperands.add(right.toString());
                    if (right.getKind() == SqlKind.CAST) {
                        RexCall rightCast = (RexCall)right;
                        comparedOperands.add(rightCast.getOperands().get(0).toString());
                    }
                    if (term.getKind() == SqlKind.EQUALS) {
                        String prevLiteral;
                        String literal;
                        boolean leftRef = RexUtil.isReferenceOrAccess(left, true);
                        boolean rightRef = RexUtil.isReferenceOrAccess(right, true);
                        if (right instanceof RexLiteral && leftRef) {
                            literal = right.toString();
                            prevLiteral = equalityConstantTerms.put(left.toString(), literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return this.rexBuilder.makeLiteral(false);
                            }
                        } else if (left instanceof RexLiteral && rightRef) {
                            literal = left.toString();
                            prevLiteral = equalityConstantTerms.put(right.toString(), literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return this.rexBuilder.makeLiteral(false);
                            }
                        } else if (leftRef && rightRef) {
                            equalityTerms.put(left.toString(), Pair.of(right.toString(), term));
                        }
                    }
                    if ((negatedTerm = RexUtil.negate(this.rexBuilder, call)) == null) continue block8;
                    negatedTerms.add(negatedTerm.toString());
                    RexNode invertNegatedTerm = RexUtil.invert(this.rexBuilder, (RexCall)negatedTerm);
                    if (invertNegatedTerm == null) continue block8;
                    negatedTerms.add(invertNegatedTerm.toString());
                    continue block8;
                }
                case IN: {
                    comparedOperands.add(((RexNode)((RexCall)term).operands.get(0)).toString());
                    continue block8;
                }
                case BETWEEN: {
                    comparedOperands.add(((RexNode)((RexCall)term).operands.get(1)).toString());
                    continue block8;
                }
                case IS_NOT_NULL: {
                    notNullOperands.add(((RexCall)term).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block8;
                }
                case IS_NULL: {
                    nullOperands.add(((RexCall)term).getOperands().get(0).toString());
                }
            }
        }
        if (!Collections.disjoint(nullOperands, comparedOperands)) {
            return this.rexBuilder.makeLiteral(false);
        }
        for (String ref1 : equalityTerms.keySet()) {
            String literal1 = (String)equalityConstantTerms.get(ref1);
            if (literal1 == null) continue;
            Collection references = equalityTerms.get(ref1);
            for (Pair ref2 : references) {
                String literal2 = (String)equalityConstantTerms.get(ref2.left);
                if (literal2 == null) continue;
                if (!literal1.equals(literal2)) {
                    return this.rexBuilder.makeLiteral(false);
                }
                terms.remove(ref2.right);
            }
        }
        for (RexNode operand : notNullOperands) {
            if (comparedOperands.contains(operand.toString())) continue;
            terms.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
        }
        HashSet<String> termsSet = new HashSet<String>(RexUtil.strings(terms));
        for (RexNode notDisjunction : notTerms) {
            List<String> terms2Set;
            if (!RexUtil.isDeterministic(notDisjunction) || !termsSet.containsAll(terms2Set = RexUtil.strings(RelOptUtil.conjunctions(notDisjunction)))) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            RexNode call = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction);
            terms.add(this.simplify(call));
        }
        for (String negatedTerm : negatedTerms) {
            if (!termsSet.contains(negatedTerm)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms, false);
    }

    public RexNode simplifyOr(RexCall call) {
        assert (call.getKind() == SqlKind.OR);
        List<RexNode> terms = RelOptUtil.disjunctions(call);
        return this.simplifyOrs(terms);
    }

    public RexNode simplifyOrs(List<RexNode> terms) {
        block3: for (int i = 0; i < terms.size(); ++i) {
            RexNode term = this.simplify(terms.get(i));
            switch (term.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.isNullLiteral(term)) {
                        if (RexLiteral.booleanValue(term)) {
                            return term;
                        }
                        terms.remove(i);
                        --i;
                        continue block3;
                    }
                }
                default: {
                    terms.set(i, term);
                }
            }
        }
        return RexUtil.composeDisjunction(this.rexBuilder, terms);
    }

    private RexNode simplifyCast(RexCall e) {
        RexNode operand = e.getOperands().get(0);
        switch (operand.getKind()) {
            case LITERAL: {
                RexLiteral literal = (RexLiteral)operand;
                Comparable value = literal.getValue();
                SqlTypeName typeName = literal.getTypeName();
                if (this.rexBuilder.canRemoveCastFromLiteral(e.getType(), value, typeName)) {
                    return this.rexBuilder.makeCast(e.getType(), operand);
                }
                switch (literal.getTypeName()) {
                    case TIME: {
                        switch (e.getType().getSqlTypeName()) {
                            case TIMESTAMP: {
                                return e;
                            }
                        }
                    }
                }
                ArrayList<RexNode> reducedValues = new ArrayList<RexNode>();
                this.executor.reduce(this.rexBuilder, ImmutableList.of(e), reducedValues);
                return Preconditions.checkNotNull(Iterables.getOnlyElement(reducedValues));
            }
        }
        return e;
    }
}

