/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.kudu.sink;

import com.datamountaineer.kcql.Kcql;
import com.datamountaineer.streamreactor.connect.kudu.KuduConverter;
import com.datamountaineer.streamreactor.connect.kudu.KuduConverter$class;
import com.datamountaineer.streamreactor.connect.kudu.config.KuduSettings;
import com.datamountaineer.streamreactor.connect.kudu.sink.CreateTableProps;
import com.datamountaineer.streamreactor.connect.kudu.sink.DbHandler$;
import com.datamountaineer.streamreactor.connect.schemas.SchemaRegistry$;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Upsert;
import org.json4s.JsonAST;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DbHandler$
implements StrictLogging,
KuduConverter {
    public static final DbHandler$ MODULE$;
    private Map<String, Map<String, JsonAST.JValue>> com$datamountaineer$streamreactor$connect$kudu$KuduConverter$$cacheJSONFields;
    private final Logger logger;

    static {
        new DbHandler$();
    }

    @Override
    public Map<String, Map<String, JsonAST.JValue>> com$datamountaineer$streamreactor$connect$kudu$KuduConverter$$cacheJSONFields() {
        return this.com$datamountaineer$streamreactor$connect$kudu$KuduConverter$$cacheJSONFields;
    }

    @Override
    @TraitSetter
    public void com$datamountaineer$streamreactor$connect$kudu$KuduConverter$$cacheJSONFields_$eq(Map<String, Map<String, JsonAST.JValue>> x$1) {
        this.com$datamountaineer$streamreactor$connect$kudu$KuduConverter$$cacheJSONFields = x$1;
    }

    @Override
    public Upsert convertToKuduUpsert(SinkRecord record, KuduTable table) {
        return KuduConverter$class.convertToKuduUpsert(this, record, table);
    }

    @Override
    public Upsert convertJsonToKuduUpsert(JsonAST.JValue payload, KuduTable table) {
        return KuduConverter$class.convertJsonToKuduUpsert(this, payload, table);
    }

    @Override
    public org.apache.kudu.Schema convertToKuduSchema(SinkRecord record, Kcql kcql) {
        return KuduConverter$class.convertToKuduSchema((KuduConverter)this, record, kcql);
    }

    @Override
    public org.apache.kudu.Schema convertToKuduSchemaFromJson(JsonAST.JValue payload, String topic) {
        return KuduConverter$class.convertToKuduSchemaFromJson(this, payload, topic);
    }

    @Override
    public Map<String, JsonAST.JValue> extractJSONFields(JsonAST.JValue payload, String topic) {
        return KuduConverter$class.extractJSONFields(this, payload, topic);
    }

    @Override
    public org.apache.kudu.Schema convertToKuduSchema(org.apache.kafka.connect.data.Schema schema, Kcql kcql) {
        return KuduConverter$class.convertToKuduSchema((KuduConverter)this, schema, kcql);
    }

    @Override
    public Seq<ColumnSchema> createKuduColumns(Seq<Field> fields, Kcql kcql) {
        return KuduConverter$class.createKuduColumns(this, fields, kcql);
    }

    @Override
    public ColumnSchema convertConnectField(Field field, boolean isKey) {
        return KuduConverter$class.convertConnectField(this, field, isKey);
    }

    @Override
    public ColumnSchema convertJsonToColumnSchema(Tuple2<String, JsonAST.JValue> value) {
        return KuduConverter$class.convertJsonToColumnSchema(this, value);
    }

    @Override
    public ColumnSchema.ColumnSchemaBuilder fromAvro(Schema schema, String fieldName) {
        return KuduConverter$class.fromAvro(this, schema, fieldName);
    }

    @Override
    public Map<String, Map<String, JsonAST.JValue>> getCacheJSONFields() {
        return KuduConverter$class.getCacheJSONFields(this);
    }

    @Override
    public boolean convertConnectField$default$2() {
        return KuduConverter$class.convertConnectField$default$2(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void checkTables(KuduClient client, KuduSettings settings) {
        BoxedUnit boxedUnit;
        java.util.List kuduTables = client.getTablesList().getTablesList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found the following tables in Kudu, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConversions$.MODULE$.asScalaBuffer(kuduTables).mkString(",")})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        scala.collection.immutable.Set tables = ((TraversableOnce)settings.kcql().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Kcql s) {
                return s.getTarget().trim();
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set missing = (scala.collection.immutable.Set)tables.diff((GenSet)JavaConversions$.MODULE$.asScalaBuffer(kuduTables).toSet());
        ((IterableLike)missing.flatMap((Function1)new Serializable(settings){
            public static final long serialVersionUID = 0L;
            private final KuduSettings settings$1;

            public final List<Kcql> apply(String m) {
                return (List)this.settings$1.kcql().filter((Function1)new Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final String m$1;

                    public final boolean apply(Kcql f) {
                        return f.getTarget().trim().equals(this.m$1) && f.isAutoCreate();
                    }
                    {
                        this.m$1 = m$1;
                    }
                });
            }
            {
                this.settings$1 = settings$1;
            }
        }, Set$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Kcql a) {
                BoxedUnit boxedUnit;
                if (DbHandler$.MODULE$.logger().underlying().isWarnEnabled()) {
                    DbHandler$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kudu table ", " does not exist in Kudu and is marked for AutoCreate!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
        scala.collection.immutable.Set finalList = (scala.collection.immutable.Set)missing.flatMap((Function1)new Serializable(settings){
            public static final long serialVersionUID = 0L;
            private final KuduSettings settings$1;

            public final List<Kcql> apply(String m) {
                return (List)this.settings$1.kcql().filter((Function1)new Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final String m$2;

                    public final boolean apply(Kcql f) {
                        return f.getTarget().trim().equals(this.m$2) && !f.isAutoCreate();
                    }
                    {
                        this.m$2 = m$2;
                    }
                });
            }
            {
                this.settings$1 = settings$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (finalList.nonEmpty()) {
            throw new ConnectException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following tables are not found and not set for autocreate"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ". Check you aren't missing the namespace (impala::database.table) "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)finalList.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Kcql f) {
                    return f.getTarget();
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for Impala managed tables!"})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Map<String, KuduTable> buildTableCache(KuduSettings settings, KuduClient client) {
        this.checkTables(client, settings);
        return ((TraversableOnce)((List)((TraversableLike)settings.kcql().map((Function1)new Serializable(client){
            public static final long serialVersionUID = 0L;
            public final KuduClient client$1;

            public final Tuple2<String, Option<KuduTable>> apply(Kcql s) {
                Try try_;
                block7: {
                    Tuple2 tuple2;
                    block6: {
                        BoxedUnit boxedUnit;
                        block5: {
                            try_ = Try$.MODULE$.apply((Function0)new Serializable(this, s){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.buildTableCache.1 $outer;
                                private final Kcql s$1;

                                public final KuduTable apply() {
                                    return this.$outer.client$1.openTable(this.s$1.getTarget());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.s$1 = s$1;
                                }
                            });
                            if (!(try_ instanceof Success)) break block5;
                            Success success = (Success)try_;
                            KuduTable t = (KuduTable)success.value();
                            tuple2 = new Tuple2((Object)s.getSource(), (Object)new Some((Object)t));
                            break block6;
                        }
                        if (!(try_ instanceof Failure)) break block7;
                        Failure failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        if (DbHandler$.MODULE$.logger().underlying().isErrorEnabled()) {
                            DbHandler$.MODULE$.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not build table cache for table ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getSource()})), ex);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        tuple2 = new Tuple2((Object)s.getSource(), (Object)None$.MODULE$);
                    }
                    return tuple2;
                }
                throw new MatchError((Object)try_);
            }
            {
                this.client$1 = client$1;
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Option<KuduTable>> s) {
                return ((Option)s._2()).isDefined();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, KuduTable> apply(Tuple2<String, Option<KuduTable>> s) {
                return new Tuple2(s._1(), ((Option)s._2()).get());
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Set<KuduTable> createTables(KuduSettings setting, KuduClient client) {
        this.checkTables(client, setting);
        String url = setting.schemaRegistryUrl();
        scala.collection.immutable.Set subjects = SchemaRegistry$.MODULE$.getSubjects(url).toSet();
        return ((TraversableOnce)((List)((GenericTraversableTemplate)((List)setting.kcql().filter((Function1)new Serializable(client){
            public static final long serialVersionUID = 0L;
            private final KuduClient client$2;

            public final boolean apply(Kcql r) {
                return r.isAutoCreate() && !this.client$2.tableExists(r.getTarget());
            }
            {
                this.client$2 = client$2;
            }
        })).map((Function1)new Serializable(client, url, subjects){
            public static final long serialVersionUID = 0L;
            private final KuduClient client$2;
            private final String url$1;
            private final scala.collection.immutable.Set subjects$1;

            public final scala.collection.immutable.Set<CreateTableProps> apply(Kcql m) {
                String lkTopic = m.getSource();
                if (!this.subjects$1.contains((Object)lkTopic) && this.subjects$1.contains((Object)new StringBuilder().append((Object)lkTopic).append((Object)"-value").toString())) {
                    lkTopic = new StringBuilder().append((Object)lkTopic).append((Object)"-value").toString();
                }
                return DbHandler$.MODULE$.createTableProps(SchemaRegistry$.MODULE$.getSchema(this.url$1, lkTopic), m, this.url$1, this.client$2);
            }
            {
                this.client$2 = client$2;
                this.url$1 = url$1;
                this.subjects$1 = subjects$1;
            }
        }, List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(client){
            public static final long serialVersionUID = 0L;
            private final KuduClient client$2;

            public final KuduTable apply(CreateTableProps ctp) {
                return DbHandler$.MODULE$.executeCreateTable(ctp, this.client$2);
            }
            {
                this.client$2 = client$2;
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
    }

    public scala.collection.immutable.Set<CreateTableProps> createTableProps(String schema, Kcql kcql, String url, KuduClient client) {
        scala.collection.immutable.Set set;
        if (new StringOps(Predef$.MODULE$.augmentString(schema)).nonEmpty()) {
            org.apache.kudu.Schema kuduSchema = this.getKuduSchema(kcql, schema);
            CreateTableOptions cto = this.getCreateTableOptions(kcql);
            CreateTableProps createTableProps = new CreateTableProps(kcql.getTarget(), kuduSchema, cto);
            set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateTableProps[]{createTableProps}));
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public org.apache.kudu.Schema getKuduSchema(Kcql config, String schema) {
        Schema avroFields = new Schema.Parser().parse(schema);
        java.util.List<ColumnSchema> kuduCols = this.getKuduCols(config, avroFields);
        return new org.apache.kudu.Schema(kuduCols);
    }

    private java.util.List<ColumnSchema> getKuduCols(Kcql kcql, Schema avroFields) {
        BoxedUnit boxedUnit;
        if (JavaConversions$.MODULE$.asScalaBuffer(kcql.getFields()).head().equals("*")) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All fields from topic will be used to create Kudu table ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kcql.getTarget()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using fields ", " to create the ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConversions$.MODULE$.asScalaBuffer(kcql.getFields()).mkString(","), kcql.getTarget()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Map mappingFields = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(kcql.getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(com.datamountaineer.kcql.Field f) {
                return new Tuple2((Object)f.getName(), (Object)f.getAlias());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Set ignored = JavaConversions$.MODULE$.asScalaBuffer(kcql.getIgnoredFields()).toSet();
        Buffer fields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(avroFields.getFields()).filterNot((Function1)new Serializable(ignored){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set ignored$1;

            public final boolean apply(Schema.Field f) {
                return JavaConversions$.MODULE$.setAsJavaSet((Set)this.ignored$1).contains(f.name());
            }
            {
                this.ignored$1 = ignored$1;
            }
        });
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(kcql){
            public static final long serialVersionUID = 0L;
            private final Kcql kcql$1;

            public final scala.collection.immutable.Set<String> apply() {
                return JavaConversions$.MODULE$.asScalaIterator(this.kcql$1.getBucketing().getBucketNames()).toSet();
            }
            {
                this.kcql$1 = kcql$1;
            }
        });
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit2;
            scala.collection.immutable.Set s;
            scala.collection.immutable.Set set;
            Success success = (Success)try_;
            scala.collection.immutable.Set pks = set = (s = (scala.collection.immutable.Set)success.value());
            List cols = ((TraversableOnce)fields.map((Function1)new Serializable(kcql, mappingFields, pks){
                public static final long serialVersionUID = 0L;
                private final Kcql kcql$1;
                private final Map mappingFields$1;
                private final scala.collection.immutable.Set pks$1;

                public final ColumnSchema apply(Schema.Field f) {
                    Object object;
                    Object object2;
                    String fieldName = f.name();
                    String alias = this.mappingFields$1.contains((Object)fieldName) ? (String)this.mappingFields$1.apply((Object)fieldName) : fieldName;
                    ColumnSchema.ColumnSchemaBuilder col = DbHandler$.MODULE$.fromAvro(f.schema(), alias);
                    Object object3 = f.defaultVal();
                    JsonProperties.Null nullVal = JsonProperties.NULL_VALUE;
                    Object object4 = !(object3 != null ? !object3.equals(nullVal) : nullVal != null) ? null : (object2 = f.defaultVal());
                    if (this.pks$1.contains((Object)alias)) {
                        BoxedUnit boxedUnit;
                        if (DbHandler$.MODULE$.logger().underlying().isInfoEnabled()) {
                            DbHandler$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting PK on ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name(), this.kcql$1.getTarget()})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = col.key(true);
                    } else {
                        col.nullable(true);
                        object = object2 == null ? BoxedUnit.UNIT : col.defaultValue(object2);
                    }
                    return col.build();
                }
                {
                    this.kcql$1 = kcql$1;
                    this.mappingFields$1 = mappingFields$1;
                    this.pks$1 = pks$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting columns as ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)cols.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ColumnSchema c) {
                        return c.getName();
                    }
                }, List$.MODULE$.canBuildFrom())).mkString(","), kcql.getTarget()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return JavaConversions$.MODULE$.seqAsJavaList((Seq)cols);
        }
        if (try_ instanceof Failure) {
            throw new ConnectException("DISTRIBUTEBY columns INTO BUCKETS n must be specified for table auto creation!");
        }
        throw new MatchError((Object)try_);
    }

    public KuduTable alterTable(String table, org.apache.kafka.connect.data.Schema old, org.apache.kafka.connect.data.Schema current, KuduClient client) {
        List<AlterTableOptions> ato = this.compare(old, current);
        ato.foreach((Function1)new Serializable(table, client){
            public static final long serialVersionUID = 0L;
            private final String table$1;
            private final KuduClient client$3;

            public final void apply(AlterTableOptions a) {
                DbHandler$.MODULE$.com$datamountaineer$streamreactor$connect$kudu$sink$DbHandler$$executeAlterTable(a, this.table$1, this.client$3);
            }
            {
                this.table$1 = table$1;
                this.client$3 = client$3;
            }
        });
        return client.openTable(table);
    }

    public KuduTable alterTable(String table, Map<String, JsonAST.JValue> old, Map<String, JsonAST.JValue> current, KuduClient client) {
        List<AlterTableOptions> ato = this.compare(old, current);
        ato.foreach((Function1)new Serializable(table, client){
            public static final long serialVersionUID = 0L;
            private final String table$2;
            private final KuduClient client$4;

            public final void apply(AlterTableOptions a) {
                DbHandler$.MODULE$.com$datamountaineer$streamreactor$connect$kudu$sink$DbHandler$$executeAlterTable(a, this.table$2, this.client$4);
            }
            {
                this.table$2 = table$2;
                this.client$4 = client$4;
            }
        });
        return client.openTable(table);
    }

    public List<AlterTableOptions> compare(org.apache.kafka.connect.data.Schema old, org.apache.kafka.connect.data.Schema current) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Found a difference in the schemas.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        scala.collection.immutable.Set diff = (scala.collection.immutable.Set)JavaConversions$.MODULE$.asScalaBuffer(current.fields()).toSet().diff((GenSet)JavaConversions$.MODULE$.asScalaBuffer(old.fields()).toSet());
        return ((TraversableOnce)diff.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AlterTableOptions apply(Field d) {
                AlterTableOptions alterTableOptions;
                ColumnSchema schema = DbHandler$.MODULE$.convertConnectField(d, DbHandler$.MODULE$.convertConnectField$default$2());
                AlterTableOptions ato = new AlterTableOptions();
                if (schema.getDefaultValue() == null) {
                    BoxedUnit boxedUnit;
                    if (DbHandler$.MODULE$.logger().underlying().isInfoEnabled()) {
                        DbHandler$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding nullable column ", ", type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.getName(), schema.getType()})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    alterTableOptions = ato.addNullableColumn(schema.getName(), schema.getType());
                } else {
                    BoxedUnit boxedUnit;
                    if (DbHandler$.MODULE$.logger().underlying().isInfoEnabled()) {
                        DbHandler$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding column ", ", type ", ", default ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.getName(), schema.getType(), schema.getDefaultValue()})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    alterTableOptions = ato.addColumn(schema.getName(), schema.getType(), schema.getDefaultValue());
                }
                return alterTableOptions;
            }
        }, Set$.MODULE$.canBuildFrom())).toList();
    }

    public List<AlterTableOptions> compare(Map<String, JsonAST.JValue> old, Map<String, JsonAST.JValue> current) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Found a difference in the schemas.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        scala.collection.immutable.Set diff = (scala.collection.immutable.Set)current.keySet().diff((GenSet)old.keySet());
        return ((TraversableOnce)diff.map((Function1)new Serializable(current){
            public static final long serialVersionUID = 0L;
            private final Map current$1;

            public final AlterTableOptions apply(String d) {
                BoxedUnit boxedUnit;
                ColumnSchema schema = DbHandler$.MODULE$.convertJsonToColumnSchema((Tuple2<String, JsonAST.JValue>)new Tuple2((Object)d, this.current$1.apply((Object)d)));
                AlterTableOptions ato = new AlterTableOptions();
                if (DbHandler$.MODULE$.logger().underlying().isInfoEnabled()) {
                    DbHandler$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding column ", ", type ", ", default ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.getName(), schema.getType(), schema.getDefaultValue()})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return ato.addColumn(schema.getName(), schema.getType(), schema.getDefaultValue());
            }
            {
                this.current$1 = current$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toList();
    }

    public void com$datamountaineer$streamreactor$connect$kudu$sink$DbHandler$$executeAlterTable(AlterTableOptions ato, String target, KuduClient client) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing alter table on ", " with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target, ato.toString()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        client.alterTable(target, ato);
        while (true) {
            BoxedUnit boxedUnit2;
            if (client.isAlterTableDone(target)) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Altered table ", ". Added ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target, ato.toString()})));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                return;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting to alter table to complete for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target})));
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public Try<KuduTable> createTableFromSinkRecord(Kcql kcql, org.apache.kafka.connect.data.Schema schema, KuduClient client) {
        Failure failure;
        if (kcql.isAutoCreate()) {
            CreateTableOptions cto = this.getCreateTableOptions(kcql);
            org.apache.kudu.Schema kuduSchema = this.convertToKuduSchema(schema, kcql);
            CreateTableProps ctp = new CreateTableProps(kcql.getTarget(), kuduSchema, cto);
            failure = new Success((Object)this.executeCreateTable(ctp, client));
        } else {
            failure = new Failure((Throwable)new ConnectException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mapping ", " not configured for Auto table creation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kcql.toString()}))));
        }
        return failure;
    }

    public Try<KuduTable> createTableFromJsonPayload(Kcql kcql, JsonAST.JValue payload, KuduClient client, String topic) {
        Failure failure;
        if (kcql.isAutoCreate()) {
            CreateTableOptions cto = this.getCreateTableOptions(kcql);
            org.apache.kudu.Schema kuduSchema = this.convertToKuduSchemaFromJson(payload, topic);
            CreateTableProps ctp = new CreateTableProps(kcql.getTarget(), kuduSchema, cto);
            failure = new Success((Object)this.executeCreateTable(ctp, client));
        } else {
            failure = new Failure((Throwable)new ConnectException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mapping ", " not configured for Auto table creation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kcql.toString()}))));
        }
        return failure;
    }

    /*
     * WARNING - void declaration
     */
    public KuduTable executeCreateTable(CreateTableProps ctp, KuduClient client) {
        void var3_3;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing create table on ", " with ", " and props ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctp.name(), ctp.schema().toString(), ctp.cto().toString()})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        KuduTable table = client.createTable(ctp.name(), ctp.schema(), ctp.cto());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " created."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctp.name()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private CreateTableOptions getCreateTableOptions(Kcql config) {
        return new CreateTableOptions().addHashPartitions(JavaConversions$.MODULE$.seqAsJavaList((Seq)JavaConversions$.MODULE$.asScalaIterator(config.getBucketing().getBucketNames()).toList()), config.getBucketing().getBucketsNumber()).setRangePartitionColumns(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.empty()));
    }

    private DbHandler$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        KuduConverter$class.$init$(this);
    }
}

