/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.kudu.sink;

import com.datamountaineer.streamreactor.connect.errors.ErrorPolicyEnum$;
import com.datamountaineer.streamreactor.connect.kudu.config.KuduConfig;
import com.datamountaineer.streamreactor.connect.kudu.config.KuduConfig$;
import com.datamountaineer.streamreactor.connect.kudu.config.KuduConfigConstants$;
import com.datamountaineer.streamreactor.connect.kudu.config.KuduSettings;
import com.datamountaineer.streamreactor.connect.kudu.config.KuduSettings$;
import com.datamountaineer.streamreactor.connect.kudu.sink.KuduWriter;
import com.datamountaineer.streamreactor.connect.kudu.sink.KuduWriter$;
import com.datamountaineer.streamreactor.connect.utils.JarManifest;
import com.datamountaineer.streamreactor.connect.utils.ProgressCounter;
import com.datamountaineer.streamreactor.connect.utils.ProgressCounter$;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001=\u0011AbS;ekNKgn\u001b+bg.T!a\u0001\u0003\u0002\tMLgn\u001b\u0006\u0003\u000b\u0019\tAa[;ek*\u0011q\u0001C\u0001\bG>tg.Z2u\u0015\tI!\"A\u0007tiJ,\u0017-\u001c:fC\u000e$xN\u001d\u0006\u0003\u00171\tq\u0002Z1uC6|WO\u001c;bS:,WM\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0005\u000f\u0011\u0005EQR\"\u0001\n\u000b\u0005\r\u0019\"BA\u0004\u0015\u0015\t)b#A\u0003lC\u001a\\\u0017M\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0013\u0005!\u0019\u0016N\\6UCN\\\u0007CA\u000f%\u001b\u0005q\"BA\u0010!\u0003\u0015\u0019HN\u001a\u001bk\u0015\t\t#%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002$\u0019\u0005AA/\u001f9fg\u00064W-\u0003\u0002&=\ti1\u000b\u001e:jGRdunZ4j]\u001eDQa\n\u0001\u0005\u0002!\na\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000f1\u0002!\u0019!C\u0005[\u0005y\u0001O]8he\u0016\u001c8oQ8v]R,'/F\u0001/!\ty#'D\u00011\u0015\t\td!A\u0003vi&d7/\u0003\u00024a\ty\u0001K]8he\u0016\u001c8oQ8v]R,'\u000f\u0003\u00046\u0001\u0001\u0006IAL\u0001\u0011aJ|wM]3tg\u000e{WO\u001c;fe\u0002Bqa\u000e\u0001A\u0002\u0013%\u0001(\u0001\bf]\u0006\u0014G.\u001a)s_\u001e\u0014Xm]:\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012qAQ8pY\u0016\fg\u000eC\u0004A\u0001\u0001\u0007I\u0011B!\u0002%\u0015t\u0017M\u00197f!J|wM]3tg~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"AO\"\n\u0005\u0011[$\u0001B+oSRDqAR \u0002\u0002\u0003\u0007\u0011(A\u0002yIEBa\u0001\u0013\u0001!B\u0013I\u0014aD3oC\ndW\r\u0015:pOJ,7o\u001d\u0011\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u00061qO]5uKJ,\u0012\u0001\u0014\t\u0004u5{\u0015B\u0001(<\u0005\u0019y\u0005\u000f^5p]B\u0011!\u0006U\u0005\u0003#\n\u0011!bS;ek^\u0013\u0018\u000e^3s\u0011\u001d\u0019\u0006\u00011A\u0005\nQ\u000b!b\u001e:ji\u0016\u0014x\fJ3r)\t\u0011U\u000bC\u0004G%\u0006\u0005\t\u0019\u0001'\t\r]\u0003\u0001\u0015)\u0003M\u0003\u001d9(/\u001b;fe\u0002Bq!\u0017\u0001C\u0002\u0013%!,\u0001\u0005nC:Lg-Z:u+\u0005Y\u0006CA\u0018]\u0013\ti\u0006GA\u0006KCJl\u0015M\\5gKN$\bBB0\u0001A\u0003%1,A\u0005nC:Lg-Z:uA!)\u0011\r\u0001C!E\u0006)1\u000f^1siR\u0011!i\u0019\u0005\u0006I\u0002\u0004\r!Z\u0001\u0006aJ|\u0007o\u001d\t\u0005M.lW.D\u0001h\u0015\tA\u0017.\u0001\u0003vi&d'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u001e\u00141!T1q!\tq\u0017O\u0004\u0002;_&\u0011\u0001oO\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002qw!)Q\u000f\u0001C!m\u0006\u0019\u0001/\u001e;\u0015\u0005\t;\b\"\u0002=u\u0001\u0004I\u0018a\u0002:fG>\u0014Hm\u001d\t\u0004Mjd\u0018BA>h\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0003#uL!A \n\u0003\u0015MKgn\u001b*fG>\u0014H\rC\u0004\u0002\u0002\u0001!\t%a\u0001\u0002\tM$x\u000e\u001d\u000b\u0002\u0005\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011!\u00024mkNDGc\u0001\"\u0002\f!A\u0011QBA\u0003\u0001\u0004\ty!A\u0002nCB\u0004bAZ6\u0002\u0012\u0005u\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]A#\u0001\u0004d_6lwN\\\u0005\u0005\u00037\t)B\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005A1m\u001c8tk6,'OC\u0002\u0002(Q\tqa\u00197jK:$8/\u0003\u0003\u0002,\u0005\u0005\"!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012a\u0002<feNLwN\u001c\u000b\u0002[\u0002")
public class KuduSinkTask
extends SinkTask
implements StrictLogging {
    private final ProgressCounter progressCounter;
    private boolean enableProgress;
    private Option<KuduWriter> writer;
    private final JarManifest manifest;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ProgressCounter progressCounter() {
        return this.progressCounter;
    }

    private boolean enableProgress() {
        return this.enableProgress;
    }

    private void enableProgress_$eq(boolean x$1) {
        this.enableProgress = x$1;
    }

    private Option<KuduWriter> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<KuduWriter> x$1) {
        this.writer = x$1;
    }

    private JarManifest manifest() {
        return this.manifest;
    }

    public void start(Map<String, String> props) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)Source$.MODULE$.fromInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/kudu-ascii.txt"), Codec$.MODULE$.fallbackSystemCodec()).mkString()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" v ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.version()}))).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.manifest().printManifest());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        KuduConfig$.MODULE$.config().parse(props);
        KuduConfig sinkConfig = new KuduConfig(props);
        this.enableProgress_$eq(Predef$.MODULE$.Boolean2boolean(sinkConfig.getBoolean(KuduConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED())));
        KuduSettings settings = KuduSettings$.MODULE$.apply(sinkConfig);
        if (settings.errorPolicy().equals(ErrorPolicyEnum$.MODULE$.RETRY())) {
            this.context.timeout((long)Predef$.MODULE$.Integer2int(sinkConfig.getInt(KuduConfigConstants$.MODULE$.ERROR_RETRY_INTERVAL())));
        }
        this.writer_$eq((Option<KuduWriter>)new Some((Object)KuduWriter$.MODULE$.apply(sinkConfig, settings)));
    }

    public void put(Collection<SinkRecord> records) {
        Predef$.MODULE$.require(this.writer().nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Writer is not set!";
            }
        });
        Vector seq = JavaConversions$.MODULE$.collectionAsScalaIterable(records).toVector();
        this.writer().foreach((Function1)new Serializable(this, records){
            public static final long serialVersionUID = 0L;
            private final Collection records$1;

            public final void apply(KuduWriter w) {
                w.write((Set<SinkRecord>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.records$1).toSet());
            }
            {
                this.records$1 = records$1;
            }
        });
        if (this.enableProgress()) {
            this.progressCounter().update((scala.collection.immutable.Seq)seq);
        }
    }

    public void stop() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Stopping Kudu sink.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.writer().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KuduWriter w) {
                w.close();
            }
        });
        this.progressCounter().empty();
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> map) {
        Predef$.MODULE$.require(this.writer().nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Writer is not set!";
            }
        });
        this.writer().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KuduWriter w) {
                w.flush();
            }
        });
    }

    public String version() {
        return this.manifest().version();
    }

    public KuduSinkTask() {
        StrictLogging.class.$init$((StrictLogging)this);
        this.progressCounter = new ProgressCounter(ProgressCounter$.MODULE$.$lessinit$greater$default$1());
        this.enableProgress = false;
        this.writer = None$.MODULE$;
        this.manifest = new JarManifest(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation());
    }
}

