/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.mqtt.config;

import com.datamountaineer.kcql.Kcql;
import com.datamountaineer.streamreactor.connect.errors.ErrorPolicy;
import com.datamountaineer.streamreactor.connect.errors.ThrowErrorPolicy;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttConfigConstants$;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttSinkConfig;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttSinkSettings;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.eclipse.paho.client.mqttv3.MqttClient;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple15;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MqttSinkSettings$
implements Serializable {
    public static final MqttSinkSettings$ MODULE$;

    static {
        new MqttSinkSettings$();
    }

    public MqttSinkSettings apply(MqttSinkConfig config) {
        block6: {
            Option sslCertKeyFile;
            Option sslCertFile;
            Option sslCACertFile;
            String clientId;
            String connection;
            Option password;
            Some user;
            Set<Kcql> kcql;
            block5: {
                Tuple3 tuple3;
                block4: {
                    kcql = config.getKCQL();
                    user = new Some((Object)config.getUsername());
                    password = Option$.MODULE$.apply((Object)config.getSecret()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Password x$1) {
                            return x$1.value();
                        }
                    });
                    connection = config.getHosts();
                    clientId = (String)Option$.MODULE$.apply((Object)config.getString(MqttConfigConstants$.MODULE$.CLIENT_ID_CONFIG())).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return MqttClient.generateClientId();
                        }
                    });
                    sslCACertFile = this.getFile$1(MqttConfigConstants$.MODULE$.SSL_CA_CERT_CONFIG(), config);
                    tuple3 = new Tuple3((Object)sslCACertFile, (Object)(sslCertFile = this.getFile$1(MqttConfigConstants$.MODULE$.SSL_CERT_CONFIG(), config)), (Object)(sslCertKeyFile = this.getFile$1(MqttConfigConstants$.MODULE$.SSL_CERT_KEY_CONFIG(), config)));
                    if (tuple3 == null) break block4;
                    Option option = (Option)tuple3._1();
                    Option option2 = (Option)tuple3._2();
                    Option option3 = (Option)tuple3._3();
                    if (!(option instanceof Some) || !(option2 instanceof Some) || !(option3 instanceof Some)) break block4;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (tuple3 == null) break block6;
                Option option = (Option)tuple3._1();
                Option option4 = (Option)tuple3._2();
                Option option5 = (Option)tuple3._3();
                if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option4) || !None$.MODULE$.equals(option5)) break block6;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Boolean progressEnabled = config.getBoolean(MqttConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED());
            ErrorPolicy errorPolicy = config.getErrorPolicy();
            int maxRetries = config.getNumberRetries();
            Integer qs = config.getInt(MqttConfigConstants$.MODULE$.QS_CONFIG());
            if (Predef$.MODULE$.Integer2int(qs) < 0 || Predef$.MODULE$.Integer2int(qs) > 2) {
                throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not valid. Can be 0,1 or 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MqttConfigConstants$.MODULE$.QS_CONFIG()})));
            }
            return new MqttSinkSettings(connection, (Option<String>)user, (Option<String>)password, clientId, kcql, Predef$.MODULE$.Integer2int(qs), Predef$.MODULE$.Integer2int(config.getInt(MqttConfigConstants$.MODULE$.CONNECTION_TIMEOUT_CONFIG())), Predef$.MODULE$.Boolean2boolean(config.getBoolean(MqttConfigConstants$.MODULE$.CLEAN_SESSION_CONFIG())), Predef$.MODULE$.Integer2int(config.getInt(MqttConfigConstants$.MODULE$.KEEP_ALIVE_INTERVAL_CONFIG())), (Option<String>)sslCACertFile, (Option<String>)sslCertFile, (Option<String>)sslCertKeyFile, Predef$.MODULE$.Boolean2boolean(progressEnabled), errorPolicy, maxRetries);
        }
        throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't define one of the ", ",", ", ", " without the other"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MqttConfigConstants$.MODULE$.SSL_CA_CERT_CONFIG(), MqttConfigConstants$.MODULE$.SSL_CERT_CONFIG(), MqttConfigConstants$.MODULE$.SSL_CERT_KEY_CONFIG()})));
    }

    public boolean apply$default$13() {
        return MqttConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED_DEFAULT();
    }

    public ErrorPolicy apply$default$14() {
        return new ThrowErrorPolicy();
    }

    public int apply$default$15() {
        return MqttConfigConstants$.MODULE$.NBR_OF_RETIRES_DEFAULT();
    }

    public MqttSinkSettings apply(String connection, Option<String> user, Option<String> password, String clientId, Set<Kcql> kcql, int mqttQualityOfService, int connectionTimeout, boolean cleanSession, int keepAliveInterval, Option<String> sslCACertFile, Option<String> sslCertFile, Option<String> sslCertKeyFile, boolean enableProgress, ErrorPolicy errorPolicy, int maxRetries) {
        return new MqttSinkSettings(connection, user, password, clientId, kcql, mqttQualityOfService, connectionTimeout, cleanSession, keepAliveInterval, sslCACertFile, sslCertFile, sslCertKeyFile, enableProgress, errorPolicy, maxRetries);
    }

    public Option<Tuple15<String, Option<String>, Option<String>, String, Set<Kcql>, Object, Object, Object, Object, Option<String>, Option<String>, Option<String>, Object, ErrorPolicy, Object>> unapply(MqttSinkSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.connection(), x$0.user(), x$0.password(), (Object)x$0.clientId(), x$0.kcql(), (Object)BoxesRunTime.boxToInteger((int)x$0.mqttQualityOfService()), (Object)BoxesRunTime.boxToInteger((int)x$0.connectionTimeout()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.cleanSession()), (Object)BoxesRunTime.boxToInteger((int)x$0.keepAliveInterval()), x$0.sslCACertFile(), x$0.sslCertFile(), x$0.sslCertKeyFile(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.enableProgress()), (Object)x$0.errorPolicy(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxRetries())));
    }

    public boolean $lessinit$greater$default$13() {
        return MqttConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED_DEFAULT();
    }

    public ErrorPolicy $lessinit$greater$default$14() {
        return new ThrowErrorPolicy();
    }

    public int $lessinit$greater$default$15() {
        return MqttConfigConstants$.MODULE$.NBR_OF_RETIRES_DEFAULT();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Option getFile$1(String configKey, MqttSinkConfig config$1) {
        return Option$.MODULE$.apply((Object)config$1.getString(configKey));
    }

    private MqttSinkSettings$() {
        MODULE$ = this;
    }
}

