/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.mqtt.config;

import com.datamountaineer.kcql.Kcql;
import com.datamountaineer.streamreactor.connect.converters.source.BytesConverter;
import com.datamountaineer.streamreactor.connect.converters.source.Converter;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttConfigConstants$;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttSourceConfig;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttSourceSettings;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.eclipse.paho.client.mqttv3.MqttClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple16;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MqttSourceSettings$
implements Serializable {
    public static final MqttSourceSettings$ MODULE$;

    static {
        new MqttSourceSettings$();
    }

    public MqttSourceSettings apply(MqttSourceConfig config) {
        block6: {
            Option sslCertKeyFile;
            Option sslCertFile;
            Option sslCACertFile;
            String clientId;
            String connection;
            Option password;
            Some user;
            String[] kcqlStr;
            Set<Kcql> kcql;
            block5: {
                Tuple3 tuple3;
                block4: {
                    kcql = config.getKCQL();
                    kcqlStr = config.getKCQLRaw();
                    user = new Some((Object)config.getUsername());
                    password = Option$.MODULE$.apply((Object)config.getSecret()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Password x$1) {
                            return x$1.value();
                        }
                    });
                    connection = config.getHosts();
                    clientId = (String)Option$.MODULE$.apply((Object)config.getString(MqttConfigConstants$.MODULE$.CLIENT_ID_CONFIG())).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return MqttClient.generateClientId();
                        }
                    });
                    sslCACertFile = this.getFile$1(MqttConfigConstants$.MODULE$.SSL_CA_CERT_CONFIG(), config);
                    tuple3 = new Tuple3((Object)sslCACertFile, (Object)(sslCertFile = this.getFile$1(MqttConfigConstants$.MODULE$.SSL_CERT_CONFIG(), config)), (Object)(sslCertKeyFile = this.getFile$1(MqttConfigConstants$.MODULE$.SSL_CERT_KEY_CONFIG(), config)));
                    if (tuple3 == null) break block4;
                    Option option = (Option)tuple3._1();
                    Option option2 = (Option)tuple3._2();
                    Option option3 = (Option)tuple3._3();
                    if (!(option instanceof Some) || !(option2 instanceof Some) || !(option3 instanceof Some)) break block4;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (tuple3 == null) break block6;
                Option option = (Option)tuple3._1();
                Option option4 = (Option)tuple3._2();
                Option option5 = (Option)tuple3._3();
                if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option4) || !None$.MODULE$.equals(option5)) break block6;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Boolean progressEnabled = config.getBoolean(MqttConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED());
            Map converters = ((TraversableOnce)kcql.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Kcql k) {
                    return new Tuple2((Object)k.getSource(), (Object)(k.getWithConverter() == null ? BytesConverter.class.getCanonicalName() : k.getWithConverter()));
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            converters.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String mqtt_source = (String)tuple2._1();
                        String clazz = (String)tuple2._2();
                        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, clazz){
                            public static final long serialVersionUID = 0L;
                            private final String clazz$1;

                            public final Class<Object> apply() {
                                return Class.forName(this.clazz$1);
                            }
                            {
                                this.clazz$1 = clazz$1;
                            }
                        });
                        if (try_ instanceof Failure) {
                            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", ". ", " can't be found for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MqttConfigConstants$.MODULE$.KCQL_CONFIG(), clazz, mqtt_source})));
                        }
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Class clz = (Class)success.value();
                            if (Converter.class.isAssignableFrom(clz)) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                return;
                            }
                            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", ". ", " is not inheriting Converter for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MqttConfigConstants$.MODULE$.KCQL_CONFIG(), clazz, mqtt_source})));
                        }
                        throw new MatchError((Object)try_);
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Integer qs = config.getInt(MqttConfigConstants$.MODULE$.QS_CONFIG());
            if (Predef$.MODULE$.Integer2int(qs) < 0 || Predef$.MODULE$.Integer2int(qs) > 2) {
                throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not valid. Can be 0,1 or 2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MqttConfigConstants$.MODULE$.QS_CONFIG()})));
            }
            return new MqttSourceSettings(connection, (Option<String>)user, (Option<String>)password, clientId, (Map<String, String>)converters, Predef$.MODULE$.Boolean2boolean(config.getBoolean(MqttConfigConstants$.MODULE$.THROW_ON_CONVERT_ERRORS_CONFIG())), kcqlStr, Predef$.MODULE$.Integer2int(qs), Predef$.MODULE$.Integer2int(config.getInt(MqttConfigConstants$.MODULE$.CONNECTION_TIMEOUT_CONFIG())), Predef$.MODULE$.Integer2int(config.getInt(MqttConfigConstants$.MODULE$.POLLING_TIMEOUT_CONFIG())), Predef$.MODULE$.Boolean2boolean(config.getBoolean(MqttConfigConstants$.MODULE$.CLEAN_SESSION_CONFIG())), Predef$.MODULE$.Integer2int(config.getInt(MqttConfigConstants$.MODULE$.KEEP_ALIVE_INTERVAL_CONFIG())), (Option<String>)sslCACertFile, (Option<String>)sslCertFile, (Option<String>)sslCertKeyFile, Predef$.MODULE$.Boolean2boolean(progressEnabled));
        }
        throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't define one of the ", ",", ", ", " without the other"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MqttConfigConstants$.MODULE$.SSL_CA_CERT_CONFIG(), MqttConfigConstants$.MODULE$.SSL_CERT_CONFIG(), MqttConfigConstants$.MODULE$.SSL_CERT_KEY_CONFIG()})));
    }

    public boolean apply$default$16() {
        return MqttConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED_DEFAULT();
    }

    public MqttSourceSettings apply(String connection, Option<String> user, Option<String> password, String clientId, Map<String, String> sourcesToConverters, boolean throwOnConversion, String[] kcql, int mqttQualityOfService, int connectionTimeout, int pollingTimeout, boolean cleanSession, int keepAliveInterval, Option<String> sslCACertFile, Option<String> sslCertFile, Option<String> sslCertKeyFile, boolean enableProgress) {
        return new MqttSourceSettings(connection, user, password, clientId, sourcesToConverters, throwOnConversion, kcql, mqttQualityOfService, connectionTimeout, pollingTimeout, cleanSession, keepAliveInterval, sslCACertFile, sslCertFile, sslCertKeyFile, enableProgress);
    }

    public Option<Tuple16<String, Option<String>, Option<String>, String, Map<String, String>, Object, String[], Object, Object, Object, Object, Object, Option<String>, Option<String>, Option<String>, Object>> unapply(MqttSourceSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple16((Object)x$0.connection(), x$0.user(), x$0.password(), (Object)x$0.clientId(), x$0.sourcesToConverters(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.throwOnConversion()), (Object)x$0.kcql(), (Object)BoxesRunTime.boxToInteger((int)x$0.mqttQualityOfService()), (Object)BoxesRunTime.boxToInteger((int)x$0.connectionTimeout()), (Object)BoxesRunTime.boxToInteger((int)x$0.pollingTimeout()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.cleanSession()), (Object)BoxesRunTime.boxToInteger((int)x$0.keepAliveInterval()), x$0.sslCACertFile(), x$0.sslCertFile(), x$0.sslCertKeyFile(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.enableProgress())));
    }

    public boolean $lessinit$greater$default$16() {
        return MqttConfigConstants$.MODULE$.PROGRESS_COUNTER_ENABLED_DEFAULT();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Option getFile$1(String configKey, MqttSourceConfig config$1) {
        return Option$.MODULE$.apply((Object)config$1.getString(configKey));
    }

    private MqttSourceSettings$() {
        MODULE$ = this;
    }
}

