/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.mqtt.connection;

import com.datamountaineer.streamreactor.connect.mqtt.config.MqttSinkSettings;
import com.datamountaineer.streamreactor.connect.mqtt.config.MqttSourceSettings;
import com.datamountaineer.streamreactor.connect.mqtt.source.MqttSSLSocketFactory$;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class MqttClientConnectionFn$
implements StrictLogging {
    public static final MqttClientConnectionFn$ MODULE$;
    private final Logger logger;

    static {
        new MqttClientConnectionFn$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public MqttConnectOptions apply(MqttSourceSettings settings) {
        return this.buildBaseClient(settings.connectionTimeout(), settings.keepAliveInterval(), settings.cleanSession(), settings.user(), settings.password(), settings.sslCertFile(), settings.sslCACertFile(), settings.sslCertKeyFile());
    }

    /*
     * WARNING - void declaration
     */
    public MqttClient apply(MqttSinkSettings settings) {
        void var3_3;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        MqttConnectOptions options = this.buildBaseClient(settings.connectionTimeout(), settings.keepAliveInterval(), settings.cleanSession(), settings.user(), settings.password(), settings.sslCertFile(), settings.sslCACertFile(), settings.sslCertKeyFile());
        MqttClient c = new MqttClient(settings.connection(), settings.clientId(), (MqttClientPersistence)new MemoryPersistence());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connecting to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{settings.connection()})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        c.connect(options);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to ", " as ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{settings.connection(), settings.clientId()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public MqttConnectOptions buildBaseClient(int connectionTimeout, int keepAliveInterval, boolean cleanSession, Option<String> username, Option<String> password, Option<String> sslCertFile, Option<String> sslCACertFile, Option<String> sslCertKeyFile) {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setConnectionTimeout(connectionTimeout);
        options.setKeepAliveInterval(keepAliveInterval);
        options.setCleanSession(cleanSession);
        username.foreach((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final MqttConnectOptions options$1;

            public final void apply(String n) {
                this.options$1.setUserName(n);
            }
            {
                this.options$1 = options$1;
            }
        });
        password.foreach((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final MqttConnectOptions options$1;

            public final void apply(String p) {
                this.options$1.setPassword(p.toCharArray());
            }
            {
                this.options$1 = options$1;
            }
        });
        options.setAutomaticReconnect(true);
        sslCertFile.foreach((Function1)new Serializable(sslCertFile, sslCACertFile, sslCertKeyFile, options){
            public static final long serialVersionUID = 0L;
            private final Option sslCertFile$1;
            private final Option sslCACertFile$1;
            private final Option sslCertKeyFile$1;
            private final MqttConnectOptions options$1;

            public final void apply(String x$1) {
                this.options$1.setSocketFactory((SocketFactory)MqttSSLSocketFactory$.MODULE$.apply((String)this.sslCACertFile$1.get(), (String)this.sslCertFile$1.get(), (String)this.sslCertKeyFile$1.get(), ""));
            }
            {
                this.sslCertFile$1 = sslCertFile$1;
                this.sslCACertFile$1 = sslCACertFile$1;
                this.sslCertKeyFile$1 = sslCertKeyFile$1;
                this.options$1 = options$1;
            }
        });
        return options;
    }

    private MqttClientConnectionFn$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

