/*
 * Decompiled with CFR 0.152.
 */
package com.datamountaineer.streamreactor.connect.mqtt.source;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import java.io.FileReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import scala.runtime.BoxedUnit;

public final class MqttSSLSocketFactory$
implements StrictLogging {
    public static final MqttSSLSocketFactory$ MODULE$;
    private final Logger logger;

    static {
        new MqttSSLSocketFactory$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public SSLSocketFactory apply(String caCrtFile, String crtFile, String keyFile, String password) {
        SSLSocketFactory sSLSocketFactory;
        try {
            KeyPair keyPair;
            Security.addProvider((Provider)new BouncyCastleProvider());
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            PEMParser reader = new PEMParser((Reader)new FileReader(caCrtFile));
            X509CertificateHolder caCertHolder = (X509CertificateHolder)reader.readObject();
            reader.close();
            X509Certificate caCert = certificateConverter.getCertificate(caCertHolder);
            reader = new PEMParser((Reader)new FileReader(crtFile));
            X509CertificateHolder certHolder = (X509CertificateHolder)reader.readObject();
            reader.close();
            X509Certificate cert = certificateConverter.getCertificate(certHolder);
            reader = new PEMParser((Reader)new FileReader(keyFile));
            Object keyObject = reader.readObject();
            reader.close();
            PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
            Object object = keyObject;
            if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair pEMEncryptedKeyPair = (PEMEncryptedKeyPair)object;
                keyPair = keyConverter.getKeyPair(pEMEncryptedKeyPair.decryptKeyPair(provider));
            } else {
                keyPair = keyConverter.getKeyPair((PEMKeyPair)keyObject);
            }
            KeyPair key = keyPair;
            KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            caKeyStore.load(null, null);
            caKeyStore.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            clientKeyStore.load(null, null);
            clientKeyStore.setCertificateEntry("certificate", cert);
            clientKeyStore.setKeyEntry("private-key", key.getPrivate(), password.toCharArray(), (Certificate[])((Object[])new Certificate[]{cert}));
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            sSLSocketFactory = context.getSocketFactory();
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(exception.getMessage(), (Throwable)exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            sSLSocketFactory = null;
        }
        return sSLSocketFactory;
    }

    private MqttSSLSocketFactory$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

