package com.datarobot;

import com.datarobot.IAIClient;
import com.datarobot.IPredictionClient;
import com.datarobot.ILearningSessionClient;
import com.datarobot.impl.ApiConnection;
import com.datarobot.impl.StatusTask;
import com.datarobot.model.*;
import com.datarobot.impl.ClientException;
import com.datarobot.impl.DataRobotAIClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.datarobot.util.Action;
import org.apache.http.impl.io.ContentLengthInputStream;

import java.io.FileNotFoundException;

/**
 * The {@link IDataRobotAIClient} interface provides access to the
 * {@link DataRobotAIClient} endpoints.
 */
public interface IDataRobotAIClient {
    Action<HttpRequest, HttpResponse> getHttpMessageTransformer();

    void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer);

    ApiConnection getConnection();

    /**
     * The {@link IDatasetClient} interface provides access to {@link Dataset}
     * related endpoints
     */
    IDatasetClient data();

    /**
     * The {@link IStatusClient} interface provides access to {@link Status} related
     * endpoints
     */
    IStatusClient status();

    /**
     * The {@link ILearningSessionClient} interface provides access to
     * {@link LearningSession} related endpoints
     */
    ILearningSessionClient learning();

    /**
     * The {@link IPredictionClient} interface provides access to {@link Prediction}
     * related endpoints
     */
    IPredictionClient predictions();

    /**
     * The {@link IAIClient} interface provides access to {@link AI} related
     * endpoints.
     */
    IAIClient ais();

    /**
     * Test connectivity with the DataRobot AI API.
     *
     * @return Returns a {@link Ping Ping} object that will contain 'Pong' if
     *         connection was successful.
     * 
     * @throws ClientException when 4xx or 5xx response is received from server, or
     *                         errors in parsing the response.
     */
    Ping ping() throws ClientException;

    /**
     * Create an AI that will learn from past data to predict on new data. Note that
     * a {@link AI} is sometimes referred to as an AI
     * 
     * @param name The name of the AI
     * 
     * @return {@link AI}
     * 
     * @throws ClientException      when 4xx or 5xx response is received from
     *                              server, or errors in parsing the response.
     * @throws InterruptedException when a thread is waiting, sleeping, or otherwise
     *                              occupied, and the thread is interrupted, either
     *                              before or during the activity.
     */
    AI createAI(String name) throws ClientException, InterruptedException;

}
