package com.datarobot;

import com.datarobot.impl.ClientException;
import com.datarobot.model.Deployment;
import com.datarobot.model.Prediction;
import com.datarobot.ILearningSessionClient;
import com.datarobot.model.PredictionList;
import com.datarobot.model.AI;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;

import java.io.FileNotFoundException;
import java.io.InputStream;

/**
 * The {@link IPredictionClient IPredictionClient} interface provides access to
 * {@link Prediction} related endpoints for the AI API
 */
public interface IPredictionClient {
    Action<HttpRequest, HttpResponse> getHttpMessageTransformer();

    void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer);

    // Using sourceFile for now - TODO = add functionality for sending non-file
    // based data (list)
    /**
     * Send a prediction request to the specified deployment
     * 
     * @param deployment Who will service the request
     * @param sourceFile The data on which to predict via a filepath on the local
     *                   system
     * 
     * @return {@link PredictionList}
     * 
     * @throws ClientException       when 4xx or 5xx response is received from
     *                               server, or errors in parsing the response.
     * @throws FileNotFoundException when a file with the specified pathname does
     *                               not exist, or if the file does exist but is
     *                               inaccessible for some reason.
     */
    PredictionList deploymentPredict(Deployment deployment, String sourceFile)
            throws ClientException, FileNotFoundException;

    // Using sourceFile for now - TODO = add functionality for sending non-file
    // based data (list)
    /**
     * Retrieve AI predictions against data. Note an AI must be trained with
     * {@link AI#learn} or an existing learning session must be added to the AI with
     * {@link AI#addLearningSession} or {@link IAIClient#addLearningSession} before
     * predictions can occur.
     * 
     * @param aiId       The ID of the AI which to predict on
     * @param target     The name of the selected target feature to predict
     * @param sourceFile The data on which to predict via a filepath on the local
     *                   system
     * 
     * @return {@link PredictionList}
     * 
     * @throws ClientException       when 4xx or 5xx response is received from
     *                               server, or errors in parsing the response.
     * @throws FileNotFoundException when a file with the specified pathname does
     *                               not exist, or if the file does exist but is
     *                               inaccessible for some reason.
     */
    PredictionList aiPredict(String aiId, String target, String sourceFile)
            throws ClientException, FileNotFoundException;
}
