package com.datarobot;

import com.datarobot.impl.ClientException;
import com.datarobot.model.PagingParams;
import com.datarobot.model.Status;
import com.datarobot.model.StatusList;
import com.datarobot.util.Action;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;

/**
 * The {@link IStatusClient IStatusClient} interface provides access to
 * {@link Status} related endpoints for the AI API
 */
public interface IStatusClient {
    Action<HttpRequest, HttpResponse> getHttpMessageTransformer();

    void setHttpMessageTransformer(Action<HttpRequest, HttpResponse> httpMessageTransformer);

    /**
     * A list with status information on all {@link Status} currently running for
     * this account
     * 
     * @return {@link StatusList}
     * 
     * @throws ClientException when 4xx or 5xx response is received from server, or
     *                         errors in parsing the response.
     */
    StatusList list() throws ClientException;

    /**
     * A list with status information on all {@link Status} currently running for
     * this account
     * 
     * @param params The {@link PagingParams} object for this list
     * 
     * @return {@link StatusList}
     * 
     * @throws ClientException when 4xx or 5xx response is received from server, or
     *                         errors in parsing the response.
     */
    StatusList list(PagingParams params) throws ClientException;

    /**
     * Get a status object by ID
     * 
     * @param statusId The ID of the {@link Status}
     * 
     * @return The queried {@link Status} object
     * 
     * @throws ClientException when 4xx or 5xx response is received from server, or
     *                         errors in parsing the response.
     */
    Status get(String statusId) throws ClientException;
}
