package com.datarobot.impl;

import com.datarobot.model.DatasetStreamSource;
import com.datarobot.model.DatasetUrlSource;
import com.datarobot.model.IDatasetSource;

import java.io.InputStream;
import java.net.URI;

public class DatasetFrom {
    /**
     * Create a Data Source from a text/csv stream
     *
     * @param name      The name of the DataSet to be created
     * @param stream    The stream containing the data
     * @return Returns an IDataSetSource constructed from the name and stream
     */
    public static IDatasetSource from(String name, InputStream stream)
    {
        return new DatasetStreamSource(name, stream);
    }

    /**
     * Create a Data Source from a URL that contains a CSV file.
     *
     * @param name      The name of the DataSet to be created
     * @param uri       The public URI endpoint where the data resides
     * @return Returns an IDataSetSource constructed from the name and URI
     */
    public static IDatasetSource from(String name, URI uri)
    {
        return new DatasetUrlSource(name, uri);
    }
}
