package com.datarobot.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * internal
 */
public class AIBody implements Serializable {
	private static final long serialVersionUID = 4104982903045395589L;

	// Need to confirm if this is being sent regardless or if we need an annotation similar to the below
	@JsonInclude(value=Include.NON_EMPTY, content= Include.NON_NULL)
	@JsonProperty("name")
	private String name;
	
	@JsonInclude(value=Include.NON_EMPTY, content= Include.NON_NULL)
	@JsonProperty("learningSessionId")
	private String learningSessionId;
	
	@JsonInclude(value=Include.NON_EMPTY, content= Include.NON_NULL)
	@JsonProperty("outputName")
	private String outputName;
	
	@JsonInclude(value=Include.NON_EMPTY, content= Include.NON_NULL)
	@JsonProperty("datasetId")
	private String datasetId;
	
	@JsonInclude(value=Include.NON_EMPTY, content= Include.NON_NULL)
	@JsonProperty("aiId")
	private String aiId;
		
	@JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();
	
	// Hacky constructor (will refactor in follow up)
	//	- type 1: value is name for ais().createAI()
	//  - type 2: value is datasetId for ais().addDataset()
	//  - type 3: value is aiId for ais().getLearningSessions()
	public AIBody(String value, int type) {
		if (type == 1) {
			this.name = value;
		}
		else if (type == 2) {
			this.datasetId = value;
	    }
		else if (type == 3) {
			this.aiId = value;
		}
	}
	
	// Constructor for ais().createAI()
	public AIBody() {
		
	}
	
	// Constructor for ais().addLearningSession
	public AIBody(String learningSessionId, String outputName) {
		this.learningSessionId = learningSessionId;
		this.outputName = outputName;
	}
	
	public String getName() {
		return this.name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	// Carry over from Dataset Param classes - not for sure if these are necessary at this point, will confirm in follow up
	@JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

	// Carry over from Dataset Param classes - not for sure if these are necessary at this point, will confirm in follow up
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
    
    // Carry over from Learn Param class - not sure if this is necessary at this point, will confirm in follow up
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(name)
                .toHashCode();
    }
    
    // Carry over from Learn Param class - not sure if this is necessary at this point, will confirm in follow up
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AIBody) == false) {
            return false;
        }
        AIBody rhs = ((AIBody) other);
        return new EqualsBuilder()
                .append(name, rhs.name)
                .isEquals();
    }
    
    public Map<String,Object> toParameters() {
        Map<String,Object> parameters = new HashMap<>();
        parameters.put("aiId", this.aiId);
        return parameters;
    }
	
	

}
