package com.datarobot.model;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.datarobot.impl.ClientException;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * internal
 */
public class AICreationResponse {
	
	private Pattern currentIdPattern = Pattern.compile("ais/([a-f\\d-]{24,36})/$");
	private String aiId;
	private String aiUrl;
	
    @JsonProperty("links")
    private void unpack(Map<String, String> links) throws ClientException {
  	  this.aiUrl = (String)links.get("result");
  	  this.aiId = parseAiId(aiUrl);
    }
    
    public String getAIId() {
    	return this.aiId;
    }
    
    public void setAIId(String aiId) {
    	this.aiId = aiId;
    }
    
    private String parseAiId(String statusUrl) throws ClientException {
      Matcher matchId = currentIdPattern.matcher(aiUrl);
      if (!matchId.find()) {
          throw new ClientException("Invalid id in redirect header.");
      }
      return matchId.group(1);
  }

}
